/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmActionImport;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmAnnotations;
import org.apache.olingo.commons.api.edm.EdmAnnotationsTarget;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmSchema;
import org.apache.olingo.commons.api.edm.EdmSingleton;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotations;
import org.apache.olingo.commons.core.edm.EdmAnnotationImpl;

public class EdmAnnotationsImpl
implements EdmAnnotations {
    private final Edm edm;
    private final EdmSchema schema;
    private final CsdlAnnotations annotationGroup;
    private EdmAnnotationsTarget target;
    private List<EdmAnnotation> annotations;

    public EdmAnnotationsImpl(Edm edm, EdmSchema schema, CsdlAnnotations annotationGroup) {
        this.edm = edm;
        this.schema = schema;
        this.annotationGroup = annotationGroup;
    }

    private EdmAnnotationsTarget getTarget(EdmStructuredType structured, String path) {
        EdmAnnotationsTarget _target = null;
        if (structured != null && (_target = (EdmAnnotationsTarget)(path == null ? structured : structured.getStructuralProperty(path))) == null) {
            _target = structured.getNavigationProperty(path);
        }
        return _target;
    }

    private EdmAnnotationsTarget getTarget(EdmEnumType enumType, String path) {
        EdmEnumType _target = null;
        if (enumType != null) {
            _target = path == null ? enumType : enumType.getMember(path);
        }
        return _target;
    }

    public EdmAnnotationsTarget getTarget() {
        if (this.target == null) {
            EdmActionImport localTarget;
            String[] splitted = StringUtils.split((String)this.annotationGroup.getTarget(), (char)'/');
            FullQualifiedName base = new FullQualifiedName(splitted[0]);
            String path = splitted.length > 1 ? splitted[1] : null;
            EdmEntityContainer baseEntityContainer = this.schema.getEntityContainer();
            EdmActionImport edmActionImport = localTarget = baseEntityContainer == null ? null : baseEntityContainer.getActionImport(path);
            if (localTarget == null && (localTarget = this.getTarget((EdmStructuredType)this.edm.getComplexType(base), path)) == null) {
                if (baseEntityContainer != null && baseEntityContainer.getFullQualifiedName().equals((Object)base)) {
                    localTarget = baseEntityContainer;
                }
                if (localTarget == null) {
                    EdmEntitySet edmEntitySet = localTarget = baseEntityContainer == null ? null : baseEntityContainer.getEntitySet(path);
                    if (localTarget == null && (localTarget = this.getTarget((EdmStructuredType)this.edm.getEntityType(base), path)) == null && (localTarget = this.getTarget(this.edm.getEnumType(base), path)) == null) {
                        EdmFunctionImport edmFunctionImport = localTarget = baseEntityContainer == null ? null : baseEntityContainer.getFunctionImport(path);
                        if (localTarget == null) {
                            EdmSingleton edmSingleton = localTarget = baseEntityContainer == null ? null : baseEntityContainer.getSingleton(path);
                            if (localTarget == null && (localTarget = this.edm.getTerm(base)) == null) {
                                localTarget = this.edm.getTypeDefinition(base);
                            }
                        }
                    }
                }
            }
            this.target = localTarget;
        }
        return this.target;
    }

    public String getQualifier() {
        return this.annotationGroup.getQualifier();
    }

    public EdmAnnotation getAnnotation(EdmTerm term) {
        EdmAnnotation result = null;
        for (EdmAnnotation annotation : this.getAnnotations()) {
            if (!term.getFullQualifiedName().equals((Object)annotation.getTerm().getFullQualifiedName())) continue;
            result = annotation;
        }
        return result;
    }

    public List<EdmAnnotation> getAnnotations() {
        if (this.annotations == null) {
            ArrayList<EdmAnnotationImpl> annotationsLocal = new ArrayList<EdmAnnotationImpl>();
            for (CsdlAnnotation annotation : this.annotationGroup.getAnnotations()) {
                annotationsLocal.add(new EdmAnnotationImpl(this.edm, annotation));
            }
            this.annotations = Collections.unmodifiableList(annotationsLocal);
        }
        return this.annotations;
    }
}

