/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmAnnotations;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmSchema;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.EdmTypeDefinition;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlAction;
import org.apache.olingo.commons.api.edm.provider.CsdlAliasInfo;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotatable;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotations;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainerInfo;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlEnumType;
import org.apache.olingo.commons.api.edm.provider.CsdlFunction;
import org.apache.olingo.commons.api.edm.provider.CsdlParameter;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.api.edm.provider.CsdlTerm;
import org.apache.olingo.commons.api.edm.provider.CsdlTypeDefinition;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.commons.core.edm.AbstractEdm;
import org.apache.olingo.commons.core.edm.EdmActionImpl;
import org.apache.olingo.commons.core.edm.EdmAnnotationImpl;
import org.apache.olingo.commons.core.edm.EdmAnnotationsImpl;
import org.apache.olingo.commons.core.edm.EdmComplexTypeImpl;
import org.apache.olingo.commons.core.edm.EdmEntityContainerImpl;
import org.apache.olingo.commons.core.edm.EdmEntityTypeImpl;
import org.apache.olingo.commons.core.edm.EdmEnumTypeImpl;
import org.apache.olingo.commons.core.edm.EdmFunctionImpl;
import org.apache.olingo.commons.core.edm.EdmSchemaImpl;
import org.apache.olingo.commons.core.edm.EdmTermImpl;
import org.apache.olingo.commons.core.edm.EdmTypeDefinitionImpl;

public class EdmProviderImpl
extends AbstractEdm {
    private final CsdlEdmProvider provider;
    private final Map<FullQualifiedName, List<CsdlAction>> actionsMap = Collections.synchronizedMap(new HashMap());
    private final Map<FullQualifiedName, List<CsdlFunction>> functionsMap = Collections.synchronizedMap(new HashMap());

    public EdmProviderImpl(CsdlEdmProvider provider) {
        this.provider = provider;
    }

    @Override
    public EdmEntityContainer createEntityContainer(FullQualifiedName containerName) {
        try {
            CsdlEntityContainerInfo entityContainerInfo = this.provider.getEntityContainerInfo(containerName);
            if (entityContainerInfo != null) {
                return new EdmEntityContainerImpl((Edm)this, this.provider, entityContainerInfo);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    @Override
    public EdmEnumType createEnumType(FullQualifiedName enumName) {
        try {
            CsdlEnumType enumType = this.provider.getEnumType(enumName);
            if (enumType != null) {
                return new EdmEnumTypeImpl((Edm)this, enumName, enumType);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    @Override
    public EdmTypeDefinition createTypeDefinition(FullQualifiedName typeDefinitionName) {
        try {
            CsdlTypeDefinition typeDefinition = this.provider.getTypeDefinition(typeDefinitionName);
            if (typeDefinition != null) {
                return new EdmTypeDefinitionImpl((Edm)this, typeDefinitionName, typeDefinition);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    @Override
    public EdmEntityType createEntityType(FullQualifiedName entityTypeName) {
        try {
            CsdlEntityType entityType = this.provider.getEntityType(entityTypeName);
            if (entityType != null) {
                return new EdmEntityTypeImpl((Edm)this, entityTypeName, entityType);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    @Override
    public EdmComplexType createComplexType(FullQualifiedName complexTypeName) {
        try {
            CsdlComplexType complexType = this.provider.getComplexType(complexTypeName);
            if (complexType != null) {
                return new EdmComplexTypeImpl((Edm)this, complexTypeName, complexType);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    @Override
    public EdmAction createBoundAction(FullQualifiedName actionName, FullQualifiedName bindingParameterTypeName, Boolean isBindingParameterCollection) {
        try {
            List actions = this.actionsMap.get(actionName);
            if (actions == null) {
                actions = this.provider.getActions(actionName);
                if (actions == null) {
                    return null;
                }
                this.actionsMap.put(actionName, actions);
            }
            for (CsdlAction action : actions) {
                List parameters;
                CsdlParameter parameter;
                if (!action.isBound() || !bindingParameterTypeName.equals((Object)(parameter = (CsdlParameter)(parameters = action.getParameters()).get(0)).getTypeFQN()) || isBindingParameterCollection.booleanValue() != parameter.isCollection()) continue;
                return new EdmActionImpl((Edm)this, actionName, action);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    @Override
    public EdmFunction createBoundFunction(FullQualifiedName functionName, FullQualifiedName bindingParameterTypeName, Boolean isBindingParameterCollection, List<String> parameterNames) {
        try {
            List functions = this.functionsMap.get(functionName);
            if (functions == null) {
                functions = this.provider.getFunctions(functionName);
                if (functions == null) {
                    return null;
                }
                this.functionsMap.put(functionName, functions);
            }
            List<Object> parameterNamesCopy = parameterNames == null ? Collections.emptyList() : parameterNames;
            for (CsdlFunction function : functions) {
                if (!function.isBound()) continue;
                List providerParameters = function.getParameters();
                if (providerParameters == null || providerParameters.size() == 0) {
                    throw new EdmException("No parameter specified for bound function: " + functionName);
                }
                CsdlParameter bindingParameter = (CsdlParameter)providerParameters.get(0);
                if (!bindingParameterTypeName.equals((Object)bindingParameter.getTypeFQN()) || isBindingParameterCollection.booleanValue() != bindingParameter.isCollection() || parameterNamesCopy.size() != providerParameters.size() - 1) continue;
                ArrayList<String> providerParameterNames = new ArrayList<String>();
                for (int i = 1; i < providerParameters.size(); ++i) {
                    providerParameterNames.add(((CsdlParameter)providerParameters.get(i)).getName());
                }
                if (!parameterNamesCopy.containsAll(providerParameterNames)) continue;
                return new EdmFunctionImpl((Edm)this, functionName, function);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    @Override
    protected Map<String, String> createAliasToNamespaceInfo() {
        HashMap<String, String> aliasToNamespaceInfos = new HashMap<String, String>();
        try {
            List aliasInfos = this.provider.getAliasInfos();
            if (aliasInfos != null) {
                for (CsdlAliasInfo info : aliasInfos) {
                    aliasToNamespaceInfos.put(info.getAlias(), info.getNamespace());
                }
            }
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
        return aliasToNamespaceInfos;
    }

    @Override
    protected EdmAction createUnboundAction(FullQualifiedName actionName) {
        try {
            List actions = this.actionsMap.get(actionName);
            if (actions == null) {
                actions = this.provider.getActions(actionName);
                if (actions == null) {
                    return null;
                }
                this.actionsMap.put(actionName, actions);
            }
            for (CsdlAction action : actions) {
                if (action.isBound()) continue;
                return new EdmActionImpl((Edm)this, actionName, action);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    @Override
    protected List<EdmFunction> createUnboundFunctions(FullQualifiedName functionName) {
        ArrayList<EdmFunction> result = new ArrayList<EdmFunction>();
        try {
            List functions = this.functionsMap.get(functionName);
            if (functions == null && (functions = this.provider.getFunctions(functionName)) != null) {
                this.functionsMap.put(functionName, functions);
            }
            if (functions != null) {
                for (CsdlFunction function : functions) {
                    if (function.isBound()) continue;
                    result.add(new EdmFunctionImpl((Edm)this, functionName, function));
                }
            }
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
        return result;
    }

    @Override
    protected EdmFunction createUnboundFunction(FullQualifiedName functionName, List<String> parameterNames) {
        try {
            List functions = this.functionsMap.get(functionName);
            if (functions == null) {
                functions = this.provider.getFunctions(functionName);
                if (functions == null) {
                    return null;
                }
                this.functionsMap.put(functionName, functions);
            }
            List<Object> parameterNamesCopy = parameterNames == null ? Collections.emptyList() : parameterNames;
            for (CsdlFunction function : functions) {
                if (function.isBound()) continue;
                List<CsdlParameter> providerParameters = function.getParameters();
                if (providerParameters == null) {
                    providerParameters = Collections.emptyList();
                }
                if (parameterNamesCopy.size() != providerParameters.size()) continue;
                ArrayList<String> functionParameterNames = new ArrayList<String>();
                for (CsdlParameter parameter : providerParameters) {
                    functionParameterNames.add(parameter.getName());
                }
                if (!parameterNamesCopy.containsAll(functionParameterNames)) continue;
                return new EdmFunctionImpl((Edm)this, functionName, function);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    @Override
    protected Map<String, EdmSchema> createSchemas() {
        try {
            LinkedHashMap<String, EdmSchema> providerSchemas = new LinkedHashMap<String, EdmSchema>();
            List localSchemas = this.provider.getSchemas();
            if (localSchemas != null) {
                for (CsdlSchema schema : localSchemas) {
                    providerSchemas.put(schema.getNamespace(), new EdmSchemaImpl(this, this.provider, schema));
                }
            }
            return providerSchemas;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    @Override
    protected EdmTerm createTerm(FullQualifiedName termName) {
        try {
            CsdlTerm providerTerm = this.provider.getTerm(termName);
            if (providerTerm != null) {
                return new EdmTermImpl((Edm)this, termName.getNamespace(), providerTerm);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    @Override
    protected EdmAnnotations createAnnotationGroup(FullQualifiedName targetName) {
        try {
            EdmSchema schema = this.getSchema(targetName.getNamespace());
            CsdlAnnotations providerGroup = this.provider.getAnnotationsGroup(targetName);
            if (providerGroup != null) {
                return new EdmAnnotationsImpl(this, schema, providerGroup);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    @Override
    protected List<EdmAnnotation> createAnnotations(FullQualifiedName annotatedName) {
        try {
            CsdlAnnotatable providerAnnotatable = this.provider.getAnnotatable(annotatedName);
            if (providerAnnotatable != null && providerAnnotatable.getAnnotations() != null) {
                ArrayList<EdmAnnotation> result = new ArrayList<EdmAnnotation>();
                for (CsdlAnnotation annotation : providerAnnotatable.getAnnotations()) {
                    this.getTerm(new FullQualifiedName(annotation.getTerm()));
                    result.add(new EdmAnnotationImpl((Edm)this, annotation));
                }
                return result;
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }
}

