/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import java.math.BigDecimal;
import java.util.regex.Pattern;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.edm.primitivetype.EdmByte;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDecimal;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt16;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt32;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt64;
import org.apache.olingo.commons.core.edm.primitivetype.EdmSByte;
import org.apache.olingo.commons.core.edm.primitivetype.EdmSingle;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;
import org.apache.olingo.commons.core.edm.primitivetype.Uint7;

public final class EdmDouble
extends SingletonPrimitiveType {
    protected static final String NEGATIVE_INFINITY = "-INF";
    protected static final String POSITIVE_INFINITY = "INF";
    protected static final String NaN = "NaN";
    private static final Pattern PATTERN = Pattern.compile("(?:\\+|-)?\\p{Digit}{1,17}(?:\\.\\p{Digit}{1,17})?(?:(?:E|e)(?:\\+|-)?\\p{Digit}{1,3})?");
    private static final EdmDouble INSTANCE = new EdmDouble();

    public static EdmDouble getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean isCompatible(EdmPrimitiveType primitiveType) {
        return primitiveType instanceof Uint7 || primitiveType instanceof EdmByte || primitiveType instanceof EdmSByte || primitiveType instanceof EdmInt16 || primitiveType instanceof EdmInt32 || primitiveType instanceof EdmInt64 || primitiveType instanceof EdmSingle || primitiveType instanceof EdmDouble;
    }

    public Class<?> getDefaultType() {
        return Double.class;
    }

    @Override
    protected <T> T internalValueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        Double result = null;
        BigDecimal bigDecimalValue = null;
        if (value.equals(NEGATIVE_INFINITY)) {
            result = Double.NEGATIVE_INFINITY;
        } else if (value.equals(POSITIVE_INFINITY)) {
            result = Double.POSITIVE_INFINITY;
        } else if (value.equals(NaN)) {
            result = Double.NaN;
        } else {
            if (!PATTERN.matcher(value).matches()) {
                throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.");
            }
            bigDecimalValue = new BigDecimal(value);
            result = bigDecimalValue.doubleValue();
            if (result.isInfinite() || BigDecimal.valueOf(result).compareTo(bigDecimalValue) != 0) {
                throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.");
            }
        }
        if (returnType.isAssignableFrom(Double.class)) {
            return returnType.cast(result);
        }
        if (result.isInfinite() || result.isNaN()) {
            if (returnType.isAssignableFrom(Float.class)) {
                return returnType.cast(Float.valueOf(result.floatValue()));
            }
            throw new EdmPrimitiveTypeException("The literal '" + value + "' cannot be converted to value type " + returnType + ".");
        }
        try {
            return EdmDecimal.convertDecimal(bigDecimalValue, returnType);
        }
        catch (IllegalArgumentException e) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' cannot be converted to value type " + returnType + ".", (Exception)e);
        }
        catch (ClassCastException e) {
            throw new EdmPrimitiveTypeException("The value type " + returnType + " is not supported.", (Exception)e);
        }
    }

    @Override
    protected <T> String internalValueToString(T value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        if (value instanceof Long) {
            if (Math.abs((Long)value) < 0x8000000000000L) {
                return value.toString();
            }
            throw new EdmPrimitiveTypeException("The value '" + value + "' is not valid.");
        }
        if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            return value.toString();
        }
        if (value instanceof Double) {
            return (Double)value == Double.NEGATIVE_INFINITY ? NEGATIVE_INFINITY : ((Double)value == Double.POSITIVE_INFINITY ? POSITIVE_INFINITY : value.toString());
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue() == Float.NEGATIVE_INFINITY ? NEGATIVE_INFINITY : (((Float)value).floatValue() == Float.POSITIVE_INFINITY ? POSITIVE_INFINITY : value.toString());
        }
        if (value instanceof BigDecimal) {
            double doubleValue = ((BigDecimal)value).doubleValue();
            if (!Double.isInfinite(doubleValue) && BigDecimal.valueOf(doubleValue).compareTo((BigDecimal)value) == 0) {
                return value.toString();
            }
            throw new EdmPrimitiveTypeException("The value '" + value + "' is not valid.");
        }
        throw new EdmPrimitiveTypeException("The value type " + value.getClass() + " is not supported.");
    }
}

