/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.service;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.commons.api.data.Entity;
import org.teiid.odata.api.QueryResponse;
import org.teiid.olingo.ComplexReturnType;
import org.teiid.olingo.service.CrossJoinNode;
import org.teiid.olingo.service.DocumentNode;
import org.teiid.olingo.service.EntityCollectionResponse;

public class CrossJoinResult
implements QueryResponse {
    private final String invalidCharacterReplacement;
    private String nextToken;
    private CrossJoinNode documentNode;
    private List<List<ComplexReturnType>> out = new ArrayList<List<ComplexReturnType>>();

    public CrossJoinResult(String invalidCharacterReplacement, CrossJoinNode context) {
        this.invalidCharacterReplacement = invalidCharacterReplacement;
        this.documentNode = context;
    }

    @Override
    public void addRow(ResultSet rs) throws SQLException {
        ArrayList<ComplexReturnType> row = new ArrayList<ComplexReturnType>();
        Entity entity = EntityCollectionResponse.createEntity(rs, this.documentNode, this.invalidCharacterReplacement);
        row.add(new ComplexReturnType(this.documentNode.getTable().getName(), this.documentNode.getEdmEntityType(), entity, this.documentNode.hasExpand()));
        for (DocumentNode node : this.documentNode.getSibilings()) {
            Entity sibiling = EntityCollectionResponse.createEntity(rs, node, this.invalidCharacterReplacement);
            row.add(new ComplexReturnType(node.getTable().getName(), this.documentNode.getEdmEntityType(), sibiling, ((CrossJoinNode)node).hasExpand()));
        }
        this.out.add(row);
    }

    public CrossJoinNode getResource() {
        return this.documentNode;
    }

    public List<List<ComplexReturnType>> getResults() {
        return this.out;
    }

    @Override
    public long size() {
        return this.out.size();
    }

    @Override
    public void setCount(long count) {
    }

    @Override
    public void setNextToken(String token) {
        this.nextToken = token;
    }

    @Override
    public String getNextToken() {
        return this.nextToken;
    }
}

