/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.service;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.core.ServiceHandler;
import org.apache.olingo.server.core.ServiceRequest;
import org.apache.olingo.server.core.deserializer.json.ODataJsonDeserializer;
import org.apache.olingo.server.core.requests.ActionRequest;
import org.apache.olingo.server.core.requests.DataRequest;
import org.apache.olingo.server.core.requests.FunctionRequest;
import org.apache.olingo.server.core.requests.MediaRequest;
import org.apache.olingo.server.core.requests.MetadataRequest;
import org.apache.olingo.server.core.requests.OperationRequest;
import org.apache.olingo.server.core.requests.ServiceDocumentRequest;
import org.apache.olingo.server.core.responses.CountResponse;
import org.apache.olingo.server.core.responses.EntityResponse;
import org.apache.olingo.server.core.responses.EntitySetResponse;
import org.apache.olingo.server.core.responses.MetadataResponse;
import org.apache.olingo.server.core.responses.NoContentResponse;
import org.apache.olingo.server.core.responses.PrimitiveValueResponse;
import org.apache.olingo.server.core.responses.PropertyResponse;
import org.apache.olingo.server.core.responses.ServiceDocumentResponse;
import org.apache.olingo.server.core.responses.ServiceResponse;
import org.apache.olingo.server.core.responses.ServiceResponseVisior;
import org.apache.olingo.server.core.responses.StreamResponse;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.TransformationException;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.ReaderInputStream;
import org.teiid.logging.LogManager;
import org.teiid.metadata.MetadataStore;
import org.teiid.odata.api.BaseResponse;
import org.teiid.odata.api.Client;
import org.teiid.odata.api.QueryResponse;
import org.teiid.odata.api.UpdateResponse;
import org.teiid.olingo.EdmComplexResponse;
import org.teiid.olingo.ODataPlugin;
import org.teiid.olingo.service.CrossJoinNode;
import org.teiid.olingo.service.CrossJoinResult;
import org.teiid.olingo.service.EntityCollectionResponse;
import org.teiid.olingo.service.ODataSQLBuilder;
import org.teiid.olingo.service.OperationResponseImpl;
import org.teiid.olingo.service.ProcedureSQLBuilder;
import org.teiid.olingo.service.ReferenceUpdateSQLBuilder;
import org.teiid.query.function.source.XMLSystemFunctions;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.symbol.XMLSerialize;

public class TeiidServiceHandler
implements ServiceHandler {
    private static final String PREFERENCE_APPLIED = "Preference-Applied";
    private static final String ODATA_MAXPAGESIZE = "odata.maxpagesize";
    private boolean prepared = true;
    private OData odata;
    private ServiceMetadata serviceMetadata;
    private String schemaName;
    private UniqueNameGenerator nameGenerator = new UniqueNameGenerator();
    private static ThreadLocal<Client> CLIENT = new ThreadLocal<Client>(){

        @Override
        protected Client initialValue() {
            return null;
        }
    };

    public static Client getClient() {
        return CLIENT.get();
    }

    public static void setClient(Client client) {
        CLIENT.set(client);
    }

    public TeiidServiceHandler(String schemaName) {
        this.schemaName = schemaName;
    }

    public void init(OData odata, ServiceMetadata serviceMetadata) {
        this.odata = odata;
        this.serviceMetadata = serviceMetadata;
    }

    public void setPrepared(boolean flag) {
        this.prepared = flag;
    }

    public void readMetadata(MetadataRequest request, MetadataResponse response) throws ODataLibraryException, ODataApplicationException {
        response.writeMetadata();
    }

    public void readServiceDocument(ServiceDocumentRequest request, ServiceDocumentResponse response) throws ODataLibraryException, ODataApplicationException {
        response.writeServiceDocument(request.getODataRequest().getRawBaseUri());
    }

    public <T extends ServiceResponse> void read(final DataRequest request, T response) throws ODataLibraryException, ODataApplicationException {
        BaseResponse queryResponse;
        final ODataSQLBuilder visitor = new ODataSQLBuilder(TeiidServiceHandler.getClient().getMetadataStore(), this.prepared, true, request.getODataRequest().getRawBaseUri(), this.serviceMetadata, this.nameGenerator);
        visitor.visit(request.getUriInfo());
        try {
            Query query = visitor.selectQuery();
            queryResponse = this.executeQuery(request, visitor, query);
        }
        catch (Exception e) {
            throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), (Throwable)e);
        }
        response.accepts(new ServiceResponseVisior(){

            public void visit(CountResponse response) throws ODataLibraryException, ODataApplicationException {
                org.teiid.odata.api.CountResponse cr = (org.teiid.odata.api.CountResponse)queryResponse;
                response.writeCount(cr.getCount());
            }

            public void visit(PrimitiveValueResponse response) throws ODataLibraryException, ODataApplicationException {
                EdmProperty edmProperty;
                EntityCollection entitySet = (EntityCollection)queryResponse;
                Entity entity = (Entity)entitySet.getEntities().get(0);
                Property property = entity.getProperty((edmProperty = request.getUriResourceProperty().getProperty()).getName());
                if (property == null) {
                    response.writeNotFound(true);
                } else if (property.getValue() == null) {
                    response.writeNoContent(true);
                }
                response.write(property.getValue());
            }

            public void visit(PropertyResponse response) throws ODataLibraryException, ODataApplicationException {
                EntityCollection entitySet = (EntityCollection)queryResponse;
                if (!entitySet.getEntities().isEmpty()) {
                    Entity entity = (Entity)entitySet.getEntities().get(0);
                    EdmProperty edmProperty = request.getUriResourceProperty().getProperty();
                    Property property = entity.getProperty(edmProperty.getName());
                    response.writeProperty(edmProperty.getType(), property);
                } else {
                    response.writeNotFound(true);
                }
            }

            public void visit(StreamResponse response) throws ODataLibraryException, ODataApplicationException {
                EdmProperty edmProperty;
                EntityCollection entitySet = (EntityCollection)queryResponse;
                Entity entity = (Entity)entitySet.getEntities().get(0);
                Property property = entity.getProperty((edmProperty = request.getUriResourceProperty().getProperty()).getName());
                Object value = property.getValue();
                if (value == null) {
                    response.writeNoContent(true);
                } else {
                    try {
                        TeiidServiceHandler.this.handleLobResult(TeiidServiceHandler.getClient().getProperty("charset"), value, (ServiceResponse)response);
                    }
                    catch (SQLException e) {
                        LogManager.logDetail((String)"org.teiid.ODATA", (Object)e);
                        response.writeServerError(true);
                    }
                }
            }

            public void visit(EntityResponse response) throws ODataLibraryException, ODataApplicationException {
                EntityCollection entitySet = (EntityCollection)queryResponse;
                if (entitySet.getEntities().isEmpty()) {
                    response.writeNoContent(true);
                } else {
                    response.writeReadEntity(visitor.getContext().getEdmEntityType(), (Entity)entitySet.getEntities().get(0));
                }
            }

            public void visit(EntitySetResponse response) throws ODataLibraryException, ODataApplicationException {
                TeiidServiceHandler.this.sendResults(request, visitor, queryResponse, response);
            }
        });
    }

    private void sendResults(DataRequest request, ODataSQLBuilder visitor, BaseResponse queryResponse, EntitySetResponse response) throws ODataApplicationException, SerializerException {
        EntityCollectionResponse result;
        if (request.getPreference(ODATA_MAXPAGESIZE) != null) {
            response.writeHeader(PREFERENCE_APPLIED, "odata.maxpagesize=" + request.getPreference(ODATA_MAXPAGESIZE));
        }
        if ((result = (EntityCollectionResponse)queryResponse).getNextToken() != null) {
            try {
                String nextUri = request.getODataRequest().getRawBaseUri() + request.getODataRequest().getRawODataPath() + "?" + this.buildNextToken(request.getODataRequest().getRawQueryPath(), result.getNextToken());
                result.setNext(new URI(nextUri));
            }
            catch (URISyntaxException e) {
                throw new ODataApplicationException(e.getMessage(), 500, Locale.getDefault(), (Throwable)e);
            }
            catch (MalformedURLException e) {
                throw new ODataApplicationException(e.getMessage(), 500, Locale.getDefault(), (Throwable)e);
            }
        }
        response.writeReadEntitySet(visitor.getContext().getEdmEntityType(), (EntityCollection)result);
    }

    String buildNextToken(String queryPath, String nextToken) throws URISyntaxException, MalformedURLException {
        String[] pairs;
        StringBuilder sb = new StringBuilder();
        for (String pair : pairs = queryPath.split("&")) {
            int idx = pair.indexOf("=");
            String key = pair.substring(0, idx);
            if (key.equals("$skiptoken")) continue;
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(pair);
        }
        if (sb.length() > 0) {
            sb.append("&$skiptoken=").append(nextToken);
        } else {
            sb.append("$skiptoken=").append(nextToken);
        }
        return sb.toString();
    }

    private void sendResults(DataRequest request, ODataSQLBuilder visitor, BaseResponse queryResponse, EdmComplexResponse response) throws ODataApplicationException, SerializerException {
        if (request.getPreference(ODATA_MAXPAGESIZE) != null) {
            response.writeHeader(PREFERENCE_APPLIED, "odata.maxpagesize=" + request.getPreference(ODATA_MAXPAGESIZE));
        }
        CrossJoinResult result = (CrossJoinResult)queryResponse;
        URI next = null;
        if (result.getNextToken() != null) {
            try {
                next = new URI(request.getODataRequest().getRawRequestUri() + (request.getODataRequest().getRawQueryPath() == null ? "?$skiptoken=" : "&$skiptoken=") + result.getNextToken());
            }
            catch (URISyntaxException e) {
                throw new ODataApplicationException(e.getMessage(), 500, Locale.getDefault(), (Throwable)e);
            }
        }
        response.writeComplexType(result, next);
    }

    private BaseResponse executeQuery(DataRequest request, ODataSQLBuilder visitor, Query query) throws SQLException {
        if (request.isCountRequest()) {
            return TeiidServiceHandler.getClient().executeCount(query, visitor.getParameters());
        }
        String pageSize = request.getPreference(ODATA_MAXPAGESIZE);
        if (pageSize == null) {
            pageSize = TeiidServiceHandler.getClient().getProperty("batch-size") == null ? String.valueOf(256) : TeiidServiceHandler.getClient().getProperty("batch-size");
        }
        QueryResponse result = new EntityCollectionResponse(TeiidServiceHandler.getClient().getProperty("invalid-xml10-character-replacement"), visitor.getContext());
        if (visitor.getContext() instanceof CrossJoinNode) {
            result = new CrossJoinResult(TeiidServiceHandler.getClient().getProperty("invalid-xml10-character-replacement"), (CrossJoinNode)visitor.getContext());
        }
        TeiidServiceHandler.getClient().executeSQL(query, visitor.getParameters(), visitor.includeTotalSize(), visitor.getSkip(), visitor.getTop(), visitor.getNextToken(), Integer.parseInt(pageSize), result);
        return result;
    }

    private void checkExpand(UriInfoResource queryInfo) {
        if (queryInfo.getExpandOption() != null && !queryInfo.getExpandOption().getExpandItems().isEmpty()) {
            throw new UnsupportedOperationException("Expand is not supported");
        }
    }

    private UpdateResponse performInsert(String rawURI, UriInfo uriInfo, EdmEntityType entityType, Entity entity) throws SQLException, TeiidException {
        ODataSQLBuilder visitor = new ODataSQLBuilder(TeiidServiceHandler.getClient().getMetadataStore(), this.prepared, false, rawURI, this.serviceMetadata, this.nameGenerator);
        visitor.visit(uriInfo);
        Insert command = visitor.insert(entityType, entity, this.prepared);
        return TeiidServiceHandler.getClient().executeUpdate((Command)command, visitor.getParameters());
    }

    private UpdateResponse performDeepInsert(String rawURI, UriInfo uriInfo, EdmEntityType entityType, Entity entity) throws SQLException, TeiidException {
        String txn = TeiidServiceHandler.getClient().startTransaction();
        try {
            UpdateResponse response = this.performInsert(rawURI, uriInfo, entityType, entity);
            for (String navigationName : entityType.getNavigationPropertyNames()) {
                EdmNavigationProperty navProperty = entityType.getNavigationProperty(navigationName);
                Link navLink = entity.getNavigationLink(navigationName);
                if (navLink != null && navLink.getInlineEntity() != null) {
                    this.performInsert(rawURI, uriInfo, navProperty.getType(), navLink.getInlineEntity());
                }
                if (navLink == null || navLink.getInlineEntitySet() == null || navLink.getInlineEntitySet().getEntities().isEmpty()) continue;
                for (Entity inlineEntity : navLink.getInlineEntitySet().getEntities()) {
                    this.performInsert(rawURI, uriInfo, navProperty.getType(), inlineEntity);
                }
            }
            TeiidServiceHandler.getClient().commit(txn);
            return response;
        }
        catch (SQLException e) {
            try {
                TeiidServiceHandler.getClient().rollback(txn);
            }
            catch (SQLException e1) {
                // empty catch block
            }
            throw e;
        }
        catch (TeiidException e) {
            try {
                TeiidServiceHandler.getClient().rollback(txn);
            }
            catch (SQLException e1) {
                // empty catch block
            }
            throw e;
        }
    }

    private Set<EdmNavigationProperty> deepInsertNames(EdmEntityType entityType, Entity entity) {
        HashSet<EdmNavigationProperty> expand = new HashSet<EdmNavigationProperty>();
        for (String navigationName : entityType.getNavigationPropertyNames()) {
            EdmNavigationProperty navProperty = entityType.getNavigationProperty(navigationName);
            Link navLink = entity.getNavigationLink(navigationName);
            if (navLink == null) continue;
            if (navLink.getInlineEntity() != null) {
                expand.add(navProperty);
            }
            if (navLink.getInlineEntitySet() == null || navLink.getInlineEntitySet().getEntities().isEmpty()) continue;
            expand.add(navProperty);
        }
        return expand;
    }

    public void createEntity(DataRequest request, Entity entity, EntityResponse response) throws ODataLibraryException, ODataApplicationException {
        try {
            EdmEntityType entityType = request.getEntitySet().getEntityType();
            UpdateResponse updateResponse = this.performDeepInsert(request.getODataRequest().getRawBaseUri(), request.getUriInfo(), entityType, entity);
            if (updateResponse.getUpdateCount() == 1) {
                ODataSQLBuilder visitor = new ODataSQLBuilder(TeiidServiceHandler.getClient().getMetadataStore(), true, false, request.getODataRequest().getRawBaseUri(), this.serviceMetadata, this.nameGenerator);
                Query query = visitor.selectWithEntityKey(entityType, entity, updateResponse.getGeneratedKeys(), this.deepInsertNames(entityType, entity));
                LogManager.logDetail((String)"org.teiid.ODATA", null, (Object[])new Object[]{"created entity = ", entityType.getName(), " with key=", query.getCriteria().toString()});
                EntityCollectionResponse result = new EntityCollectionResponse(TeiidServiceHandler.getClient().getProperty("invalid-xml10-character-replacement"), visitor.getContext());
                TeiidServiceHandler.getClient().executeSQL(query, visitor.getParameters(), false, null, null, null, 1, result);
                if (!result.getEntities().isEmpty()) {
                    entity = (Entity)result.getEntities().get(0);
                    String location = EntityResponse.buildLocation((String)request.getODataRequest().getRawBaseUri(), (Entity)entity, (String)request.getEntitySet().getName(), (EdmEntityType)entityType);
                    entity.setId(new URI(location));
                }
                response.writeCreatedEntity(request.getEntitySet(), entity);
            } else {
                response.writeNotModified();
            }
        }
        catch (SQLException e) {
            throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), (Throwable)e);
        }
        catch (TeiidException e) {
            throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), (Throwable)e);
        }
    }

    public void updateEntity(DataRequest request, Entity entity, boolean merge, String entityETag, EntityResponse response) throws ODataLibraryException, ODataApplicationException {
        this.checkETag(entityETag);
        UpdateResponse updateResponse = null;
        if (merge) {
            try {
                ODataSQLBuilder visitor = new ODataSQLBuilder(TeiidServiceHandler.getClient().getMetadataStore(), this.prepared, false, request.getODataRequest().getRawBaseUri(), this.serviceMetadata, this.nameGenerator);
                visitor.visit(request.getUriInfo());
                EdmEntityType entityType = request.getEntitySet().getEntityType();
                Update update = visitor.update(entityType, entity, this.prepared);
                updateResponse = TeiidServiceHandler.getClient().executeUpdate((Command)update, visitor.getParameters());
            }
            catch (SQLException e) {
                throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), (Throwable)e);
            }
            catch (TeiidException e) {
                throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), (Throwable)e);
            }
        }
        String txn = this.startTransaction();
        try {
            ODataSQLBuilder visitor = new ODataSQLBuilder(TeiidServiceHandler.getClient().getMetadataStore(), this.prepared, false, request.getODataRequest().getRawBaseUri(), this.serviceMetadata, this.nameGenerator);
            visitor.visit(request.getUriInfo());
            Delete delete = visitor.delete();
            updateResponse = TeiidServiceHandler.getClient().executeUpdate((Command)delete, visitor.getParameters());
            ODataJsonDeserializer deserializer = new ODataJsonDeserializer(ContentType.JSON);
            visitor = new ODataSQLBuilder(TeiidServiceHandler.getClient().getMetadataStore(), this.prepared, false, request.getODataRequest().getRawBaseUri(), this.serviceMetadata, this.nameGenerator);
            visitor.visit(request.getUriInfo());
            EdmEntityType entityType = request.getEntitySet().getEntityType();
            List keys = request.getKeyPredicates();
            for (UriParameter key : keys) {
                EdmProperty edmProperty = (EdmProperty)entityType.getProperty(key.getName());
                Property property = deserializer.property((InputStream)new ByteArrayInputStream(key.getText().getBytes()), edmProperty).getProperty();
                entity.addProperty(property);
            }
            Insert command = visitor.insert(entityType, entity, this.prepared);
            updateResponse = TeiidServiceHandler.getClient().executeUpdate((Command)command, visitor.getParameters());
            this.commit(txn);
        }
        catch (SQLException e) {
            this.rollback(txn);
            throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), (Throwable)e);
        }
        catch (TeiidException e) {
            this.rollback(txn);
            throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), (Throwable)e);
        }
        if (updateResponse != null && updateResponse.getUpdateCount() > 0) {
            response.writeUpdatedEntity();
        } else {
            response.writeNotModified();
        }
    }

    private void checkETag(String entityETag) throws ODataApplicationException {
        if (entityETag != null && !entityETag.equals("*")) {
            throw new ODataApplicationException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16030, new Object[0]), HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.getDefault());
        }
    }

    public void deleteEntity(DataRequest request, String entityETag, EntityResponse response) throws ODataLibraryException, ODataApplicationException {
        this.checkETag(entityETag);
        UpdateResponse updateResponse = null;
        try {
            ODataSQLBuilder visitor = new ODataSQLBuilder(TeiidServiceHandler.getClient().getMetadataStore(), this.prepared, false, request.getODataRequest().getRawBaseUri(), this.serviceMetadata, this.nameGenerator);
            visitor.visit(request.getUriInfo());
            Delete delete = visitor.delete();
            updateResponse = TeiidServiceHandler.getClient().executeUpdate((Command)delete, visitor.getParameters());
        }
        catch (SQLException e) {
            throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), (Throwable)e);
        }
        if (updateResponse != null && updateResponse.getUpdateCount() > 0) {
            response.writeDeletedEntityOrReference();
        } else {
            response.writeNotModified();
        }
    }

    public void updateProperty(DataRequest request, Property property, boolean merge, String entityETag, PropertyResponse response) throws ODataLibraryException, ODataApplicationException {
        this.checkETag(entityETag);
        UpdateResponse updateResponse = null;
        EdmProperty edmProperty = request.getUriResourceProperty().getProperty();
        try {
            ODataSQLBuilder visitor = new ODataSQLBuilder(TeiidServiceHandler.getClient().getMetadataStore(), this.prepared, false, request.getODataRequest().getRawBaseUri(), this.serviceMetadata, this.nameGenerator);
            visitor.visit(request.getUriInfo());
            Update update = visitor.updateProperty(edmProperty, property, this.prepared);
            updateResponse = TeiidServiceHandler.getClient().executeUpdate((Command)update, visitor.getParameters());
        }
        catch (SQLException e) {
            throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), (Throwable)e);
        }
        catch (TeiidException e) {
            throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), (Throwable)e);
        }
        if (updateResponse != null && updateResponse.getUpdateCount() > 0) {
            response.writePropertyUpdated();
        } else {
            response.writeNotModified();
        }
    }

    public void upsertStreamProperty(DataRequest request, String entityETag, InputStream streamContent, NoContentResponse response) throws ODataLibraryException, ODataApplicationException {
        UpdateResponse updateResponse = null;
        EdmProperty edmProperty = request.getUriResourceProperty().getProperty();
        try {
            ODataSQLBuilder visitor = new ODataSQLBuilder(TeiidServiceHandler.getClient().getMetadataStore(), this.prepared, false, request.getODataRequest().getRawBaseUri(), this.serviceMetadata, this.nameGenerator);
            visitor.visit(request.getUriInfo());
            Update update = visitor.updateStreamProperty(edmProperty, streamContent);
            updateResponse = TeiidServiceHandler.getClient().executeUpdate((Command)update, visitor.getParameters());
        }
        catch (SQLException e) {
            throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), (Throwable)e);
        }
        if (updateResponse != null && updateResponse.getUpdateCount() > 0) {
            response.writeNoContent();
        } else {
            response.writeNotModified();
        }
    }

    public <T extends ServiceResponse> void invoke(FunctionRequest request, HttpMethod method, T response) throws ODataLibraryException, ODataApplicationException {
        this.invokeOperation((OperationRequest)request, response);
    }

    public <T extends ServiceResponse> void invoke(ActionRequest request, String eTag, T response) throws ODataLibraryException, ODataApplicationException {
        this.checkETag(eTag);
        this.invokeOperation((OperationRequest)request, response);
    }

    private <T extends ServiceResponse> void invokeOperation(final OperationRequest request, T response) throws ODataApplicationException, ODataLibraryException {
        this.checkExpand(request.getUriInfo().asUriInfoResource());
        OperationResponseImpl result = null;
        try {
            MetadataStore store = TeiidServiceHandler.getClient().getMetadataStore();
            ProcedureSQLBuilder builder = new ProcedureSQLBuilder(store.getSchema(this.schemaName), request);
            ProcedureSQLBuilder.ProcedureReturn procedureReturn = builder.getReturn();
            result = new OperationResponseImpl(TeiidServiceHandler.getClient().getProperty("invalid-xml10-character-replacement"), procedureReturn.getReturnType());
            TeiidServiceHandler.getClient().executeCall(builder.buildProcedureSQL(), builder.getSqlParameters(), procedureReturn, result);
        }
        catch (SQLException e) {
            throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), (Throwable)e);
        }
        catch (TeiidException e) {
            throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), (Throwable)e);
        }
        final OperationResponseImpl operationResult = result;
        response.accepts(new ServiceResponseVisior(){

            public void visit(PropertyResponse response) throws ODataLibraryException, ODataApplicationException {
                Property property = (Property)operationResult.getResult();
                Object value = property.getValue();
                if (value instanceof SQLXML || value instanceof Blob || value instanceof Clob) {
                    try {
                        TeiidServiceHandler.this.handleLobResult(TeiidServiceHandler.getClient().getProperty("charset"), value, (ServiceResponse)response);
                    }
                    catch (SQLException e) {
                        LogManager.logDetail((String)"org.teiid.ODATA", (Object)e);
                        response.writeServerError(true);
                    }
                } else {
                    response.writeProperty(request.getReturnType().getType(), property);
                }
            }
        });
    }

    public void readMediaStream(MediaRequest request, StreamResponse response) throws ODataLibraryException, ODataApplicationException {
        response.writeServerError(true);
    }

    public void upsertMediaStream(MediaRequest request, String entityETag, InputStream mediaContent, NoContentResponse response) throws ODataLibraryException, ODataApplicationException {
        response.writeServerError(true);
    }

    public void anyUnsupported(ODataRequest request, ODataResponse response) throws ODataLibraryException, ODataApplicationException {
        response.setStatusCode(500);
    }

    public void addReference(DataRequest request, String entityETag, URI referenceId, NoContentResponse response) throws ODataLibraryException, ODataApplicationException {
        this.manageReference(request, referenceId, response, false);
    }

    public void updateReference(DataRequest request, String entityETag, URI referenceId, NoContentResponse response) throws ODataLibraryException, ODataApplicationException {
        this.manageReference(request, referenceId, response, false);
    }

    private void manageReference(DataRequest request, URI referenceId, NoContentResponse response, boolean delete) throws ODataApplicationException {
        UpdateResponse updateResponse = null;
        try {
            ReferenceUpdateSQLBuilder visitor = new ReferenceUpdateSQLBuilder(TeiidServiceHandler.getClient().getMetadataStore(), request.getODataRequest().getRawBaseUri(), this.serviceMetadata);
            visitor.visit(request.getUriInfo());
            Update update = visitor.updateReference(referenceId, this.prepared, delete);
            updateResponse = TeiidServiceHandler.getClient().executeUpdate((Command)update, visitor.getParameters());
        }
        catch (SQLException e) {
            throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), (Throwable)e);
        }
        if (updateResponse != null && updateResponse.getUpdateCount() > 0) {
            response.writeNoContent();
        } else {
            response.writeNotModified();
        }
    }

    public void deleteReference(DataRequest request, URI deleteId, String entityETag, NoContentResponse response) throws ODataLibraryException, ODataApplicationException {
        this.manageReference(request, deleteId, response, true);
    }

    public String startTransaction() throws ODataLibraryException, ODataApplicationException {
        try {
            return TeiidServiceHandler.getClient().startTransaction();
        }
        catch (SQLException e) {
            throw new ODataApplicationException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16039, new Object[0]), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault());
        }
    }

    public void commit(String txnId) throws ODataLibraryException, ODataApplicationException {
        try {
            TeiidServiceHandler.getClient().commit(txnId);
        }
        catch (SQLException e) {
            throw new ODataApplicationException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16039, new Object[0]), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault());
        }
    }

    public void rollback(String txnId) throws ODataLibraryException, ODataApplicationException {
        try {
            TeiidServiceHandler.getClient().rollback(txnId);
        }
        catch (SQLException e) {
            throw new ODataApplicationException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16039, new Object[0]), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault());
        }
    }

    public void crossJoin(DataRequest request, List<String> entitySetNames, ODataResponse response) throws ODataLibraryException, ODataApplicationException {
        ODataSQLBuilder visitor = new ODataSQLBuilder(TeiidServiceHandler.getClient().getMetadataStore(), this.prepared, true, request.getODataRequest().getRawBaseUri(), this.serviceMetadata, this.nameGenerator);
        visitor.visit(request.getUriInfo());
        try {
            Query query = visitor.selectQuery();
            BaseResponse queryResponse = this.executeQuery(request, visitor, query);
            ContextURL.Builder builder = new ContextURL.Builder().asCollection().entitySetOrSingletonOrType("Edm.ComplexType");
            EdmComplexResponse complexResponse = EdmComplexResponse.getInstance((ServiceRequest)request, builder.build(), false, response);
            this.sendResults(request, visitor, queryResponse, complexResponse);
        }
        catch (Exception e) {
            throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), (Throwable)e);
        }
    }

    private void handleLobResult(String charSet, Object result, ServiceResponse response) throws SQLException {
        if (result == null) {
            return;
        }
        if (result instanceof SQLXML) {
            if (charSet != null) {
                XMLSerialize serialize = new XMLSerialize();
                serialize.setTypeString("blob");
                serialize.setDeclaration(Boolean.valueOf(true));
                serialize.setEncoding(charSet);
                serialize.setDocument(Boolean.valueOf(true));
                try {
                    InputStream content = ((BlobType)XMLSystemFunctions.serialize((XMLSerialize)serialize, (XMLType)new XMLType((SQLXML)result))).getBinaryStream();
                    response.writeContent(content, 200, false);
                    response.writeOK(ContentType.APPLICATION_OCTET_STREAM);
                }
                catch (TransformationException e) {
                    throw new SQLException(e);
                }
            } else {
                InputStream content = ((SQLXML)result).getBinaryStream();
                response.writeContent(content, 200, false);
                response.writeOK(ContentType.APPLICATION_XML);
            }
        } else if (result instanceof Blob) {
            InputStream content = ((Blob)result).getBinaryStream();
            response.writeContent(content, 200, false);
            response.writeOK(ContentType.APPLICATION_OCTET_STREAM);
        } else if (result instanceof Clob) {
            ReaderInputStream content = new ReaderInputStream(((Clob)result).getCharacterStream(), charSet == null ? Charset.defaultCharset() : Charset.forName(charSet));
            response.writeContent((InputStream)content, 200, false);
            response.writeOK(ContentType.TEXT_PLAIN);
        } else {
            ByteArrayInputStream content = new ByteArrayInputStream(result.toString().getBytes(charSet == null ? Charset.defaultCharset() : Charset.forName(charSet)));
            response.writeContent((InputStream)content, 200, false);
            response.writeOK(ContentType.APPLICATION_OCTET_STREAM);
        }
    }

    public void upsertEntity(DataRequest request, Entity entity, boolean merge, String entityETag, EntityResponse response) throws ODataLibraryException, ODataApplicationException {
        EntityCollectionResponse queryResponse;
        ODataSQLBuilder visitor = new ODataSQLBuilder(TeiidServiceHandler.getClient().getMetadataStore(), this.prepared, true, request.getODataRequest().getRawBaseUri(), this.serviceMetadata, this.nameGenerator);
        visitor.visit(request.getUriInfo());
        try {
            Query query = visitor.selectQuery();
            queryResponse = (EntityCollectionResponse)this.executeQuery(request, visitor, query);
        }
        catch (Exception e) {
            throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), (Throwable)e);
        }
        if (!queryResponse.getEntities().isEmpty()) {
            this.updateEntity(request, entity, merge, entityETag, response);
        } else {
            this.createEntity(request, entity, response);
        }
    }

    class UniqueNameGenerator {
        private final AtomicInteger groupCount = new AtomicInteger(0);

        UniqueNameGenerator() {
        }

        public String getNextGroup() {
            String aliasGroup = "g" + this.groupCount.getAndIncrement();
            return aliasGroup;
        }
    }
}

