/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.batchhandler;

import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.batch.BatchFacade;
import org.apache.olingo.server.api.deserializer.batch.BatchDeserializerException;
import org.apache.olingo.server.api.processor.BatchProcessor;
import org.apache.olingo.server.core.ODataHandler;
import org.apache.olingo.server.core.batchhandler.BatchFacadeImpl;
import org.apache.olingo.server.core.deserializer.batch.BatchParserCommon;

public class BatchHandler {
    private final BatchProcessor batchProcessor;
    private final ODataHandler oDataHandler;

    public BatchHandler(ODataHandler oDataHandler, BatchProcessor batchProcessor) {
        this.batchProcessor = batchProcessor;
        this.oDataHandler = oDataHandler;
    }

    public void process(ODataRequest request, ODataResponse response, boolean isStrict) throws ODataApplicationException, ODataLibraryException {
        this.validateRequest(request);
        BatchFacadeImpl operation = new BatchFacadeImpl(this.oDataHandler, request, this.batchProcessor, isStrict);
        this.batchProcessor.processBatch((BatchFacade)operation, request, response);
    }

    private void validateRequest(ODataRequest request) throws BatchDeserializerException {
        this.validateHttpMethod(request);
        this.validateContentType(request);
    }

    private void validateContentType(ODataRequest request) throws BatchDeserializerException {
        BatchParserCommon.parseContentType(request.getHeader("Content-Type"), ContentType.MULTIPART_MIXED, 0);
    }

    private void validateHttpMethod(ODataRequest request) throws BatchDeserializerException {
        if (request.getMethod() != HttpMethod.POST) {
            throw new BatchDeserializerException("Invalid HTTP method", (ODataLibraryException.MessageKey)BatchDeserializerException.MessageKeys.INVALID_METHOD, new String[]{"0"});
        }
    }
}

