/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.debug;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.commons.codec.binary.Base64;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.core.debug.DebugResponseHelperImpl;
import org.apache.olingo.server.core.debug.DebugTab;

public class DebugTabBody
implements DebugTab {
    private final ODataResponse response;
    private final ResponseContent responseContent;

    public DebugTabBody(ODataResponse response) {
        String contentTypeString;
        this.response = response;
        this.responseContent = response != null ? ((contentTypeString = response.getHeader("Content-Type")) != null ? (contentTypeString.startsWith("application/json") ? ResponseContent.JSON : (contentTypeString.startsWith("image/") ? ResponseContent.IMAGE : (contentTypeString.contains("xml") ? ResponseContent.XML : ResponseContent.TEXT))) : ResponseContent.TEXT) : ResponseContent.TEXT;
    }

    @Override
    public String getName() {
        return "Body";
    }

    @Override
    public void appendJson(JsonGenerator gen) throws IOException {
        if (this.response == null || this.response.getContent() == null) {
            gen.writeNull();
        } else {
            gen.writeString(this.getContentString());
        }
    }

    private String getContentString() {
        try {
            String contentString;
            switch (this.responseContent) {
                case IMAGE: {
                    contentString = Base64.encodeBase64String((byte[])this.streamToBytes(this.response.getContent()));
                    break;
                }
                default: {
                    contentString = new String(this.streamToBytes(this.response.getContent()), "UTF-8");
                }
            }
            return contentString;
        }
        catch (IOException e) {
            return "Could not parse Body for Debug Output";
        }
    }

    @Override
    public void appendHtml(Writer writer) throws IOException {
        String body = this.response == null || this.response.getContent() == null ? "ODataLibrary: No body." : this.getContentString();
        switch (this.responseContent) {
            case XML: {
                writer.append("<pre class=\"code").append(" xml").append("\">\n");
                writer.append(DebugResponseHelperImpl.escapeHtml(body));
                writer.append("\n</pre>\n");
                break;
            }
            case JSON: {
                writer.append("<pre class=\"code").append(" json").append("\">\n");
                writer.append(DebugResponseHelperImpl.escapeHtml(body));
                writer.append("\n</pre>\n");
                break;
            }
            case IMAGE: {
                writer.append("<img src=\"data:").append(this.response.getHeader("Content-Type")).append(";base64,").append(body).append("\" />\n");
                break;
            }
            default: {
                writer.append("<pre class=\"code").append("\">\n");
                writer.append(DebugResponseHelperImpl.escapeHtml(body));
                writer.append("\n</pre>\n");
            }
        }
    }

    private byte[] streamToBytes(InputStream input) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        if (input != null) {
            try {
                ByteBuffer inBuffer = ByteBuffer.allocate(8192);
                ReadableByteChannel ic = Channels.newChannel(input);
                WritableByteChannel oc = Channels.newChannel(buffer);
                while (ic.read(inBuffer) > 0) {
                    inBuffer.flip();
                    oc.write(inBuffer);
                    inBuffer.rewind();
                }
                return buffer.toByteArray();
            }
            catch (IOException e) {
                throw new ODataRuntimeException("Error on reading request content");
            }
        }
        return null;
    }

    private static enum ResponseContent {
        JSON,
        XML,
        TEXT,
        IMAGE;

    }
}

