/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.deserializer.batch;

import java.util.List;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.deserializer.batch.BatchDeserializerException;
import org.apache.olingo.server.core.deserializer.batch.BatchParserCommon;
import org.apache.olingo.server.core.deserializer.batch.Header;
import org.apache.olingo.server.core.deserializer.batch.HeaderField;

public class BatchTransformatorCommon {
    private BatchTransformatorCommon() {
    }

    public static void validateContentType(Header headers, ContentType expected) throws BatchDeserializerException {
        List<String> contentTypes = headers.getHeaders("Content-Type");
        if (contentTypes.isEmpty()) {
            throw new BatchDeserializerException("Missing content type", (ODataLibraryException.MessageKey)BatchDeserializerException.MessageKeys.MISSING_CONTENT_TYPE, new String[]{Integer.toString(headers.getLineNumber())});
        }
        BatchParserCommon.parseContentType(contentTypes.get(0), expected, headers.getLineNumber());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void validateContentTransferEncoding(Header headers) throws BatchDeserializerException {
        HeaderField contentTransferField = headers.getHeaderField("Content-Transfer-Encoding");
        if (contentTransferField == null) throw new BatchDeserializerException("Missing mandatory content transfer encoding", (ODataLibraryException.MessageKey)BatchDeserializerException.MessageKeys.MISSING_CONTENT_TRANSFER_ENCODING, new String[]{Integer.toString(headers.getLineNumber())});
        List<String> contentTransferValues = contentTransferField.getValues();
        if (contentTransferValues.size() != 1) throw new BatchDeserializerException("Invalid Content-Transfer-Encoding header", (ODataLibraryException.MessageKey)BatchDeserializerException.MessageKeys.INVALID_CONTENT_TRANSFER_ENCODING, new String[]{Integer.toString(headers.getLineNumber())});
        String encoding = contentTransferValues.get(0);
        if ("binary".equalsIgnoreCase(encoding)) return;
        throw new BatchDeserializerException("Invalid content transfer encoding", (ODataLibraryException.MessageKey)BatchDeserializerException.MessageKeys.INVALID_CONTENT_TRANSFER_ENCODING, new String[]{Integer.toString(headers.getLineNumber())});
    }

    public static int getContentLength(Header headers) throws BatchDeserializerException {
        HeaderField contentLengthField = headers.getHeaderField("Content-Length");
        if (contentLengthField != null && contentLengthField.getValues().size() == 1) {
            List<String> contentLengthValues = contentLengthField.getValues();
            try {
                int contentLength = Integer.parseInt(contentLengthValues.get(0));
                if (contentLength < 0) {
                    throw new BatchDeserializerException("Invalid content length", (ODataLibraryException.MessageKey)BatchDeserializerException.MessageKeys.INVALID_CONTENT_LENGTH, new String[]{Integer.toString(contentLengthField.getLineNumber())});
                }
                return contentLength;
            }
            catch (NumberFormatException e) {
                throw new BatchDeserializerException("Invalid content length", (Throwable)e, (ODataLibraryException.MessageKey)BatchDeserializerException.MessageKeys.INVALID_CONTENT_LENGTH, new String[]{Integer.toString(contentLengthField.getLineNumber())});
            }
        }
        return -1;
    }
}

