/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmActionImport;
import org.apache.olingo.commons.api.edm.EdmBindingTarget;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmKeyPropertyRef;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmNavigationPropertyBinding;
import org.apache.olingo.commons.api.edm.EdmOperation;
import org.apache.olingo.commons.api.edm.EdmParameter;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmReferentialConstraint;
import org.apache.olingo.commons.api.edm.EdmReturnType;
import org.apache.olingo.commons.api.edm.EdmSchema;
import org.apache.olingo.commons.api.edm.EdmSingleton;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.EdmTypeDefinition;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.edmx.EdmxReference;
import org.apache.olingo.server.api.edmx.EdmxReferenceInclude;
import org.apache.olingo.server.api.edmx.EdmxReferenceIncludeAnnotation;
import org.apache.olingo.server.api.serializer.SerializerException;

public class MetadataDocumentXmlSerializer {
    private static final String TRUE = "true";
    private static final String XML_EXTENDS = "Extends";
    private static final String XML_TARGET = "Target";
    private static final String XML_PATH = "Path";
    private static final String XML_NAVIGATION_PROPERTY_BINDING = "NavigationPropertyBinding";
    private static final String XML_VALUE = "Value";
    private static final String XML_MEMBER = "Member";
    private static final String XML_UNDERLYING_TYPE = "UnderlyingType";
    private static final String XML_IS_FLAGS = "IsFlags";
    private static final String XML_ENUM_TYPE = "EnumType";
    private static final String XML_PROPERTY_REF = "PropertyRef";
    private static final String XML_KEY = "Key";
    private static final String XML_SCALE = "Scale";
    private static final String XML_PRECISION = "Precision";
    private static final String XML_MAX_LENGTH = "MaxLength";
    private static final String XML_DEFAULT_VALUE = "DefaultValue";
    private static final String XML_UNICODE = "Unicode";
    private static final String XML_PROPERTY = "Property";
    private static final String XML_PARTNER = "Partner";
    private static final String XML_NULLABLE = "Nullable";
    private static final String XML_NAVIGATION_PROPERTY = "NavigationProperty";
    private static final String XML_HAS_STREAM = "HasStream";
    private static final String XML_BASE_TYPE = "BaseType";
    private static final String XML_COMPLEX_TYPE = "ComplexType";
    private static final String XML_RETURN_TYPE = "ReturnType";
    private static final String XML_TYPE = "Type";
    private static final String XML_PARAMETER = "Parameter";
    private static final String XML_IS_COMPOSABLE = "IsComposable";
    private static final String XML_IS_BOUND = "IsBound";
    private static final String XML_ENTITY_TYPE = "EntityType";
    private static final String XML_SINGLETON = "Singleton";
    private static final String XML_ACTION = "Action";
    private static final String XML_ACTION_IMPORT = "ActionImport";
    private static final String XML_INCLUDE_IN_SERVICE_DOCUMENT = "IncludeInServiceDocument";
    private static final String XML_ENTITY_SET = "EntitySet";
    private static final String XML_FUNCTION = "Function";
    private static final String XML_FUNCTION_IMPORT = "FunctionImport";
    private static final String XML_NAME = "Name";
    private static final String XML_ENTITY_CONTAINER = "EntityContainer";
    private static final String XML_ALIAS = "Alias";
    private static final String XML_NAMESPACE = "Namespace";
    private static final String XML_TYPE_DEFINITION = "TypeDefinition";
    private static final String REFERENCE = "Reference";
    private static final String INCLUDE = "Include";
    private static final String INCLUDE_ANNOTATIONS = "IncludeAnnotations";
    private static final String XML_TERM_NAMESPACE = "TermNamespace";
    private static final String XML_TARGET_NAMESPACE = "TargetNamespace";
    private static final String XML_QUALIFIER = "Qualifier";
    private static final String URI = "Uri";
    private static final String SCHEMA = "Schema";
    private static final String DATA_SERVICES = "DataServices";
    private static final String ABSTRACT = "Abstract";
    private static final String EDMX = "Edmx";
    private static final String PREFIX_EDMX = "edmx";
    private static final String NS_EDMX = "http://docs.oasis-open.org/odata/ns/edmx";
    private static final String NS_EDM = "http://docs.oasis-open.org/odata/ns/edm";
    private static final String XML_ENTITY_SET_PATH = "EntitySetPath";
    private static final String XML_CONTAINS_TARGET = "ContainsTarget";
    private final ServiceMetadata serviceMetadata;
    private final Map<String, String> namespaceToAlias = new HashMap<String, String>();

    public MetadataDocumentXmlSerializer(ServiceMetadata serviceMetadata) throws SerializerException {
        if (serviceMetadata == null || serviceMetadata.getEdm() == null) {
            throw new SerializerException("Service Metadata and EDM must not be null for a service.", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.NULL_METADATA_OR_EDM, new String[0]);
        }
        this.serviceMetadata = serviceMetadata;
    }

    public void writeMetadataDocument(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartDocument("UTF-8", "1.0");
        writer.setPrefix(PREFIX_EDMX, NS_EDMX);
        writer.setDefaultNamespace(NS_EDMX);
        writer.writeStartElement(PREFIX_EDMX, EDMX, NS_EDMX);
        writer.writeAttribute("Version", "4.0");
        writer.writeNamespace(PREFIX_EDMX, NS_EDMX);
        this.appendReference(writer);
        this.appendDataServices(writer);
        writer.writeEndDocument();
    }

    private void appendDataServices(XMLStreamWriter writer) throws XMLStreamException {
        writer.setDefaultNamespace(NS_EDM);
        writer.writeStartElement(NS_EDMX, DATA_SERVICES);
        for (EdmSchema schema : this.serviceMetadata.getEdm().getSchemas()) {
            this.appendSchema(writer, schema);
        }
        writer.writeEndElement();
    }

    private void appendSchema(XMLStreamWriter writer, EdmSchema schema) throws XMLStreamException {
        writer.writeStartElement(NS_EDM, SCHEMA);
        writer.writeDefaultNamespace(NS_EDM);
        writer.writeAttribute(XML_NAMESPACE, schema.getNamespace());
        if (schema.getAlias() != null) {
            writer.writeAttribute(XML_ALIAS, schema.getAlias());
            this.namespaceToAlias.put(schema.getNamespace(), schema.getAlias());
        }
        this.appendEnumTypes(writer, schema.getEnumTypes());
        this.appendTypeDefinitions(writer, schema.getTypeDefinitions());
        this.appendEntityTypes(writer, schema.getEntityTypes());
        this.appendComplexTypes(writer, schema.getComplexTypes());
        this.appendActions(writer, schema.getActions());
        this.appendFunctions(writer, schema.getFunctions());
        this.appendEntityContainer(writer, schema.getEntityContainer());
        writer.writeEndElement();
    }

    private void appendTypeDefinitions(XMLStreamWriter writer, List<EdmTypeDefinition> typeDefinitions) throws XMLStreamException {
        for (EdmTypeDefinition definition : typeDefinitions) {
            writer.writeEmptyElement(XML_TYPE_DEFINITION);
            writer.writeAttribute(XML_NAME, definition.getName());
            writer.writeAttribute(XML_UNDERLYING_TYPE, this.getFullQualifiedName((EdmType)definition.getUnderlyingType(), false));
            if (definition.getMaxLength() != null) {
                writer.writeAttribute(XML_MAX_LENGTH, "" + definition.getMaxLength());
            }
            if (definition.getPrecision() != null) {
                writer.writeAttribute(XML_PRECISION, "" + definition.getPrecision());
            }
            if (definition.getScale() == null) continue;
            writer.writeAttribute(XML_SCALE, "" + definition.getScale());
        }
    }

    private void appendEntityContainer(XMLStreamWriter writer, EdmEntityContainer container) throws XMLStreamException {
        if (container != null) {
            writer.writeStartElement(XML_ENTITY_CONTAINER);
            writer.writeAttribute(XML_NAME, container.getName());
            FullQualifiedName parentContainerName = container.getParentContainerName();
            if (parentContainerName != null) {
                String parentContainerNameString = this.namespaceToAlias.get(parentContainerName.getNamespace()) != null ? this.namespaceToAlias.get(parentContainerName.getNamespace()) + "." + parentContainerName.getName() : parentContainerName.getFullQualifiedNameAsString();
                writer.writeAttribute(XML_EXTENDS, parentContainerNameString);
            }
            this.appendEntitySets(writer, container.getEntitySets());
            this.appendActionImports(writer, container.getActionImports());
            String containerNamespace = this.namespaceToAlias.get(container.getNamespace()) != null ? this.namespaceToAlias.get(container.getNamespace()) : container.getNamespace();
            this.appendFunctionImports(writer, container.getFunctionImports(), containerNamespace);
            this.appendSingletons(writer, container.getSingletons());
            writer.writeEndElement();
        }
    }

    private void appendFunctionImports(XMLStreamWriter writer, List<EdmFunctionImport> functionImports, String containerNamespace) throws XMLStreamException {
        for (EdmFunctionImport functionImport : functionImports) {
            writer.writeStartElement(XML_FUNCTION_IMPORT);
            writer.writeAttribute(XML_NAME, functionImport.getName());
            FullQualifiedName functionFqn = functionImport.getFunctionFqn();
            String functionFQNString = this.namespaceToAlias.get(functionFqn.getNamespace()) != null ? this.namespaceToAlias.get(functionFqn.getNamespace()) + "." + functionFqn.getName() : functionFqn.getFullQualifiedNameAsString();
            writer.writeAttribute(XML_FUNCTION, functionFQNString);
            EdmEntitySet returnedEntitySet = functionImport.getReturnedEntitySet();
            if (returnedEntitySet != null) {
                writer.writeAttribute(XML_ENTITY_SET, containerNamespace + "." + returnedEntitySet.getName());
            }
            if (functionImport.isIncludeInServiceDocument()) {
                writer.writeAttribute(XML_INCLUDE_IN_SERVICE_DOCUMENT, "" + functionImport.isIncludeInServiceDocument());
            }
            writer.writeEndElement();
        }
    }

    private void appendActionImports(XMLStreamWriter writer, List<EdmActionImport> actionImports) throws XMLStreamException {
        for (EdmActionImport actionImport : actionImports) {
            writer.writeStartElement(XML_ACTION_IMPORT);
            writer.writeAttribute(XML_NAME, actionImport.getName());
            writer.writeAttribute(XML_ACTION, this.getAliasedFullQualifiedName((EdmType)actionImport.getUnboundAction(), false));
            writer.writeEndElement();
        }
    }

    private void appendSingletons(XMLStreamWriter writer, List<EdmSingleton> singletons) throws XMLStreamException {
        for (EdmSingleton singleton : singletons) {
            writer.writeStartElement(XML_SINGLETON);
            writer.writeAttribute(XML_NAME, singleton.getName());
            writer.writeAttribute(XML_ENTITY_TYPE, this.getAliasedFullQualifiedName((EdmType)singleton.getEntityType(), false));
            this.appendNavigationPropertyBindings(writer, (EdmBindingTarget)singleton);
            writer.writeEndElement();
        }
    }

    private void appendNavigationPropertyBindings(XMLStreamWriter writer, EdmBindingTarget bindingTarget) throws XMLStreamException {
        if (bindingTarget.getNavigationPropertyBindings() != null) {
            for (EdmNavigationPropertyBinding binding : bindingTarget.getNavigationPropertyBindings()) {
                writer.writeEmptyElement(XML_NAVIGATION_PROPERTY_BINDING);
                writer.writeAttribute(XML_PATH, binding.getPath());
                writer.writeAttribute(XML_TARGET, binding.getTarget());
            }
        }
    }

    private void appendEntitySets(XMLStreamWriter writer, List<EdmEntitySet> entitySets) throws XMLStreamException {
        for (EdmEntitySet entitySet : entitySets) {
            writer.writeStartElement(XML_ENTITY_SET);
            writer.writeAttribute(XML_NAME, entitySet.getName());
            writer.writeAttribute(XML_ENTITY_TYPE, this.getAliasedFullQualifiedName((EdmType)entitySet.getEntityType(), false));
            if (!entitySet.isIncludeInServiceDocument()) {
                writer.writeAttribute(XML_INCLUDE_IN_SERVICE_DOCUMENT, "" + entitySet.isIncludeInServiceDocument());
            }
            this.appendNavigationPropertyBindings(writer, (EdmBindingTarget)entitySet);
            writer.writeEndElement();
        }
    }

    private void appendFunctions(XMLStreamWriter writer, List<EdmFunction> functions) throws XMLStreamException {
        for (EdmFunction function : functions) {
            writer.writeStartElement(XML_FUNCTION);
            writer.writeAttribute(XML_NAME, function.getName());
            if (function.getEntitySetPath() != null) {
                writer.writeAttribute(XML_ENTITY_SET_PATH, function.getEntitySetPath());
            }
            if (function.isBound()) {
                writer.writeAttribute(XML_IS_BOUND, "" + function.isBound());
            }
            if (function.isComposable()) {
                writer.writeAttribute(XML_IS_COMPOSABLE, "" + function.isComposable());
            }
            this.appendOperationParameters(writer, (EdmOperation)function);
            this.appendOperationReturnType(writer, (EdmOperation)function);
            writer.writeEndElement();
        }
    }

    private void appendOperationReturnType(XMLStreamWriter writer, EdmOperation operation) throws XMLStreamException {
        EdmReturnType returnType = operation.getReturnType();
        if (returnType != null) {
            writer.writeEmptyElement(XML_RETURN_TYPE);
            String returnTypeFqnString = EdmTypeKind.PRIMITIVE.equals((Object)returnType.getType().getKind()) ? this.getFullQualifiedName(returnType.getType(), returnType.isCollection()) : this.getAliasedFullQualifiedName(returnType.getType(), returnType.isCollection());
            writer.writeAttribute(XML_TYPE, returnTypeFqnString);
            this.appendReturnTypeFacets(writer, returnType);
        }
    }

    private void appendOperationParameters(XMLStreamWriter writer, EdmOperation operation) throws XMLStreamException {
        for (String parameterName : operation.getParameterNames()) {
            EdmParameter parameter = operation.getParameter(parameterName);
            writer.writeEmptyElement(XML_PARAMETER);
            writer.writeAttribute(XML_NAME, parameterName);
            String typeFqnString = EdmTypeKind.PRIMITIVE.equals((Object)parameter.getType().getKind()) ? this.getFullQualifiedName(parameter.getType(), parameter.isCollection()) : this.getAliasedFullQualifiedName(parameter.getType(), parameter.isCollection());
            writer.writeAttribute(XML_TYPE, typeFqnString);
            this.appendParameterFacets(writer, parameter);
        }
    }

    private void appendActions(XMLStreamWriter writer, List<EdmAction> actions) throws XMLStreamException {
        for (EdmAction action : actions) {
            writer.writeStartElement(XML_ACTION);
            writer.writeAttribute(XML_NAME, action.getName());
            if (action.getEntitySetPath() != null) {
                writer.writeAttribute(XML_ENTITY_SET_PATH, action.getEntitySetPath());
            }
            writer.writeAttribute(XML_IS_BOUND, "" + action.isBound());
            this.appendOperationParameters(writer, (EdmOperation)action);
            this.appendOperationReturnType(writer, (EdmOperation)action);
            writer.writeEndElement();
        }
    }

    private void appendReturnTypeFacets(XMLStreamWriter writer, EdmReturnType returnType) throws XMLStreamException {
        if (!returnType.isNullable()) {
            writer.writeAttribute(XML_NULLABLE, "" + returnType.isNullable());
        }
        if (returnType.getMaxLength() != null) {
            writer.writeAttribute(XML_MAX_LENGTH, "" + returnType.getMaxLength());
        }
        if (returnType.getPrecision() != null) {
            writer.writeAttribute(XML_PRECISION, "" + returnType.getPrecision());
        }
        if (returnType.getScale() != null) {
            writer.writeAttribute(XML_SCALE, "" + returnType.getScale());
        }
    }

    private void appendParameterFacets(XMLStreamWriter writer, EdmParameter parameter) throws XMLStreamException {
        if (!parameter.isNullable()) {
            writer.writeAttribute(XML_NULLABLE, "" + parameter.isNullable());
        }
        if (parameter.getMaxLength() != null) {
            writer.writeAttribute(XML_MAX_LENGTH, "" + parameter.getMaxLength());
        }
        if (parameter.getPrecision() != null) {
            writer.writeAttribute(XML_PRECISION, "" + parameter.getPrecision());
        }
        if (parameter.getScale() != null) {
            writer.writeAttribute(XML_SCALE, "" + parameter.getScale());
        }
    }

    private void appendComplexTypes(XMLStreamWriter writer, List<EdmComplexType> complexTypes) throws XMLStreamException {
        for (EdmComplexType complexType : complexTypes) {
            writer.writeStartElement(XML_COMPLEX_TYPE);
            writer.writeAttribute(XML_NAME, complexType.getName());
            if (complexType.getBaseType() != null) {
                writer.writeAttribute(XML_BASE_TYPE, this.getAliasedFullQualifiedName((EdmType)complexType.getBaseType(), false));
            }
            if (complexType.isAbstract()) {
                writer.writeAttribute(ABSTRACT, TRUE);
            }
            this.appendProperties(writer, (EdmStructuredType)complexType);
            this.appendNavigationProperties(writer, (EdmStructuredType)complexType);
            writer.writeEndElement();
        }
    }

    private void appendEntityTypes(XMLStreamWriter writer, List<EdmEntityType> entityTypes) throws XMLStreamException {
        for (EdmEntityType entityType : entityTypes) {
            writer.writeStartElement(XML_ENTITY_TYPE);
            writer.writeAttribute(XML_NAME, entityType.getName());
            if (entityType.hasStream()) {
                writer.writeAttribute(XML_HAS_STREAM, "" + entityType.hasStream());
            }
            if (entityType.getBaseType() != null) {
                writer.writeAttribute(XML_BASE_TYPE, this.getAliasedFullQualifiedName((EdmType)entityType.getBaseType(), false));
            }
            if (entityType.isAbstract()) {
                writer.writeAttribute(ABSTRACT, TRUE);
            }
            this.appendKey(writer, entityType);
            this.appendProperties(writer, (EdmStructuredType)entityType);
            this.appendNavigationProperties(writer, (EdmStructuredType)entityType);
            writer.writeEndElement();
        }
    }

    private void appendNavigationProperties(XMLStreamWriter writer, EdmStructuredType type) throws XMLStreamException {
        ArrayList navigationPropertyNames = new ArrayList(type.getNavigationPropertyNames());
        if (type.getBaseType() != null) {
            navigationPropertyNames.removeAll(type.getBaseType().getNavigationPropertyNames());
        }
        for (String navigationPropertyName : navigationPropertyNames) {
            EdmNavigationProperty navigationProperty = type.getNavigationProperty(navigationPropertyName);
            writer.writeStartElement(XML_NAVIGATION_PROPERTY);
            writer.writeAttribute(XML_NAME, navigationPropertyName);
            writer.writeAttribute(XML_TYPE, this.getAliasedFullQualifiedName((EdmType)navigationProperty.getType(), navigationProperty.isCollection()));
            if (!navigationProperty.isNullable()) {
                writer.writeAttribute(XML_NULLABLE, "" + navigationProperty.isNullable());
            }
            if (navigationProperty.getPartner() != null) {
                EdmNavigationProperty partner = navigationProperty.getPartner();
                writer.writeAttribute(XML_PARTNER, partner.getName());
            }
            if (navigationProperty.containsTarget()) {
                writer.writeAttribute(XML_CONTAINS_TARGET, "" + navigationProperty.containsTarget());
            }
            if (navigationProperty.getReferentialConstraints() != null) {
                for (EdmReferentialConstraint constraint : navigationProperty.getReferentialConstraints()) {
                    writer.writeEmptyElement("ReferentialConstraint");
                    writer.writeAttribute(XML_PROPERTY, constraint.getPropertyName());
                    writer.writeAttribute("ReferencedProperty", constraint.getReferencedPropertyName());
                }
            }
            writer.writeEndElement();
        }
    }

    private void appendProperties(XMLStreamWriter writer, EdmStructuredType type) throws XMLStreamException {
        ArrayList propertyNames = new ArrayList(type.getPropertyNames());
        if (type.getBaseType() != null) {
            propertyNames.removeAll(type.getBaseType().getPropertyNames());
        }
        for (String propertyName : propertyNames) {
            EdmProperty property = type.getStructuralProperty(propertyName);
            writer.writeEmptyElement(XML_PROPERTY);
            writer.writeAttribute(XML_NAME, propertyName);
            String fqnString = property.isPrimitive() ? this.getFullQualifiedName(property.getType(), property.isCollection()) : this.getAliasedFullQualifiedName(property.getType(), property.isCollection());
            writer.writeAttribute(XML_TYPE, fqnString);
            if (!property.isNullable()) {
                writer.writeAttribute(XML_NULLABLE, "" + property.isNullable());
            }
            if (!property.isUnicode()) {
                writer.writeAttribute(XML_UNICODE, "" + property.isUnicode());
            }
            if (property.getDefaultValue() != null) {
                writer.writeAttribute(XML_DEFAULT_VALUE, property.getDefaultValue());
            }
            if (property.getMaxLength() != null) {
                writer.writeAttribute(XML_MAX_LENGTH, "" + property.getMaxLength());
            }
            if (property.getPrecision() != null) {
                writer.writeAttribute(XML_PRECISION, "" + property.getPrecision());
            }
            if (property.getScale() == null) continue;
            writer.writeAttribute(XML_SCALE, "" + property.getScale());
        }
    }

    private void appendKey(XMLStreamWriter writer, EdmEntityType entityType) throws XMLStreamException {
        List keyPropertyRefs = entityType.getKeyPropertyRefs();
        if (keyPropertyRefs != null && !keyPropertyRefs.isEmpty()) {
            EdmEntityType baseType = entityType.getBaseType();
            if (baseType != null && baseType.getKeyPropertyRefs() != null && !baseType.getKeyPropertyRefs().isEmpty()) {
                return;
            }
            writer.writeStartElement(XML_KEY);
            for (EdmKeyPropertyRef keyRef : keyPropertyRefs) {
                writer.writeEmptyElement(XML_PROPERTY_REF);
                writer.writeAttribute(XML_NAME, keyRef.getName());
                if (keyRef.getAlias() == null) continue;
                writer.writeAttribute(XML_ALIAS, keyRef.getAlias());
            }
            writer.writeEndElement();
        }
    }

    private void appendEnumTypes(XMLStreamWriter writer, List<EdmEnumType> enumTypes) throws XMLStreamException {
        for (EdmEnumType enumType : enumTypes) {
            writer.writeStartElement(XML_ENUM_TYPE);
            writer.writeAttribute(XML_NAME, enumType.getName());
            writer.writeAttribute(XML_IS_FLAGS, "" + enumType.isFlags());
            writer.writeAttribute(XML_UNDERLYING_TYPE, this.getFullQualifiedName((EdmType)enumType.getUnderlyingType(), false));
            for (String memberName : enumType.getMemberNames()) {
                writer.writeEmptyElement(XML_MEMBER);
                writer.writeAttribute(XML_NAME, memberName);
                writer.writeAttribute(XML_VALUE, enumType.getMember(memberName).getValue());
            }
            writer.writeEndElement();
        }
    }

    private String getFullQualifiedName(EdmType type, boolean isCollection) {
        String name = type.getFullQualifiedName().getFullQualifiedNameAsString();
        return isCollection ? "Collection(" + name + ")" : name;
    }

    private String getAliasedFullQualifiedName(EdmType type, boolean isCollection) {
        FullQualifiedName fqn = type.getFullQualifiedName();
        String name = this.namespaceToAlias.get(fqn.getNamespace()) != null ? this.namespaceToAlias.get(fqn.getNamespace()) + "." + fqn.getName() : fqn.getFullQualifiedNameAsString();
        return isCollection ? "Collection(" + name + ")" : name;
    }

    private void appendReference(XMLStreamWriter writer) throws XMLStreamException {
        for (EdmxReference reference : this.serviceMetadata.getReferences()) {
            writer.writeStartElement(PREFIX_EDMX, REFERENCE, NS_EDMX);
            writer.writeAttribute(URI, reference.getUri().toASCIIString());
            List includes = reference.getIncludes();
            for (EdmxReferenceInclude include : includes) {
                writer.writeStartElement(PREFIX_EDMX, INCLUDE, NS_EDMX);
                writer.writeAttribute(XML_NAMESPACE, include.getNamespace());
                if (include.getAlias() != null) {
                    writer.writeAttribute(XML_ALIAS, include.getAlias());
                }
                writer.writeEndElement();
            }
            List includeAnnotations = reference.getIncludeAnnotations();
            for (EdmxReferenceIncludeAnnotation includeAnnotation : includeAnnotations) {
                writer.writeStartElement(PREFIX_EDMX, INCLUDE_ANNOTATIONS, NS_EDMX);
                writer.writeAttribute(XML_TERM_NAMESPACE, includeAnnotation.getTermNamespace());
                if (includeAnnotation.getQualifier() != null) {
                    writer.writeAttribute(XML_QUALIFIER, includeAnnotation.getQualifier());
                }
                if (includeAnnotation.getTargetNamespace() != null) {
                    writer.writeAttribute(XML_TARGET_NAMESPACE, includeAnnotation.getTargetNamespace());
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }
}

