/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer.xml;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmSingleton;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.edmx.EdmxReference;
import org.apache.olingo.server.api.serializer.SerializerException;

public class ServiceDocumentXmlSerializer {
    public static final String KIND = "kind";
    public static final String FUNCTION_IMPORT = "FunctionImport";
    public static final String SINGLETON = "Singleton";
    public static final String SERVICE_DOCUMENT = "ServiceDocument";
    private static final String APP = "app";
    private static final String NS_APP = "http://www.w3.org/2007/app";
    private static final String ATOM = "atom";
    private static final String NS_ATOM = "http://www.w3.org/2005/Atom";
    private static final String METADATA = "metadata";
    private static final String NS_METADATA = "http://docs.oasis-open.org/odata/ns/metadata";
    private final ServiceMetadata metadata;
    private final String serviceRoot;

    public ServiceDocumentXmlSerializer(ServiceMetadata metadata, String serviceRoot) throws SerializerException {
        if (metadata == null || metadata.getEdm() == null) {
            throw new SerializerException("Service Metadata and EDM must not be null for a service.", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.NULL_METADATA_OR_EDM, new String[0]);
        }
        this.metadata = metadata;
        this.serviceRoot = serviceRoot;
    }

    public void writeServiceDocument(XMLStreamWriter writer) throws XMLStreamException {
        String metadataUri = (this.serviceRoot == null ? "" : (this.serviceRoot.endsWith("/") ? this.serviceRoot : this.serviceRoot + "/")) + "$metadata";
        writer.writeStartDocument("UTF-8", "1.0");
        writer.writeStartElement(APP, "service", NS_APP);
        writer.writeNamespace(ATOM, NS_ATOM);
        writer.writeNamespace(APP, NS_APP);
        writer.writeNamespace(METADATA, NS_METADATA);
        writer.writeAttribute(METADATA, NS_METADATA, "context", metadataUri);
        if (this.metadata != null && this.metadata.getServiceMetadataETagSupport() != null && this.metadata.getServiceMetadataETagSupport().getMetadataETag() != null) {
            writer.writeAttribute(METADATA, NS_METADATA, "metadata-etag", this.metadata.getServiceMetadataETagSupport().getMetadataETag());
        }
        writer.writeStartElement(APP, "workspace", NS_APP);
        Edm edm = this.metadata.getEdm();
        writer.writeStartElement(ATOM, "title", NS_APP);
        writer.writeCharacters(edm.getEntityContainer(null).getFullQualifiedName().getFullQualifiedNameAsString());
        writer.writeEndElement();
        this.writeEntitySets(writer, edm);
        this.writeFunctionImports(writer, edm);
        this.writeSingletons(writer, edm);
        this.writeServiceDocuments(writer);
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private void writeServiceDocuments(XMLStreamWriter writer) throws XMLStreamException {
        for (EdmxReference reference : this.metadata.getReferences()) {
            writer.writeStartElement(METADATA, "service-document", NS_METADATA);
            writer.writeAttribute("href", reference.getUri().toASCIIString());
            writer.writeStartElement(ATOM, "title", NS_ATOM);
            writer.writeCharacters(reference.getUri().toASCIIString());
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    private void writeEntitySets(XMLStreamWriter writer, Edm edm) throws XMLStreamException {
        EdmEntityContainer container = edm.getEntityContainer(null);
        for (EdmEntitySet edmEntitySet : container.getEntitySets()) {
            if (!edmEntitySet.isIncludeInServiceDocument()) continue;
            writer.writeStartElement(APP, "collection", NS_APP);
            writer.writeAttribute("href", edmEntitySet.getName());
            writer.writeStartElement(ATOM, "title", NS_ATOM);
            writer.writeCharacters(edmEntitySet.getName());
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    private void writeFunctionImports(XMLStreamWriter writer, Edm edm) throws XMLStreamException {
        EdmEntityContainer container = edm.getEntityContainer(null);
        for (EdmFunctionImport edmFunctionImport : container.getFunctionImports()) {
            if (!edmFunctionImport.isIncludeInServiceDocument()) continue;
            writer.writeStartElement(METADATA, "function-import", NS_METADATA);
            writer.writeAttribute("href", edmFunctionImport.getName());
            writer.writeStartElement(ATOM, "title", NS_ATOM);
            writer.writeCharacters(edmFunctionImport.getName());
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    private void writeSingletons(XMLStreamWriter writer, Edm edm) throws XMLStreamException {
        EdmEntityContainer container = edm.getEntityContainer(null);
        for (EdmSingleton edmSingleton : container.getSingletons()) {
            writer.writeStartElement(METADATA, "singleton", NS_METADATA);
            writer.writeAttribute("href", edmSingleton.getName());
            writer.writeStartElement(ATOM, "title", NS_ATOM);
            writer.writeCharacters(edmSingleton.getName());
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }
}

