/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.deserializer.batch.BatchDeserializerException;
import org.apache.olingo.server.api.serializer.CustomContentTypeSupport;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.RepresentationType;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.queryoption.FormatOption;
import org.apache.olingo.server.core.ContentNegotiator;
import org.apache.olingo.server.core.ContentNegotiatorException;
import org.apache.olingo.server.core.ODataExceptionHelper;
import org.apache.olingo.server.core.ODataHandlerException;
import org.apache.olingo.server.core.uri.parser.Parser;
import org.apache.olingo.server.core.uri.parser.UriParserException;
import org.apache.olingo.server.core.uri.parser.UriParserSemanticException;
import org.apache.olingo.server.core.uri.parser.UriParserSyntaxException;
import org.apache.olingo.server.core.uri.validator.UriValidationException;

public class ErrorHandler {
    private final OData odata;
    private final ServiceMetadata metadata;
    private final CustomContentTypeSupport customContent;

    public ErrorHandler(OData odata, ServiceMetadata metadata, CustomContentTypeSupport customContent) {
        this.odata = odata;
        this.metadata = metadata;
        this.customContent = customContent;
    }

    public void handleException(Exception e, ODataRequest request, ODataResponse response) {
        if (e instanceof UriValidationException) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject((UriValidationException)((UriValidationException)e), null);
            this.handleServerError(request, response, serverError);
        } else if (e instanceof UriParserSemanticException) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject((UriParserSemanticException)((UriParserSemanticException)e), null);
            this.handleServerError(request, response, serverError);
        } else if (e instanceof UriParserSyntaxException) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject((UriParserSyntaxException)((UriParserSyntaxException)e), null);
            this.handleServerError(request, response, serverError);
        } else if (e instanceof UriParserException) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject((UriParserException)((UriParserException)e), null);
            this.handleServerError(request, response, serverError);
        } else if (e instanceof ContentNegotiatorException) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject((ContentNegotiatorException)((ContentNegotiatorException)e), null);
            this.handleServerError(request, response, serverError);
        } else if (e instanceof SerializerException) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject((SerializerException)((SerializerException)e), null);
            this.handleServerError(request, response, serverError);
        } else if (e instanceof BatchDeserializerException) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject((DeserializerException)((BatchDeserializerException)e), null);
            this.handleServerError(request, response, serverError);
        } else if (e instanceof DeserializerException) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject((DeserializerException)((DeserializerException)e), null);
            this.handleServerError(request, response, serverError);
        } else if (e instanceof ODataHandlerException) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject((ODataHandlerException)((ODataHandlerException)e), null);
            this.handleServerError(request, response, serverError);
        } else {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject((Exception)e);
            this.handleServerError(request, response, serverError);
        }
    }

    void handleServerError(ODataRequest request, ODataResponse response, ODataServerError serverError) {
        ContentType requestedContentType;
        try {
            UriInfo uriInfo = new Parser().parseUri(request.getRawODataPath(), request.getRawQueryPath(), null, this.metadata.getEdm());
            requestedContentType = ContentNegotiator.doContentNegotiation((FormatOption)uriInfo.getFormatOption(), (ODataRequest)request, (CustomContentTypeSupport)this.customContent, (RepresentationType)RepresentationType.ERROR);
        }
        catch (ContentNegotiatorException e) {
            requestedContentType = ContentType.JSON;
        }
        catch (UriParserException e) {
            requestedContentType = ContentType.JSON;
        }
        this.processError(response, serverError, requestedContentType);
    }

    void processError(ODataResponse response, ODataServerError serverError, ContentType requestedContentType) {
        try {
            ODataSerializer serializer = this.odata.createSerializer(requestedContentType);
            response.setContent(serializer.error(serverError).getContent());
            response.setStatusCode(serverError.getStatusCode());
            response.setHeader("Content-Type", requestedContentType.toContentTypeString());
        }
        catch (Exception e) {
            String responseContent = "{\"error\":{\"code\":null,\"message\":\"An unexpected exception occurred during error processing with message: " + e.getMessage() + "\"}}";
            response.setContent((InputStream)new ByteArrayInputStream(responseContent.getBytes()));
            response.setStatusCode(HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            response.setHeader("Content-Type", ContentType.APPLICATION_JSON.toContentTypeString());
        }
    }
}

