/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAnnotationsTarget;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmMember;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotatable;
import org.apache.olingo.commons.api.edm.provider.CsdlEnumMember;
import org.apache.olingo.commons.api.edm.provider.CsdlEnumType;
import org.apache.olingo.commons.core.edm.EdmMemberImpl;
import org.apache.olingo.commons.core.edm.EdmTypeImpl;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt64;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;

public class EdmEnumTypeImpl
extends EdmTypeImpl
implements EdmEnumType {
    private static final Set<EdmPrimitiveTypeKind> VALID_UNDERLYING_TYPES = new HashSet<EdmPrimitiveTypeKind>();
    private final EdmPrimitiveType underlyingType;
    private final CsdlEnumType enumType;
    private final String uriPrefix;
    private final String uriSuffix;
    private List<String> memberNames;
    private LinkedHashMap<String, EdmMember> membersMap;

    public EdmEnumTypeImpl(Edm edm, FullQualifiedName enumName, CsdlEnumType enumType) {
        super(edm, enumName, EdmTypeKind.ENUM, (CsdlAnnotatable)enumType);
        if (enumType.getUnderlyingType() == null) {
            this.underlyingType = EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Int32);
        } else {
            EdmPrimitiveTypeKind underlyingTypeKind = EdmPrimitiveTypeKind.valueOfFQN((String)enumType.getUnderlyingType());
            if (!VALID_UNDERLYING_TYPES.contains(underlyingTypeKind)) {
                throw new EdmException("Not allowed as underlying type: " + underlyingTypeKind);
            }
            this.underlyingType = EdmPrimitiveTypeFactory.getInstance(underlyingTypeKind);
        }
        this.enumType = enumType;
        this.uriPrefix = enumName.getFullQualifiedNameAsString() + '\'';
        this.uriSuffix = "'";
    }

    public EdmPrimitiveType getUnderlyingType() {
        return this.underlyingType;
    }

    public EdmMember getMember(String name) {
        if (this.membersMap == null) {
            this.createEdmMembers();
        }
        return this.membersMap.get(name);
    }

    public List<String> getMemberNames() {
        if (this.memberNames == null) {
            this.createEdmMembers();
        }
        return Collections.unmodifiableList(this.memberNames);
    }

    private void createEdmMembers() {
        LinkedHashMap<String, EdmMemberImpl> membersMapLocal = new LinkedHashMap<String, EdmMemberImpl>();
        ArrayList<String> memberNamesLocal = new ArrayList<String>();
        if (this.enumType.getMembers() != null) {
            for (CsdlEnumMember member : this.enumType.getMembers()) {
                membersMapLocal.put(member.getName(), new EdmMemberImpl(this.edm, this.getFullQualifiedName(), member));
                memberNamesLocal.add(member.getName());
            }
            this.membersMap = membersMapLocal;
            this.memberNames = memberNamesLocal;
        }
    }

    public boolean isCompatible(EdmPrimitiveType primitiveType) {
        return this.equals(primitiveType);
    }

    public Class<?> getDefaultType() {
        return this.getUnderlyingType().getDefaultType();
    }

    public boolean validate(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) {
        try {
            this.valueOfString(value, isNullable, maxLength, precision, scale, isUnicode, this.getDefaultType());
            return true;
        }
        catch (EdmPrimitiveTypeException e) {
            return false;
        }
    }

    private Long parseEnumValue(String value) throws EdmPrimitiveTypeException {
        Long result = null;
        for (String memberValue : value.split(",", this.isFlags() ? -1 : 1)) {
            Long memberValueLong = null;
            for (EdmMember member : this.getMembers()) {
                if (!member.getName().equals(memberValue) && !member.getValue().equals(memberValue)) continue;
                memberValueLong = Long.decode(member.getValue());
            }
            if (memberValueLong == null) {
                throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.");
            }
            result = result == null ? memberValueLong : result | memberValueLong;
        }
        return result;
    }

    public <T> T valueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        if (value == null) {
            if (isNullable != null && !isNullable.booleanValue()) {
                throw new EdmPrimitiveTypeException("The literal 'null' is not allowed.");
            }
            return null;
        }
        try {
            return EdmInt64.convertNumber(this.parseEnumValue(value), returnType);
        }
        catch (IllegalArgumentException e) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' cannot be converted to value type " + returnType + ".", (Exception)e);
        }
        catch (ClassCastException e) {
            throw new EdmPrimitiveTypeException("The value type " + returnType + " is not supported.", (Exception)e);
        }
    }

    private String constructEnumValue(long value) throws EdmPrimitiveTypeException {
        long remaining = value;
        StringBuilder result = new StringBuilder();
        boolean flags = this.isFlags();
        for (EdmMember member : this.getMembers()) {
            long memberValue = Long.parseLong(member.getValue());
            if (flags) {
                if ((memberValue & remaining) != memberValue) continue;
                if (result.length() > 0) {
                    result.append(',');
                }
                result.append(member.getName());
                remaining ^= memberValue;
                continue;
            }
            if (value != memberValue) continue;
            return member.getName();
        }
        if (remaining != 0L) {
            throw new EdmPrimitiveTypeException("The value '" + value + "' is not valid.");
        }
        return result.toString();
    }

    private Collection<EdmMember> getMembers() {
        if (this.membersMap == null) {
            this.createEdmMembers();
        }
        return this.membersMap.values();
    }

    public String valueToString(Object value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        if (value == null) {
            if (isNullable != null && !isNullable.booleanValue()) {
                throw new EdmPrimitiveTypeException("The value NULL is not allowed.");
            }
            return null;
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return this.constructEnumValue(((Number)value).longValue());
        }
        throw new EdmPrimitiveTypeException("The value type " + value.getClass() + " is not supported.");
    }

    public String toUriLiteral(String literal) {
        return literal == null ? null : (this.uriPrefix.isEmpty() && this.uriSuffix.isEmpty() ? literal : this.uriPrefix + literal + this.uriSuffix);
    }

    public String fromUriLiteral(String literal) throws EdmPrimitiveTypeException {
        if (literal == null) {
            return null;
        }
        if (this.uriPrefix.isEmpty() && this.uriSuffix.isEmpty()) {
            return literal;
        }
        if (literal.length() >= this.uriPrefix.length() + this.uriSuffix.length() && literal.startsWith(this.uriPrefix) && literal.endsWith(this.uriSuffix)) {
            return literal.substring(this.uriPrefix.length(), literal.length() - this.uriSuffix.length());
        }
        throw new EdmPrimitiveTypeException("The literal '" + literal + "' has illegal content.");
    }

    public boolean isFlags() {
        return this.enumType.isFlags();
    }

    public EdmAnnotationsTarget.TargetType getAnnotationsTargetType() {
        return EdmAnnotationsTarget.TargetType.EnumType;
    }

    public String getAnnotationsTargetPath() {
        return null;
    }

    public FullQualifiedName getAnnotationsTargetFQN() {
        return this.getFullQualifiedName();
    }

    public int hashCode() {
        return this.getFullQualifiedName().getFullQualifiedNameAsString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof EdmEnumType) {
            EdmEnumType other = (EdmEnumType)obj;
            if (this.getFullQualifiedName().equals((Object)other.getFullQualifiedName())) {
                return true;
            }
        }
        return false;
    }

    static {
        VALID_UNDERLYING_TYPES.add(EdmPrimitiveTypeKind.Byte);
        VALID_UNDERLYING_TYPES.add(EdmPrimitiveTypeKind.SByte);
        VALID_UNDERLYING_TYPES.add(EdmPrimitiveTypeKind.Int16);
        VALID_UNDERLYING_TYPES.add(EdmPrimitiveTypeKind.Int32);
        VALID_UNDERLYING_TYPES.add(EdmPrimitiveTypeKind.Int64);
    }
}

