/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.transaction.TransactionManager;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.core.Encoder;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.GeneratedKeys;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.service.AutoGenDataService;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.language.Command;
import org.teiid.language.QueryExpression;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.odata.api.Client;
import org.teiid.olingo.service.LocalClient;
import org.teiid.olingo.web.ODataFilter;
import org.teiid.olingo.web.ODataServlet;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.runtime.HardCodedExecutionFactory;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.loopback.LoopbackExecutionFactory;

public class TestODataIntegration {
    private static final String CRLF = "\r\n";
    private static final String MIME_HEADERS = "Content-Type: application/http\r\nContent-Transfer-Encoding: binary\r\n";
    private static EmbeddedServer teiid;
    private static Server server;
    private static String baseURL;
    private static HttpClient http;
    private static LocalClient localClient;

    @Before
    public void before() throws Exception {
        teiid = new EmbeddedServer();
        EmbeddedConfiguration config = new EmbeddedConfiguration();
        config.setTransactionManager((TransactionManager)Mockito.mock(TransactionManager.class));
        teiid.start(config);
        teiid.addTranslator(LoopbackExecutionFactory.class);
        ServerConnector connector = new ServerConnector(server);
        server.setConnectors(new Connector[]{connector});
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/odata4");
        context.addServlet(new ServletHolder((Servlet)new ODataServlet()), "/*");
        context.addFilter(new FilterHolder((Filter)new ODataFilter(){

            public Client buildClient(String vdbName, int version, Properties props) {
                if (localClient != null) {
                    return localClient;
                }
                return TestODataIntegration.this.getClient(teiid.getDriver(), vdbName, version, props);
            }
        }), "/*", EnumSet.allOf(DispatcherType.class));
        server.setHandler((Handler)context);
        server.start();
        int port = connector.getLocalPort();
        http.start();
        baseURL = "http://localhost:" + port + "/odata4";
        TestODataIntegration.deployVDB();
    }

    @After
    public void after() throws Exception {
        server.stop();
        teiid.stop();
    }

    private static void deployVDB() throws IOException, ConnectorManagerRepository.ConnectorManagerException, VirtualDatabaseException, TranslatorException {
        teiid.deployVDB((InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"loopy-vdb.xml")));
    }

    private JsonNode getJSONNode(ContentResponse response) throws IOException, JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode node = objectMapper.readTree(response.getContent());
        return node;
    }

    @Test
    public void testMetadata() throws Exception {
        ContentResponse response = http.GET(baseURL + "/loopy/vm1/$metadata");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"loopy-edmx-metadata.xml")), (Object)response.getContentAsString());
    }

    @Test
    public void testSystemMetadata() throws Exception {
        ContentResponse response = http.GET(baseURL + "/loopy/SYS/$metadata");
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testServiceMetadata() throws Exception {
        ContentResponse response = http.GET(baseURL + "/loopy/VM1");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        String expected = "{\"@odata.context\":\"" + baseURL + "/loopy/VM1/$metadata\"," + "\"value\":[{" + "\"name\":\"G1\"," + "\"url\":\"G1\"" + "},{" + "\"name\":\"G2\"," + "\"url\":\"G2\"" + "},{" + "\"name\":\"G4\"," + "\"url\":\"G4\"" + "}]" + "}";
        Assert.assertEquals((Object)expected, (Object)response.getContentAsString());
    }

    @Test
    public void testEntitySet() throws Exception {
        ContentResponse response = http.GET(baseURL + "/loopy/vm1/G1");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#G1\",\"value\":[{\"e1\":\"ABCDEFGHIJ\",\"e2\":0,\"e3\":0.0}]}", (Object)response.getContentAsString());
    }

    @Test
    public void testEntitySetWithKey() throws Exception {
        ContentResponse response = http.GET(baseURL + "/loopy/vm1/G1(0)");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#G1/$entity\",\"e1\":\"ABCDEFGHIJ\",\"e2\":0,\"e3\":0.0}", (Object)response.getContentAsString());
    }

    @Test
    public void testIndividualProperty() throws Exception {
        ContentResponse response = http.GET(baseURL + "/loopy/vm1/G1(0)/e1");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#G1(0)/e1\",\"value\":\"ABCDEFGHIJ\"}", (Object)response.getContentAsString());
    }

    @Test
    public void testIndividualProperty$Value() throws Exception {
        ContentResponse response = http.GET(baseURL + "/loopy/vm1/G1(0)/e1/$value");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"ABCDEFGHIJ", (Object)response.getContentAsString());
    }

    @Test
    public void testNavigation_1_to_1() throws Exception {
        ContentResponse response = http.GET(baseURL + "/loopy/pm1/G2(0)/FK0");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#G1/$entity\",\"e1\":\"ABCDEFGHIJ\",\"e2\":0,\"e3\":0.0}", (Object)response.getContentAsString());
    }

    @Test
    public void testNavigation_1_to_many() throws Exception {
        ContentResponse response = http.GET(baseURL + "/loopy/vm1/G1(0)/G2_FK0");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#G2\",\"value\":[{\"e1\":\"ABCDEFGHIJ\",\"e2\":0}]}", (Object)response.getContentAsString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsert() throws Exception {
        HardCodedExecutionFactory hc = this.buildHardCodedExecutionFactory();
        hc.addUpdate("INSERT INTO x (a, b) VALUES ('teiid', 'dv')", new int[]{1});
        teiid.addTranslator("x10", (ExecutionFactory)hc);
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("m");
            mmd.addSourceMetadata("ddl", "create foreign table x ( a string,  b string,  primary key (a)) options (updatable true);");
            mmd.addSourceMapping("x10", "x10", null);
            teiid.deployVDB("northwind", new ModelMetaData[]{mmd});
            localClient = this.getClient(teiid.getDriver(), "northwind", 1, new Properties());
            String payload = "{\n  \"a\":\"teiid\",\n  \"b\":\"dv\"\n}";
            ContentResponse response = http.newRequest(baseURL + "/northwind/m/x").method("POST").content((ContentProvider)new StringContentProvider(payload)).header("Content-Type", "application/json").send();
            Assert.assertEquals((long)204L, (long)response.getStatus());
            Assert.assertTrue((boolean)response.getHeaders().get("OData-EntityId").endsWith("northwind/m/x('ABCDEFG')"));
        }
        finally {
            localClient = null;
            teiid.undeployVDB("northwind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeepInsert() throws Exception {
        HardCodedExecutionFactory hc = this.buildHardCodedExecutionFactory();
        hc.addUpdate("INSERT INTO x (a, b) VALUES ('teiid', 'dv')", new int[]{1});
        hc.addUpdate("INSERT INTO y (a, b) VALUES ('odata', 'olingo')", new int[]{1});
        hc.addUpdate("INSERT INTO y (a, b) VALUES ('odata4', 'olingo4')", new int[]{1});
        teiid.addTranslator("x10", (ExecutionFactory)hc);
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("m");
            mmd.addSourceMetadata("ddl", "create foreign table x ( a string,  b string,  primary key (a)) options (updatable true);create foreign table y ( a string,  b string,  primary key (a), CONSTRAINT FKX FOREIGN KEY (b) REFERENCES x(a)) options (updatable true);");
            mmd.addSourceMapping("x10", "x10", null);
            teiid.deployVDB("northwind", new ModelMetaData[]{mmd});
            localClient = this.getClient(teiid.getDriver(), "northwind", 1, new Properties());
            String payload = "{\n  \"a\":\"teiid\",\n  \"b\":\"dv\",\n     \"y_FKX\": [\n        {          \"a\":\"odata\",\n          \"b\":\"olingo\"\n        },\n        {\n          \"a\":\"odata4\",\n          \"b\":\"olingo4\"\n        }\n     ]\n}";
            ContentResponse response = http.newRequest(baseURL + "/northwind/m/x").method("POST").content((ContentProvider)new StringContentProvider(payload), ContentType.APPLICATION_JSON.toString()).header("Prefer", "return=representation").send();
            Assert.assertEquals((long)201L, (long)response.getStatus());
            Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#x\",\"a\":\"ABCDEFG\",\"b\":\"ABCDEFG\"}", (Object)response.getContentAsString());
        }
        finally {
            localClient = null;
            teiid.undeployVDB("northwind");
        }
    }

    @Test
    public void testFunction() throws Exception {
        ContentResponse response = http.GET(baseURL + "/loopy/vm1/proc(x='foo')");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#Edm.String\",\"value\":\"foo\"}", (Object)response.getContentAsString());
    }

    @Test
    public void testFunctionDate() throws Exception {
        ContentResponse response = http.GET(baseURL + "/loopy/vm1/getCustomers(p2='2011-09-11T00:00:00',p3=2.0)");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#Edm.DateTimeOffset\",\"value\":\"2011-09-11T00:00:00Z\"}", (Object)response.getContentAsString());
    }

    @Test
    public void testFunctionReturningResultSet() throws Exception {
        ContentResponse response = http.GET(baseURL + "/loopy/vm1/procResultSet(x='foo',y=1)");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#Collection(Loopy.1.VM1.procResultSet_RSParam)\",\"value\":[{\"x\":\"foo\",\"y\":1}]}", (Object)response.getContentAsString());
    }

    @Test
    public void testFunctionReturningStream() throws Exception {
        ContentResponse response = http.GET(baseURL + "/loopy/vm1/procXML(x='foo')");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"<name>foo</name>", (Object)response.getContentAsString());
    }

    @Test
    public void testFunctionReturningStreamDesignedToReturnTable() throws Exception {
        ContentResponse response = http.GET(baseURL + "/loopy/vm1/procComposableXML(x='foo')");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"<name>foo</name>", (Object)response.getContentAsString());
    }

    @Test
    public void testActionStream() throws Exception {
        ContentResponse response = http.newRequest(baseURL + "/loopy/vm1/actionXML").method("POST").content((ContentProvider)new StringContentProvider("<name>foo2</name>"), "application/xml").send();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"<name>foo2</name>", (Object)response.getContentAsString());
    }

    @Test
    public void testActionSimpleParameters() throws Exception {
        ContentResponse response = http.newRequest(baseURL + "/loopy/vm1/procActionJSON").method("POST").content((ContentProvider)new StringContentProvider("{\"x\": \"foo\", \"y\": 4.5}"), "application/json").send();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"{\"x1\":\"foo\",\"y1\":4.5}", (Object)response.getContentAsString());
    }

    @Test
    public void testMetadataVisibility() throws Exception {
        ContentResponse response = http.GET(baseURL + "/loopy/PM2/G1");
        Assert.assertEquals((long)500L, (long)response.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckGeneratedColumns() throws Exception {
        HardCodedExecutionFactory hc = new HardCodedExecutionFactory(){

            public UpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
                GeneratedKeys keys = executionContext.getCommandContext().returnGeneratedKeys(new String[]{"a"}, new Class[]{String.class});
                keys.addKey(Arrays.asList("ax"));
                return super.createUpdateExecution(command, executionContext, metadata, connection);
            }

            public boolean supportsCompareCriteriaEquals() {
                return true;
            }
        };
        hc.addUpdate("INSERT INTO x (b, c) VALUES ('b', 5)", new int[]{1});
        hc.addData("SELECT x.a, x.b, x.c FROM x WHERE x.a = 'ax'", Arrays.asList(Arrays.asList("a", "b", 2)));
        teiid.addTranslator("x", (ExecutionFactory)hc);
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("m");
            mmd.addSourceMetadata("ddl", "create foreign table x (a string, b string, c integer, primary key (a)) options (updatable true);");
            mmd.addSourceMapping("x", "x", null);
            teiid.deployVDB("northwind", new ModelMetaData[]{mmd});
            localClient = this.getClient(teiid.getDriver(), "northwind", 1, new Properties());
            ContentResponse response = http.newRequest(baseURL + "/northwind/m/x").method("POST").content((ContentProvider)new StringContentProvider("{\"b\":\"b\", \"c\":5}"), "application/json").send();
            Assert.assertEquals((long)204L, (long)response.getStatus());
        }
        finally {
            localClient = null;
            teiid.undeployVDB("northwind");
        }
    }

    private LocalClient getClient(final TeiidDriver driver, final String vdb, int version, final Properties properties) {
        return new LocalClient(vdb, 1, properties){
            ConnectionImpl conn;

            public ConnectionImpl getConnection() {
                return this.conn;
            }

            public void close() throws SQLException {
                if (this.conn != null) {
                    this.conn.close();
                }
            }

            public Connection open() throws SQLException {
                try {
                    this.conn = LocalClient.buildConnection((TeiidDriver)driver, (String)vdb, (int)1, (Properties)properties);
                    return this.conn;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        };
    }

    @Test
    public void testSkipNoPKTable() throws Exception {
        ContentResponse response = http.GET(baseURL + "/loopy/PM1/NoPKTable");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertEquals((Object)"{\"error\":{\"code\":null,\"message\":\"Cannot find EntitySet, Singleton, ActionImport or FunctionImport with name 'NoPKTable'.\"}}", (Object)response.getContentAsString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidCharacterReplacement() throws Exception {
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("vw");
            mmd.addSourceMetadata("DDL", "create view x (a string primary key, b char, c string[], d integer) as select 'ab\u0000cd\u0001', char(22), ('a\u00021','b1'), 1;");
            mmd.setModelType(Model.Type.VIRTUAL);
            teiid.deployVDB("northwind", new ModelMetaData[]{mmd});
            Properties props = new Properties();
            props.setProperty("invalid-xml10-character-replacement", " ");
            localClient = this.getClient(teiid.getDriver(), "northwind", 1, props);
            ContentResponse response = http.GET(baseURL + "/northwind/vw/x");
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#x\",\"value\":[{\"a\":\"ab cd \",\"b\":\" \",\"c\":[\"a 1\",\"b1\"],\"d\":1}]}", (Object)response.getContentAsString());
        }
        finally {
            localClient = null;
            teiid.undeployVDB("northwind");
        }
    }

    @Test
    public void testArrayResults() throws Exception {
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("vw");
            mmd.addSourceMetadata("DDL", "create view x (a string primary key, b integer[], c string[][]) as select 'x', (1, 2, 3), (('a','b'),('c','d')) union select 'y', (4, 5, 6), (('x','y'),('z','u'));");
            mmd.setModelType(Model.Type.VIRTUAL);
            teiid.deployVDB("northwind", new ModelMetaData[]{mmd});
            localClient = this.getClient(teiid.getDriver(), "northwind", 1, new Properties());
            ContentResponse response = http.GET(baseURL + "/northwind/vw/x?$format=json&$select=a,b");
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#x(a,b)\",\"value\":[{\"a\":\"x\",\"b\":[1,2,3]},{\"a\":\"y\",\"b\":[4,5,6]}]}", (Object)response.getContentAsString());
            response = http.GET(baseURL + "/northwind/vw/x?$format=json");
            Assert.assertEquals((long)500L, (long)response.getStatus());
        }
        finally {
            localClient = null;
            teiid.undeployVDB("northwind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test$ItFilter() throws Exception {
        HardCodedExecutionFactory hc = this.buildHardCodedExecutionFactory();
        hc.addData("SELECT x.c, x.a FROM x WHERE x.a = 'x'", Arrays.asList(Arrays.asList(new String[]{"google.net", "google.com"}, Character.valueOf('x'))));
        hc.addData("SELECT x.c, x.a FROM x WHERE x.a = 'y'", Arrays.asList(Arrays.asList(new String[]{"example.net", "example.com"}, Character.valueOf('y'))));
        teiid.addTranslator("x8", (ExecutionFactory)hc);
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("vw");
            mmd.addSourceMetadata("DDL", "create foreign table x  (a string primary key, b integer[], c string[]);");
            mmd.setModelType(Model.Type.PHYSICAL);
            mmd.addSourceMapping("x8", "x8", null);
            teiid.deployVDB("northwind", new ModelMetaData[]{mmd});
            localClient = this.getClient(teiid.getDriver(), "northwind", 1, new Properties());
            ContentResponse response = http.GET(baseURL + "/northwind/vw/x('x')/c?$filter=endswith($it,'com')");
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#x('x')/c\",\"value\":[\"google.com\"]}", (Object)response.getContentAsString());
            response = http.GET(baseURL + "/northwind/vw/x('y')/c?$filter=startswith($it,'example')");
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#x('y')/c\",\"value\":[\"example.net\",\"example.com\"]}", (Object)response.getContentAsString());
        }
        finally {
            localClient = null;
            teiid.undeployVDB("northwind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArrayInsertResults() throws Exception {
        HardCodedExecutionFactory hc = this.buildHardCodedExecutionFactory();
        hc.addUpdate("INSERT INTO x (a, b) VALUES ('x', (1, 2, 3))", new int[]{1});
        teiid.addTranslator("x5", (ExecutionFactory)hc);
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("m");
            mmd.addSourceMetadata("DDL", "create foreign table x (a string primary key, b integer[], c string[][]) OPTIONS (updatable true);");
            mmd.setModelType(Model.Type.PHYSICAL);
            mmd.addSourceMapping("x5", "x5", null);
            teiid.deployVDB("northwind", new ModelMetaData[]{mmd});
            localClient = this.getClient(teiid.getDriver(), "northwind", 1, new Properties());
            ContentResponse response = http.newRequest(baseURL + "/northwind/m/x").method("POST").content((ContentProvider)new StringContentProvider("{\"a\":\"x\",\"b\":[1,2,3]}"), "application/json").send();
            Assert.assertEquals((long)204L, (long)response.getStatus());
        }
        finally {
            localClient = null;
            teiid.undeployVDB("northwind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArrayUpdateResults() throws Exception {
        HardCodedExecutionFactory hc = this.buildHardCodedExecutionFactory();
        hc.addUpdate("UPDATE x SET b = (1, 2, 3) WHERE x.a = 'x'", new int[]{1});
        teiid.addTranslator("x6", (ExecutionFactory)hc);
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("m");
            mmd.addSourceMetadata("DDL", "create foreign table x (a string primary key, b integer[], c string[][]) OPTIONS (updatable true);");
            mmd.setModelType(Model.Type.PHYSICAL);
            mmd.addSourceMapping("x6", "x6", null);
            teiid.deployVDB("northwind", new ModelMetaData[]{mmd});
            localClient = this.getClient(teiid.getDriver(), "northwind", 1, new Properties());
            ContentResponse response = http.newRequest(baseURL + "/northwind/m/x('x')").method("PATCH").content((ContentProvider)new StringContentProvider("{\"a\":\"x\",\"b\":[1,2,3]}"), "application/json").send();
            Assert.assertEquals((long)204L, (long)response.getStatus());
        }
        finally {
            localClient = null;
            teiid.undeployVDB("northwind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkipToken() throws Exception {
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("vw");
            mmd.addSourceMetadata("ddl", "create view x (a string primary key, b integer) as select 'xyz', 123 union all select 'abc', 456;");
            mmd.setModelType(Model.Type.VIRTUAL);
            teiid.deployVDB("northwind", new ModelMetaData[]{mmd});
            Properties props = new Properties();
            props.setProperty("batch-size", "1");
            localClient = this.getClient(teiid.getDriver(), "northwind", 1, props);
            ContentResponse response = http.GET(baseURL + "/northwind/vw/x?$format=json");
            Assert.assertEquals((long)200L, (long)response.getStatus());
            String starts = "{\"@odata.context\":\"$metadata#x\",\"value\":[{\"a\":\"abc\",\"b\":456}],\"@odata.nextLink\":\"" + baseURL + "/northwind/vw/x?$format=json&$skiptoken=";
            String ends = "--1\"}";
            System.out.println(baseURL);
            Assert.assertTrue((String)response.getContentAsString(), (boolean)response.getContentAsString().startsWith(starts));
            Assert.assertTrue((boolean)response.getContentAsString().endsWith(ends));
            JsonNode node = this.getJSONNode(response);
            String nextLink = node.get("@odata.nextLink").asText();
            response = http.GET(nextLink);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#x\",\"value\":[{\"a\":\"xyz\",\"b\":123}]}", (Object)response.getContentAsString());
        }
        finally {
            localClient = null;
            teiid.undeployVDB("northwind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkipTokenNoSystemOptions() throws Exception {
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("vw");
            mmd.addSourceMetadata("ddl", "create view x (a string primary key, b integer) as select 'xyz', 123 union all select 'abc', 456;");
            mmd.setModelType(Model.Type.VIRTUAL);
            teiid.deployVDB("northwind", new ModelMetaData[]{mmd});
            Properties props = new Properties();
            props.setProperty("batch-size", "1");
            localClient = this.getClient(teiid.getDriver(), "northwind", 1, props);
            ContentResponse response = http.GET(baseURL + "/northwind/vw/x");
            Assert.assertEquals((long)200L, (long)response.getStatus());
        }
        finally {
            localClient = null;
            teiid.undeployVDB("northwind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkipTokenWithPageSize() throws Exception {
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("vw");
            mmd.addSourceMetadata("ddl", "create view x (a string primary key, b integer) as select 'xyz', 123 union all select 'abc', 456;");
            mmd.setModelType(Model.Type.VIRTUAL);
            teiid.deployVDB("northwind", new ModelMetaData[]{mmd});
            ContentResponse response = http.newRequest(baseURL + "/northwind/vw/x?$format=json").header("Prefer", "odata.maxpagesize=1").send();
            Assert.assertEquals((long)200L, (long)response.getStatus());
            String starts = "{\"@odata.context\":\"$metadata#x\",\"value\":[{\"a\":\"abc\",\"b\":456}],\"@odata.nextLink\":\"" + baseURL + "/northwind/vw/x?$format=json&$skiptoken=";
            String ends = "--1\"}";
            Assert.assertTrue((boolean)response.getContentAsString().startsWith(starts));
            Assert.assertTrue((boolean)response.getContentAsString().endsWith(ends));
            Assert.assertEquals((Object)"odata.maxpagesize=1", (Object)this.getHeader(response, "Preference-Applied"));
            JsonNode node = this.getJSONNode(response);
            String nextLink = node.get("@odata.nextLink").asText();
            response = http.GET(nextLink);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#x\",\"value\":[{\"a\":\"xyz\",\"b\":123}]}", (Object)response.getContentAsString());
        }
        finally {
            teiid.undeployVDB("northwind");
        }
    }

    private String getHeader(ContentResponse response, String header) {
        return response.getHeaders().get(header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCount() throws Exception {
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("vw");
            mmd.addSourceMetadata("ddl", "create view x (a string primary key, b integer) as select 'xyz', 123 union all select 'abc', 456;");
            mmd.setModelType(Model.Type.VIRTUAL);
            teiid.deployVDB("northwind", new ModelMetaData[]{mmd});
            Properties props = new Properties();
            props.setProperty("batch-size", "1");
            localClient = this.getClient(teiid.getDriver(), "northwind", 1, props);
            ContentResponse response = http.GET(baseURL + "/northwind/vw/x?$format=json&$count=true&$top=1&$skip=1");
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#x\",\"@odata.count\":2,\"value\":[{\"a\":\"xyz\",\"b\":123}]}", (Object)response.getContentAsString());
            response = http.GET(baseURL + "/northwind/vw/x?$format=json&$count=true&$skip=1");
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#x\",\"@odata.count\":2,\"value\":[{\"a\":\"xyz\",\"b\":123}]}", (Object)response.getContentAsString());
            response = http.GET(baseURL + "/northwind/vw/x?$format=json&$count=true");
            Assert.assertEquals((long)200L, (long)response.getStatus());
            String ends = "--1\"}";
            Assert.assertTrue((boolean)response.getContentAsString().endsWith(ends));
            response = http.GET(baseURL + "/northwind/vw/x/$count");
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)"2", (Object)response.getContentAsString());
        }
        finally {
            localClient = null;
            teiid.undeployVDB("northwind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompositeKeyUpdates() throws Exception {
        HardCodedExecutionFactory hc = this.buildHardCodedExecutionFactory();
        hc.addUpdate("DELETE FROM x WHERE x.a = 'a' AND x.b = 'b'", new int[]{1});
        hc.addUpdate("INSERT INTO x (a, b, c) VALUES ('a', 'b', 5)", new int[]{1});
        hc.addUpdate("UPDATE x SET c = 10 WHERE x.a = 'a' AND x.b = 'b'", new int[]{1});
        hc.addData("SELECT x.a, x.b, x.c FROM x WHERE x.a = 'a' AND x.b = 'b'", Arrays.asList(Arrays.asList("a", "b", 1)));
        teiid.addTranslator("x1", (ExecutionFactory)hc);
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("m");
            mmd.addSourceMetadata("ddl", "create foreign table x (a string, b string, c integer, primary key (a, b)) options (updatable true);");
            mmd.addSourceMapping("x1", "x1", null);
            teiid.deployVDB("northwind", new ModelMetaData[]{mmd});
            localClient = this.getClient(teiid.getDriver(), "northwind", 1, new Properties());
            ContentResponse response = http.newRequest(baseURL + "/northwind/m/x(a='a',b='b')").method("DELETE").send();
            Assert.assertEquals((long)204L, (long)response.getStatus());
            response = http.newRequest(baseURL + "/northwind/m/x('a')").method("DELETE").send();
            Assert.assertEquals((long)400L, (long)response.getStatus());
            response = http.newRequest(baseURL + "/northwind/m/x(a='a',a='b')").method("DELETE").send();
            Assert.assertEquals((long)400L, (long)response.getStatus());
            response = http.newRequest(baseURL + "/northwind/m/x").method("POST").content((ContentProvider)new StringContentProvider("{\"a\":\"a\", \"b\":\"b\", \"c\":5}"), "application/json").send();
            Assert.assertEquals((long)204L, (long)response.getStatus());
            response = http.newRequest(baseURL + "/northwind/m/x(a='a',b='b')").method("PATCH").content((ContentProvider)new StringContentProvider("{\"c\":10}"), "application/json").send();
            Assert.assertEquals((long)204L, (long)response.getStatus());
        }
        finally {
            localClient = null;
            teiid.undeployVDB("northwind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCrossJoin() throws Exception {
        HardCodedExecutionFactory hc = this.buildHardCodedExecutionFactory();
        hc.addUpdate("UPDATE y SET b = 'a' WHERE y.a = 'a'", new int[]{1});
        teiid.addTranslator("x9", (ExecutionFactory)hc);
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("m");
            mmd.addSourceMetadata("ddl", "create foreign table x ( a string,  b string,  primary key (a)) options (updatable true);create foreign table y ( a string,  b string,  primary key (a)) options (updatable true);");
            mmd.addSourceMapping("x9", "x9", null);
            teiid.deployVDB("northwind", new ModelMetaData[]{mmd});
            localClient = this.getClient(teiid.getDriver(), "northwind", 1, new Properties());
            ContentResponse response = http.newRequest(baseURL + "/northwind/m/$crossjoin(x,y)").method("GET").send();
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#Collection(Edm.ComplexType)\",\"value\":[{\"x@odata.navigationLink\":\"x('ABCDEFG')\",\"y@odata.navigationLink\":\"y('ABCDEFG')\"}]}", (Object)response.getContentAsString());
            response = http.newRequest(baseURL + "/northwind/m/$crossjoin(x,y)?$expand=x").method("GET").send();
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#Collection(Edm.ComplexType)\",\"value\":[{\"x\":{\"a\":\"ABCDEFG\",\"b\":\"ABCDEFG\"},\"y@odata.navigationLink\":\"y('ABCDEFG')\"}]}", (Object)response.getContentAsString());
        }
        finally {
            localClient = null;
            teiid.undeployVDB("northwind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNavigationLinks() throws Exception {
        HardCodedExecutionFactory hc = this.buildHardCodedExecutionFactory();
        hc.addUpdate("UPDATE y SET b = 'a' WHERE y.a = 'a'", new int[]{1});
        teiid.addTranslator("x4", (ExecutionFactory)hc);
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("m");
            mmd.addSourceMetadata("ddl", "create foreign table x ( a string,  b string,  primary key (a)) options (updatable true);create foreign table y ( a string,  b string,  primary key (a), CONSTRAINT FKX FOREIGN KEY (b) REFERENCES x(a)) options (updatable true);");
            mmd.addSourceMapping("x4", "x4", null);
            teiid.deployVDB("northwind", new ModelMetaData[]{mmd});
            localClient = this.getClient(teiid.getDriver(), "northwind", 1, new Properties());
            ContentResponse response = http.newRequest(baseURL + "/northwind/m/x('a')/y_FKX/$ref").method("GET").send();
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#Collection($ref)\",\"value\":[{\"@odata.id\":\"y('ABCDEFG')\"}]}", (Object)response.getContentAsString());
            String payload = "{\n\"@odata.id\": \"/odata4/northwind/m/y('a')\"\n}";
            response = http.newRequest(baseURL + "/northwind/m/x('a')/y_FKX/$ref").method("POST").content((ContentProvider)new StringContentProvider(payload), ContentType.APPLICATION_JSON.toString()).send();
            Assert.assertEquals((long)204L, (long)response.getStatus());
        }
        finally {
            localClient = null;
            teiid.undeployVDB("northwind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExpandSimple() throws Exception {
        HardCodedExecutionFactory hc = this.buildHardCodedExecutionFactory();
        hc.addData("SELECT x.a, x.b FROM x WHERE x.a = 'xa1'", Arrays.asList(Arrays.asList("xa1", "xb")));
        hc.addData("SELECT y.a, y.b FROM y WHERE y.b = 'xa1'", Arrays.asList(Arrays.asList("ya1", "xa1"), Arrays.asList("ya2", "xa1")));
        teiid.addTranslator("x7", (ExecutionFactory)hc);
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("m");
            mmd.addSourceMetadata("ddl", "create foreign table x ( a string,  b string,  primary key (a)) options (updatable true);create foreign table y ( a string,  b string,  primary key (a), CONSTRAINT FKX FOREIGN KEY (b) REFERENCES x(a)) options (updatable true);create foreign table z ( a string,  b string,  primary key (a), CONSTRAINT FKX FOREIGN KEY (a) REFERENCES x(a)) options (updatable true);");
            mmd.addSourceMapping("x7", "x7", null);
            teiid.deployVDB("northwind", new ModelMetaData[]{mmd});
            localClient = this.getClient(teiid.getDriver(), "northwind", 1, new Properties());
            ContentResponse response = null;
            response = http.newRequest(baseURL + "/northwind/m/x?$expand=y_FKX").method("GET").send();
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#x\",\"value\":[{\"a\":\"ABCDEFG\",\"b\":\"ABCDEFG\",\"y_FKX\":[{\"a\":\"ABCDEFG\",\"b\":\"ABCDEFG\"}]}]}", (Object)response.getContentAsString());
            response = http.newRequest(baseURL + "/northwind/m/z?$expand=FKX&$select=a").method("GET").send();
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#z(a)\",\"value\":[{\"a\":\"ABCDEFG\",\"FKX\":{\"a\":\"ABCDEFG\",\"b\":\"ABCDEFG\"}}]}", (Object)response.getContentAsString());
            response = http.newRequest(baseURL + "/northwind/m/z?$expand=FKX&$select=a").method("GET").send();
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#z(a)\",\"value\":[{\"a\":\"ABCDEFG\",\"FKX\":{\"a\":\"ABCDEFG\",\"b\":\"ABCDEFG\"}}]}", (Object)response.getContentAsString());
            response = http.newRequest(baseURL + "/northwind/m/x?$expand=" + Encoder.encode((String)"y_FKX($filter=b eq 'xa1')")).method("GET").send();
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#x\",\"value\":[{\"a\":\"xa1\",\"b\":\"xb\",\"y_FKX\":[{\"a\":\"ya1\",\"b\":\"xa1\"},{\"a\":\"ya2\",\"b\":\"xa1\"}]}]}", (Object)response.getContentAsString());
            response = http.newRequest(baseURL + "/northwind/m/z?$expand=FKX").method("GET").send();
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#z\",\"value\":[{\"a\":\"ABCDEFG\",\"b\":\"ABCDEFG\",\"FKX\":{\"a\":\"ABCDEFG\",\"b\":\"ABCDEFG\"}}]}", (Object)response.getContentAsString());
            response = http.newRequest(baseURL + "/northwind/m/z?$expand=FKX/a&$select=a").method("GET").send();
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#z(a,FKX/a)\",\"value\":[{\"a\":\"ABCDEFG\",\"FKX\":{\"a\":\"ABCDEFG\",\"b\":\"ABCDEFG\"}}]}", (Object)response.getContentAsString());
        }
        finally {
            localClient = null;
            teiid.undeployVDB("northwind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBatch() throws Exception {
        HardCodedExecutionFactory hc = this.buildHardCodedExecutionFactory();
        hc.addUpdate("DELETE FROM x WHERE x.a = 'a' AND x.b = 'b'", new int[]{1});
        teiid.addTranslator("x", (ExecutionFactory)hc);
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("m");
            mmd.addSourceMetadata("ddl", "create foreign table x (a string, b string, c integer, primary key (a, b)) options (updatable true);");
            mmd.addSourceMapping("x", "x", null);
            teiid.deployVDB("northwind", new ModelMetaData[]{mmd});
            localClient = this.getClient(teiid.getDriver(), "northwind", 1, new Properties());
            String batch = "--batch_8194-cf13-1f56\r\nContent-Type: application/http\r\nContent-Transfer-Encoding: binary\r\n\r\nGET " + baseURL + "/northwind/m/x HTTP/1.1" + CRLF + "Accept: application/json" + CRLF + "MaxDataServiceVersion: 4.0" + CRLF + CRLF + CRLF + "--batch_8194-cf13-1f56" + CRLF + "Content-Type: multipart/mixed; boundary=changeset_f980-1cb6-94dd" + CRLF + CRLF + "--changeset_f980-1cb6-94dd" + CRLF + "content-type:     Application/http" + CRLF + "content-transfer-encoding: Binary" + CRLF + "Content-ID: 1" + CRLF + CRLF + "DELETE " + baseURL + "/northwind/m/x(a='a',b='b') HTTP/1.1" + CRLF + "Content-type: application/json" + CRLF + CRLF + CRLF + "--changeset_f980-1cb6-94dd--" + CRLF + "--batch_8194-cf13-1f56--";
            ContentResponse response = http.newRequest(baseURL + "/northwind/m/$batch").method("POST").content((ContentProvider)new StringContentProvider(batch), "multipart/mixed;boundary=batch_8194-cf13-1f56").send();
            Assert.assertEquals((long)202L, (long)response.getStatus());
        }
        finally {
            localClient = null;
            teiid.undeployVDB("northwind");
        }
    }

    private HardCodedExecutionFactory buildHardCodedExecutionFactory() {
        HardCodedExecutionFactory hc = new HardCodedExecutionFactory(){

            public boolean supportsCompareCriteriaEquals() {
                return true;
            }

            protected List<? extends List<?>> getData(QueryExpression command) {
                if (super.getData(command) != null) {
                    return super.getData(command);
                }
                Class[] colTypes = command.getProjectedQuery().getColumnTypes();
                ArrayList<ElementSymbol> cols = new ArrayList<ElementSymbol>();
                for (int i = 0; i < colTypes.length; ++i) {
                    ElementSymbol elementSymbol = new ElementSymbol("X");
                    elementSymbol.setType(colTypes[i]);
                    cols.add(elementSymbol);
                }
                return Arrays.asList(AutoGenDataService.createResults(cols, (int)1, (boolean)false));
            }
        };
        return hc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJsonProcedureResultSet() throws Exception {
        try {
            HardCodedExecutionFactory hc = new HardCodedExecutionFactory();
            hc.addData("EXEC x()", Arrays.asList(Arrays.asList("x"), Arrays.asList("y")));
            teiid.addTranslator("x2", (ExecutionFactory)hc);
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("m");
            mmd.addSourceMetadata("ddl", "create foreign procedure x () returns table(y string) OPTIONS(UPDATECOUNT 0);");
            mmd.addSourceMapping("x2", "x2", null);
            teiid.deployVDB("northwind", new ModelMetaData[]{mmd});
            localClient = this.getClient(teiid.getDriver(), "northwind", 1, new Properties());
            ContentResponse response = http.GET(baseURL + "/northwind/m/x()?$format=json");
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#Collection(northwind.1.m.x_RSParam)\",\"value\":[{\"y\":\"x\"},{\"y\":\"y\"}]}", (Object)response.getContentAsString());
        }
        finally {
            localClient = null;
            teiid.undeployVDB("northwind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicTypes() throws Exception {
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("m");
            mmd.addSourceMapping("x3", "x3", null);
            MetadataStore ms = RealMetadataFactory.exampleBQTStore();
            Schema s = ms.getSchema("BQT1");
            KeyRecord pk = new KeyRecord(KeyRecord.Type.Primary);
            Table smalla = s.getTable("SmallA");
            pk.setName("pk");
            pk.addColumn(smalla.getColumnByName("IntKey"));
            smalla.setPrimaryKey(pk);
            String ddl = DDLStringVisitor.getDDLString((Schema)s, EnumSet.allOf(Admin.SchemaObjectType.class), (String)"SmallA");
            mmd.addSourceMetadata("DDL", ddl);
            HardCodedExecutionFactory hc = this.buildHardCodedExecutionFactory();
            teiid.addTranslator("x3", (ExecutionFactory)hc);
            teiid.deployVDB("northwind", new ModelMetaData[]{mmd});
            localClient = this.getClient(teiid.getDriver(), "northwind", 1, new Properties());
            ContentResponse response = http.GET(baseURL + "/northwind/m/SmallA?$format=json&$select=TimeValue");
            Assert.assertEquals((long)200L, (long)response.getStatus());
        }
        finally {
            localClient = null;
            teiid.undeployVDB("northwind");
        }
    }

    static {
        server = new Server();
        http = new HttpClient();
    }
}

