/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.service;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmElement;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.core.edm.EdmPropertyImpl;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.TransformationException;
import org.teiid.odata.api.OperationResponse;
import org.teiid.olingo.ODataPlugin;
import org.teiid.olingo.service.EntityCollectionResponse;

public class OperationResponseImpl
implements OperationResponse {
    private final String invalidCharacterReplacement;
    private EdmType type;
    private List<ComplexValue> complexValues = new ArrayList<ComplexValue>();
    private Object primitiveValue;

    public OperationResponseImpl(String invalidCharacterReplacement, EdmType type) {
        this.invalidCharacterReplacement = invalidCharacterReplacement;
        this.type = type;
    }

    @Override
    public void addRow(ResultSet rs) throws SQLException {
        Object value;
        if (rs.getMetaData().getColumnCount() == 1 && DataTypeManager.isLOB((value = rs.getObject(1)).getClass())) {
            this.addPrimitive(value);
            return;
        }
        this.complexValues.add(this.getComplexProperty(rs));
    }

    private ComplexValue getComplexProperty(ResultSet rs) throws SQLException {
        HashMap<Integer, Property> properties = new HashMap<Integer, Property>();
        for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
            Object value = rs.getObject(i + 1);
            String propName = rs.getMetaData().getColumnLabel(i + 1);
            EdmElement element = ((EdmComplexType)this.type).getProperty(propName);
            if (!(element instanceof EdmProperty) && !((EdmProperty)element).isPrimitive()) {
                throw new SQLException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16024, new Object[0]));
            }
            EdmPropertyImpl edmProperty = (EdmPropertyImpl)element;
            try {
                Property property = EntityCollectionResponse.buildPropery(propName, (SingletonPrimitiveType)edmProperty.getType(), edmProperty.isCollection(), value, this.invalidCharacterReplacement);
                properties.put(i, property);
                continue;
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
            catch (TransformationException e) {
                throw new SQLException(e);
            }
        }
        return OperationResponseImpl.createComplex("result", properties.values());
    }

    static ComplexValue createComplex(String name, Collection<Property> properties) {
        ComplexValue complexValue = new ComplexValue();
        for (Property property : properties) {
            complexValue.getValue().add(property);
        }
        return complexValue;
    }

    static Property createComplexCollection(String name, String type, List<ComplexValue> complexList) {
        return new Property(type, name, ValueType.COLLECTION_COMPLEX, complexList);
    }

    static Property createPrimitive(String name, String type, Object value) {
        return new Property(type, name, ValueType.PRIMITIVE, value);
    }

    @Override
    public long size() {
        return this.complexValues.size();
    }

    @Override
    public void setCount(long count) {
    }

    @Override
    public void setNextToken(String token) {
    }

    @Override
    public String getNextToken() {
        return null;
    }

    @Override
    public Object getResult() {
        String type = this.type.getFullQualifiedName().getFullQualifiedNameAsString();
        if (this.isReturnTypePrimitive()) {
            return OperationResponseImpl.createPrimitive("return", type, this.primitiveValue);
        }
        return OperationResponseImpl.createComplexCollection("result", type, this.complexValues);
    }

    private boolean isReturnTypePrimitive() {
        return this.type.getKind() == EdmTypeKind.PRIMITIVE;
    }

    @Override
    public void addPrimitive(Object value) {
        this.primitiveValue = value;
    }
}

