/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.web;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import org.teiid.olingo.web.HttpServletRequestDelegate;

public class ProxyHttpServletRequest
extends HttpServletRequestDelegate {
    private URI encodedURI;
    private URL encodedURL;

    public ProxyHttpServletRequest(HttpServletRequest delegate, String proxyBaseURI) {
        super(delegate);
        URL url = null;
        try {
            url = new URL(delegate.getRequestURL().toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        String buf = url.toExternalForm();
        try {
            buf = ProxyHttpServletRequest.extractURI(url, proxyBaseURI);
            this.encodedURI = URI.create(buf);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create URI: " + buf, e);
        }
        try {
            this.encodedURL = new URL(this.encodedURI.toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static String extractURI(URL url, String baseURI) throws UnsupportedEncodingException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(baseURI);
        if (url.getPath() != null) {
            buffer.append(URLEncoder.encode(url.getPath(), "UTF-8"));
        }
        if (url.getQuery() != null) {
            buffer.append("?").append(url.getQuery());
        }
        if (url.getRef() != null) {
            buffer.append("#").append(URLEncoder.encode(url.getRef(), "UTF-8"));
        }
        String buf = buffer.toString();
        return buf;
    }

    @Override
    public String getRequestURI() {
        return this.encodedURI.getRawPath();
    }

    @Override
    public StringBuffer getRequestURL() {
        return new StringBuffer(this.encodedURL.toString());
    }
}

