/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataHttpHandler;
import org.apache.olingo.server.api.edm.provider.EdmProvider;
import org.apache.olingo.server.api.edm.provider.Schema;
import org.apache.olingo.server.api.processor.Processor;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.teiid.metadata.MetadataStore;
import org.teiid.olingo.Client;
import org.teiid.olingo.CountResponse;
import org.teiid.olingo.EntityList;
import org.teiid.olingo.OData4EntitySchemaBuilder;
import org.teiid.olingo.QueryResponse;
import org.teiid.olingo.SQLParam;
import org.teiid.olingo.TeiidEdmProvider;
import org.teiid.olingo.TeiidProcessor;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestODataSQLBuilder {
    public TestState helpTest(String url, String sqlExpected) throws Exception {
        ArgumentCaptor arg1 = ArgumentCaptor.forClass(Query.class);
        ArgumentCaptor arg6 = ArgumentCaptor.forClass(EntityList.class);
        Client client = (Client)Mockito.mock(Client.class);
        ArrayList<SQLParam> parameters = new ArrayList<SQLParam>();
        String ddl = "CREATE FOREIGN TABLE G1 (\n\te1 string, \n\te2 integer PRIMARY KEY, \n\te3 double\n);\n\nCREATE FOREIGN TABLE G2 (\n\te1 string, \n\te2 integer PRIMARY KEY, \n\tCONSTRAINT FK0 FOREIGN KEY (e2) REFERENCES G1 (e2)\n) OPTIONS (UPDATABLE 'true');\nCREATE FOREIGN TABLE G3 (\n\te1 string, \n\te2 integer,\n\tCONSTRAINT PK PRIMARY KEY (e1,e2)\n) OPTIONS (UPDATABLE 'true')CREATE FOREIGN TABLE G4 (\n\te1 string PRIMARY KEY, \n\te2 integer,\n\tCONSTRAINT FKX FOREIGN KEY (e2) REFERENCES G1(e2)\n) OPTIONS (UPDATABLE 'true');";
        RealMetadataFactory.DDLHolder model = new RealMetadataFactory.DDLHolder("PM1", ddl);
        TransformationMetadata metadata = RealMetadataFactory.fromDDL((String)"vdb", (RealMetadataFactory.DDLHolder[])new RealMetadataFactory.DDLHolder[]{model});
        CompositeMetadataStore store = metadata.getMetadataStore();
        OData odata = OData.newInstance();
        org.teiid.metadata.Schema teiidSchema = store.getSchema("PM1");
        Schema schema = OData4EntitySchemaBuilder.buildMetadata((org.teiid.metadata.Schema)teiidSchema);
        Edm edm = odata.createEdm((EdmProvider)new TeiidEdmProvider((MetadataStore)store, schema));
        Hashtable headers = new Hashtable();
        Mockito.stub((Object)client.getMetadataStore()).toReturn((Object)store);
        Mockito.stub((Object)client.executeCount((Query)Mockito.any(Query.class), Mockito.anyListOf(SQLParam.class))).toReturn((Object)new CountResponse(){

            public long getCount() {
                return 10L;
            }
        });
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.stub((Object)request.getHeaderNames()).toReturn(headers.elements());
        Mockito.stub((Object)request.getMethod()).toReturn((Object)"GET");
        String requestURL = url;
        String queryString = "";
        int idx = url.indexOf("?");
        if (idx != -1) {
            requestURL = url.substring(0, idx);
            queryString = url.substring(idx + 1);
        }
        Mockito.stub((Object)request.getRequestURL()).toReturn((Object)new StringBuffer(requestURL));
        Mockito.stub((Object)request.getQueryString()).toReturn((Object)queryString);
        Mockito.stub((Object)request.getServletPath()).toReturn((Object)"");
        Mockito.stub((Object)request.getContextPath()).toReturn((Object)"/odata4/vdb/PM1");
        final StringBuffer sb = new StringBuffer();
        ServletOutputStream out = new ServletOutputStream(){

            public void write(int b) throws IOException {
                sb.append((char)b);
            }
        };
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.stub((Object)response.getOutputStream()).toReturn((Object)out);
        ODataHttpHandler handler = odata.createHandler(edm);
        handler.register((Processor)new TeiidProcessor(client, false));
        handler.process(request, response);
        if (sqlExpected != null) {
            Query actualCommand = (Query)QueryParser.getQueryParser().parseCommand(sqlExpected, new ParseInfo());
            ((Client)Mockito.verify((Object)client)).executeSQL((Query)arg1.capture(), (List)Mockito.eq(parameters), Mockito.eq((boolean)false), (Integer)Mockito.eq(null), (Integer)Mockito.eq(null), (QueryResponse)arg6.capture());
            Assert.assertEquals((Object)actualCommand.toString(), (Object)((Query)arg1.getValue()).toString());
        }
        TestState state = new TestState();
        state.client = client;
        state.parameters = parameters;
        state.arg1 = arg1;
        state.arg6 = arg6;
        state.response = sb.toString();
        return state;
    }

    @Test
    public void testSimpleEntitySet() throws Exception {
        this.helpTest("/odata4/vdb/PM1/G1", "SELECT g0.e1, g0.e2, g0.e3 FROM PM1.G1 AS g0 ORDER BY g0.e2");
    }

    @Test
    public void testSimpleEntitySetWithKey() throws Exception {
        this.helpTest("/odata4/vdb/PM1/G1(1)", "SELECT g0.e1, g0.e2, g0.e3 FROM PM1.G1 AS g0 WHERE g0.e2 = 1 ORDER BY g0.e2");
    }

    @Ignore
    @Test
    public void testSimpleEntityID() throws Exception {
        this.helpTest("/odata4/vdb/PM1/$entity?$id=G1(1)", "SELECT g0.e1, g0.e2, g0.e3 FROM PM1.G1 AS g0 WHERE g0.e2 = 1 ORDER BY g0.e2");
    }

    @Test
    public void testEntitySet$Select() throws Exception {
        this.helpTest("/odata4/vdb/PM1/G1?$select=e1", "SELECT g0.e2, g0.e1 FROM PM1.G1 AS g0 ORDER BY g0.e2");
    }

    @Test
    public void testEntitySet$SelectBad() throws Exception {
        TestState state = this.helpTest("/odata4/vdb/PM1/G1?$select=e1,x", null);
        Assert.assertEquals((Object)"{\"error\":{\"code\":null,\"message\":\"The type 'G1' has no property 'x'.\"}}", (Object)state.response);
    }

    @Test
    public void testEntitySet$OrderBy() throws Exception {
        this.helpTest("/odata4/vdb/PM1/G1?$orderby=e1 desc, e2", "SELECT g0.e1, g0.e2, g0.e3 FROM PM1.G1 AS g0 ORDER BY g0.e1 DESC, g0.e2");
        this.helpTest("/odata4/vdb/PM1/G1?$orderby=e1", "SELECT g0.e1, g0.e2, g0.e3 FROM PM1.G1 AS g0 ORDER BY g0.e1");
    }

    @Test
    public void testEntitySet$OrderByNotIn$Select() throws Exception {
        this.helpTest("/odata4/vdb/PM1/G1?$orderby=e2&$select=e1", "SELECT g0.e2, g0.e1 FROM PM1.G1 AS g0 ORDER BY g0.e2");
    }

    @Test
    public void testEntitySet$filter() throws Exception {
        this.helpTest("/odata4/vdb/PM1/G1?$filter=e1 eq 1", "SELECT g0.e1, g0.e2, g0.e3 FROM PM1.G1 AS g0 WHERE g0.e1 = 1 ORDER BY g0.e2");
    }

    @Test
    public void test$CountIsTrueEntitySet() throws Exception {
        String expected = "SELECT g0.e1, g0.e2, g0.e3 FROM PM1.G1 AS g0 ORDER BY g0.e2";
        TestState state = this.helpTest("/odata4/vdb/PM1/G1?$count=true", null);
        ((Client)Mockito.verify((Object)state.client)).executeSQL((Query)state.arg1.capture(), (List)Mockito.eq(state.parameters), Mockito.eq((boolean)true), (Integer)Mockito.eq(null), (Integer)Mockito.eq(null), (QueryResponse)state.arg6.capture());
        Assert.assertEquals((Object)expected, (Object)((Query)state.arg1.getValue()).toString());
    }

    @Test
    public void test$CountInEntitySet() throws Exception {
        String expected = "SELECT COUNT(*) FROM PM1.G1 AS g0";
        TestState state = this.helpTest("/odata4/vdb/PM1/G1/$count", null);
        ((Client)Mockito.verify((Object)state.client)).executeCount((Query)state.arg1.capture(), (List)Mockito.eq(state.parameters));
        Assert.assertEquals((Object)expected, (Object)((Query)state.arg1.getValue()).toString());
    }

    @Test
    public void test$CountInNavigation() throws Exception {
        String expected = "SELECT COUNT(*) FROM PM1.G4 AS g0 INNER JOIN PM1.G1 AS g1 ON g0.e2 = g1.e2 WHERE g0.e1 = '1'";
        TestState state = this.helpTest("/odata4/vdb/PM1/G4('1')/FKX/$count", null);
        ((Client)Mockito.verify((Object)state.client)).executeCount((Query)state.arg1.capture(), (List)Mockito.eq(state.parameters));
        Assert.assertEquals((Object)expected, (Object)((Query)state.arg1.getValue()).toString());
    }

    @Test
    public void test$CountIn$Filter() throws Exception {
        String expected = "SELECT g0.e1 FROM PM1.G4 AS g0 WHERE (SELECT COUNT(*) FROM PM1.G1 AS g1 WHERE g0.e2 = g1.e2) = 2 ORDER BY g0.e1";
        this.helpTest("/odata4/vdb/PM1/G4?$filter=FKX/$count eq 2&$select=e1", expected);
    }

    @Ignore
    @Test
    public void test$CountIn$OrderBy() throws Exception {
        this.helpTest("/odata4/vdb/PM1/G4?$orderby=FKX/$count", "SELECT g0.e1, g0.e2 FROM PM1.G4 AS g0 ORDER BY (SELECT COUNT(*) FROM PM1.G1 AS g1 WHERE g0.e2 = g1.e2)");
    }

    @Test
    public void testCanonicalQuery() throws Exception {
        this.helpTest("/odata4/vdb/PM1/G4('1')/FKX(1)", "SELECT g1.e1, g1.e2, g1.e3 FROM PM1.G1 AS g1 WHERE g1.e2 = 1 ORDER BY g1.e2");
    }

    @Test
    public void testAlias() throws Exception {
        this.helpTest("/odata4/vdb/PM1/G1?$filter=e1 eq @p1&@p1=1", "SELECT g0.e1, g0.e2, g0.e3 FROM PM1.G1 AS g0 WHERE g0.e1 = 1 ORDER BY g0.e2");
    }

    @Test
    public void testMultiEntitykey() throws Exception {
        this.helpTest("/odata4/vdb/PM1/G3(e1='1',e2=2)", "SELECT g0.e1, g0.e2 FROM PM1.G3 AS g0 WHERE g0.e1 = '1' AND g0.e2 = 2 ORDER BY g0.e1, g0.e2");
    }

    private void te(String in, String expected) throws Exception {
        this.helpTest("/odata4/vdb/PM1/G1?$filter=" + in, "SELECT g0.e1, g0.e2, g0.e3 FROM PM1.G1 AS g0 WHERE " + expected + " ORDER BY g0.e2");
    }

    @Test
    public void testAnd() throws Exception {
        this.te("e1 eq 1 and e1 eq 2", "(g0.e1 = 1) AND (g0.e1 = 2)");
        this.te("(e1 add 4) eq 3", "(g0.e1 + 4) = 3");
        this.te("((e1 add e2) sub e3) mod e1 eq 0", "MOD(((g0.e1 + g0.e2) - g0.e3), g0.e1) = 0");
    }

    @Test
    public void testEq() throws Exception {
        this.te("e1 eq 1", "g0.e1 = 1");
        this.te("e1 eq 4.5", "g0.e1 = 4.5");
        this.te("e1 eq -4.5", "g0.e1 = -4.5");
        this.te("e1 eq null", "g0.e1 IS NULL");
        this.te("e1 eq 'foo'", "g0.e1 = 'foo'");
        this.te("e1 eq true", "g0.e1 = TRUE");
        this.te("e1 eq false", "g0.e1 = FALSE");
        this.te("e1 eq 13:20:00", "g0.e1 = {t'13:20:00'}");
        this.te("e1 eq 2008-10-13T00:00:00Z", "g0.e1 = {ts'2008-10-13 00:00:00.0'}");
    }

    @Test
    public void testCast() throws Exception {
        this.te("e1 eq cast('foo', Edm.String)", "g0.e1 = CONVERT('foo', string)");
        this.te("e1 eq cast('foo', Edm.Int32)", "g0.e1 = CONVERT('foo', integer)");
    }

    @Test
    public void testConcat() throws Exception {
        this.te("e1 eq concat('foo', 'bar')", "g0.e1 = CONCAT2('foo', 'bar')");
    }

    @Test
    public void testEndsWith() throws Exception {
        this.te("endswith(e1, 'foo')", "ENDSWITH(g0.e1, 'foo') = TRUE");
    }

    @Test
    public void testIndexOf() throws Exception {
        this.te("indexof(e1, 'foo') eq 1", "LOCATE('foo', g0.e1) = 1");
    }

    @Test
    public void testLength() throws Exception {
        this.te("length(e1) eq 2", "LENGTH(g0.e1) = 2");
    }

    @Test
    public void testOperator() throws Exception {
        this.te("not (e1)", "NOT (g0.e1)");
        this.te("(e1 mul e2) gt 5", "(g0.e1 * g0.e2) > 5");
        this.te("(e1 div 5) gt 5", "(g0.e1 / 5) > 5");
        this.te("(e1 add 5) lt 5", "(g0.e1 + 5) < 5");
        this.te("(e1 sub 5) ne 0", "(g0.e1 - 5) != 0");
        this.te("(e1 mod 5) eq 0", "MOD(g0.e1, 5) = 0");
        this.te("(e1 mul -1) eq 0", "(g0.e1 * -1) = 0");
    }

    @Test
    public void testComparisions() throws Exception {
        this.te("e1 gt e2", "g0.e1 > g0.e2");
        this.te("e1 lt e2", "g0.e1 < g0.e2");
        this.te("e1 ge e2", "g0.e1 >= g0.e2");
        this.te("e1 le e2", "g0.e1 <= g0.e2");
        this.te("e1 eq e2", "g0.e1 = g0.e2");
        this.te("e1 ne e2", "g0.e1 <> g0.e2");
        this.te("e1 eq null", "g0.e1 IS NULL");
        this.te("e1 ne null", "g0.e1 IS NOT NULL");
    }

    @Test
    public void testStringMethods() throws Exception {
        this.te("substring('foo', 1) eq 'f'", "SUBSTRING('foo', 1) = 'f'");
        this.te("substring('foo', 1, 2) eq 'f'", "SUBSTRING('foo', 1, 2) = 'f'");
        this.te("tolower(e1) eq 'foo'", "LCASE(g0.e1) = 'foo'");
        this.te("toupper(e1) eq 'FOO'", "UCASE(g0.e1) = 'FOO'");
        this.te("trim('x') eq e1", "TRIM(' ' FROM 'x') = g0.e1");
        this.te("trim(e1) ne 'foo' and toupper(e1) eq 'bar'", "(TRIM(' ' FROM g0.e1) <> 'foo') AND (UCASE(g0.e1) = 'bar')");
        this.te("contains(e1, 'foo')", "LOCATE('foo', g0.e1, 1) >= 1");
    }

    @Test
    public void testStartsWith() throws Exception {
        this.te("startswith(e1, 'foo')", "LOCATE(g0.e1, 'foo', 1) = 1");
    }

    @Test
    public void testTimeMethods() throws Exception {
        this.te("year(e1) eq 2000", "YEAR(g0.e1) = 2000");
        this.te("year(2008-10-13T00:00:00Z) eq 2008", "YEAR({ts'2008-10-13 00:00:00.0'}) = 2008");
        this.te("month(e1) gt 1", "MONTH(g0.e1) > 1");
        this.te("day(e1) ne 1", "DAYOFMONTH(g0.e1) != 1");
        this.te("hour(e1) eq 12", "HOUR(g0.e1) = 12");
        this.te("minute(e1) lt 5", "MINUTE(g0.e1) < 5");
        this.te("second(e1) eq 3", "SECOND(g0.e1) = 3");
    }

    @Test
    public void testRoundMethods() throws Exception {
        this.te("round(e1) eq 0", "ROUND(g0.e1, 0) = 0");
        this.te("floor(e1) eq 0", "FLOOR(g0.e1) = 0");
        this.te("ceiling(e1) eq 1", "CEILING(g0.e1) = 1");
    }

    @Test
    public void testNavigationQuery() throws Exception {
        this.helpTest("/odata4/vdb/PM1/G2(1)/FK0", "SELECT g1.e1, g1.e2, g1.e3 FROM PM1.G2 as g0 INNER JOIN PM1.G1 as g1 ON g0.e2 = g1.e2 WHERE g0.e2 = 1 ORDER BY g1.e2");
    }

    @Test
    public void testNavigationQuery$Select() throws Exception {
        this.helpTest("/odata4/vdb/PM1/G2(1)/FK0?$select=e1", "SELECT g1.e2, g1.e1 FROM PM1.G2 as g0 INNER JOIN PM1.G1 as g1 ON g0.e2 = g1.e2 WHERE g0.e2 = 1 ORDER BY g1.e2");
    }

    @Ignore
    @Test
    public void test$refCollection() throws Exception {
        this.helpTest("/odata4/vdb/PM1/G2/$ref", "SELECT g1.e1 FROM PM1.G2 as g0 INNER JOIN PM1.G1 as g1 ON g0.e2 = g1.e2 WHERE g0.e2 = 1 ORDER BY g1.e2");
    }

    @Ignore
    @Test
    public void test$refEntity() throws Exception {
        this.helpTest("/odata4/vdb/PM1/G2(1)/$ref", "SELECT g1.e1 FROM PM1.G2 as g0 INNER JOIN PM1.G1 as g1 ON g0.e2 = g1.e2 WHERE g0.e2 = 1 ORDER BY g1.e2");
    }

    @Test
    public void testAddressingProperty() throws Exception {
        this.helpTest("/odata4/vdb/PM1/G2(1)/e1", "SELECT g0.e1, g0.e2 FROM PM1.G2 AS g0 WHERE g0.e2 = 1 ORDER BY g0.e2");
    }

    @Test
    public void testAddressingPropertyValue() throws Exception {
        this.helpTest("/odata4/vdb/PM1/G1(1)/e1/$value", "SELECT g0.e1, g0.e2 FROM PM1.G1 AS g0 WHERE g0.e2 = 1 ORDER BY g0.e2");
    }

    @Test
    public void test$filter() throws Exception {
        this.helpTest("/odata4/vdb/PM1/G2?$filter=e1 eq 1", "SELECT g0.e1, g0.e2 FROM PM1.G2 AS g0 WHERE g0.e1 = 1 ORDER BY g0.e2");
        this.helpTest("/odata4/vdb/PM1/G2?$filter=contains(e1, 'foo')", "SELECT g0.e1, g0.e2 FROM PM1.G2 AS g0 WHERE LOCATE('foo', g0.e1, 1) >= 1 ORDER BY g0.e2");
        this.helpTest("/odata4/vdb/PM1/G2?$filter=(4 add 5) mod (4 sub 1) eq 0", "SELECT g0.e1, g0.e2 FROM PM1.G2 AS g0 WHERE MOD((4 + 5), (4 - 1)) = 0 ORDER BY g0.e2");
    }

    static class TestState {
        Client client;
        List<SQLParam> parameters;
        ArgumentCaptor<Query> arg1;
        ArgumentCaptor<EntityList> arg6;
        String response;

        TestState() {
        }
    }
}

