/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.ODataRuntimeException;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriInfoAll;
import org.apache.olingo.server.api.uri.UriInfoBatch;
import org.apache.olingo.server.api.uri.UriInfoCrossjoin;
import org.apache.olingo.server.api.uri.UriInfoEntityId;
import org.apache.olingo.server.api.uri.UriInfoKind;
import org.apache.olingo.server.api.uri.UriInfoMetadata;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriInfoService;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.queryoption.CountOption;
import org.apache.olingo.server.api.uri.queryoption.CustomQueryOption;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.FilterOption;
import org.apache.olingo.server.api.uri.queryoption.FormatOption;
import org.apache.olingo.server.api.uri.queryoption.IdOption;
import org.apache.olingo.server.api.uri.queryoption.OrderByOption;
import org.apache.olingo.server.api.uri.queryoption.SearchOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.api.uri.queryoption.SkipOption;
import org.apache.olingo.server.api.uri.queryoption.SkipTokenOption;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOption;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOptionKind;
import org.apache.olingo.server.api.uri.queryoption.TopOption;
import org.apache.olingo.server.core.uri.UriResourceImpl;
import org.apache.olingo.server.core.uri.queryoption.CustomQueryOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.QueryOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.SystemQueryOptionImpl;

public class UriInfoImpl
implements UriInfo {
    private UriInfoKind kind;
    private List<String> entitySetNames = new ArrayList<String>();
    private EdmEntityType entityTypeCast;
    private List<CustomQueryOptionImpl> customQueryOptions = new ArrayList<CustomQueryOptionImpl>();
    private Map<String, String> aliasToValue = new HashMap<String, String>();
    Map<SystemQueryOptionKind, SystemQueryOption> systemQueryOptions = new HashMap<SystemQueryOptionKind, SystemQueryOption>();
    private String fragment;
    private UriResource lastResourcePart;
    private List<UriResource> pathParts = new ArrayList<UriResource>();

    public UriInfoAll asUriInfoAll() {
        return this;
    }

    public UriInfoBatch asUriInfoBatch() {
        return this;
    }

    public UriInfoCrossjoin asUriInfoCrossjoin() {
        return this;
    }

    public UriInfoEntityId asUriInfoEntityId() {
        return this;
    }

    public UriInfoMetadata asUriInfoMetadata() {
        return this;
    }

    public UriInfoResource asUriInfoResource() {
        return this;
    }

    public List<String> getEntitySetNames() {
        return Collections.unmodifiableList(this.entitySetNames);
    }

    public void addEntitySetName(String entitySet) {
        this.entitySetNames.add(entitySet);
    }

    public List<UriResource> getUriResourceParts() {
        ArrayList<UriResource> returnList = new ArrayList<UriResource>();
        for (UriResource item : this.pathParts) {
            returnList.add(item);
        }
        return Collections.unmodifiableList(returnList);
    }

    public UriInfoImpl addResourcePart(UriResourceImpl uriPathInfo) {
        this.pathParts.add(uriPathInfo);
        this.lastResourcePart = uriPathInfo;
        return this;
    }

    public List<CustomQueryOption> getCustomQueryOptions() {
        ArrayList<CustomQueryOption> retList = new ArrayList<CustomQueryOption>();
        for (CustomQueryOptionImpl item : this.customQueryOptions) {
            retList.add(item);
        }
        return retList;
    }

    public String getValueForAlias(String alias) {
        return this.aliasToValue.get(alias);
    }

    public EdmEntityType getEntityTypeCast() {
        return this.entityTypeCast;
    }

    public UriInfoImpl setEntityTypeCast(EdmEntityType type) {
        this.entityTypeCast = type;
        return this;
    }

    public ExpandOption getExpandOption() {
        return (ExpandOption)this.systemQueryOptions.get(SystemQueryOptionKind.EXPAND);
    }

    public FilterOption getFilterOption() {
        return (FilterOption)this.systemQueryOptions.get(SystemQueryOptionKind.FILTER);
    }

    public FormatOption getFormatOption() {
        return (FormatOption)this.systemQueryOptions.get(SystemQueryOptionKind.FORMAT);
    }

    public IdOption getIdOption() {
        return (IdOption)this.systemQueryOptions.get(SystemQueryOptionKind.ID);
    }

    public CountOption getCountOption() {
        return (CountOption)this.systemQueryOptions.get(SystemQueryOptionKind.COUNT);
    }

    public UriInfoKind getKind() {
        return this.kind;
    }

    public UriInfoImpl setKind(UriInfoKind kind) {
        this.kind = kind;
        return this;
    }

    public UriResource getLastResourcePart() {
        return this.lastResourcePart;
    }

    public OrderByOption getOrderByOption() {
        return (OrderByOption)this.systemQueryOptions.get(SystemQueryOptionKind.ORDERBY);
    }

    public SearchOption getSearchOption() {
        return (SearchOption)this.systemQueryOptions.get(SystemQueryOptionKind.SEARCH);
    }

    public SelectOption getSelectOption() {
        return (SelectOption)this.systemQueryOptions.get(SystemQueryOptionKind.SELECT);
    }

    public SkipOption getSkipOption() {
        return (SkipOption)this.systemQueryOptions.get(SystemQueryOptionKind.SKIP);
    }

    public SkipTokenOption getSkipTokenOption() {
        return (SkipTokenOption)this.systemQueryOptions.get(SystemQueryOptionKind.SKIPTOKEN);
    }

    public TopOption getTopOption() {
        return (TopOption)this.systemQueryOptions.get(SystemQueryOptionKind.TOP);
    }

    public UriInfoImpl setQueryOptions(List<QueryOptionImpl> list) {
        for (QueryOptionImpl item : list) {
            if (item instanceof SystemQueryOptionImpl) {
                this.setSystemQueryOption((SystemQueryOptionImpl)item);
                continue;
            }
            if (!(item instanceof CustomQueryOptionImpl)) continue;
            this.addCustomQueryOption(item);
        }
        return this;
    }

    public void addCustomQueryOption(QueryOptionImpl item) {
        this.customQueryOptions.add((CustomQueryOptionImpl)item);
        if (item.getName().startsWith("@")) {
            this.aliasToValue.put(item.getName(), item.getText());
        }
    }

    public UriInfoImpl setSystemQueryOption(SystemQueryOption systemOption) {
        SystemQueryOptionKind kind = systemOption.getKind();
        switch (kind) {
            case EXPAND: 
            case FILTER: 
            case FORMAT: 
            case ID: 
            case COUNT: 
            case ORDERBY: 
            case SEARCH: 
            case SELECT: 
            case SKIP: 
            case SKIPTOKEN: 
            case TOP: 
            case LEVELS: {
                if (this.systemQueryOptions.containsKey(kind)) {
                    throw new ODataRuntimeException("Double System Query Option: " + systemOption.getName());
                }
                this.systemQueryOptions.put(kind, systemOption);
                break;
            }
            default: {
                throw new ODataRuntimeException("Unsupported System Query Option: " + systemOption.getName());
            }
        }
        return this;
    }

    public UriInfoService asUriInfoService() {
        return this;
    }

    public String getFragment() {
        return this.fragment;
    }

    public UriInfoImpl setFragment(String fragment) {
        this.fragment = fragment;
        return this;
    }

    public void removeResourcePart(int index) {
        this.pathParts.remove(index);
    }

    public Collection<SystemQueryOption> getSystemQueryOptions() {
        return Collections.unmodifiableCollection(this.systemQueryOptions.values());
    }
}

