/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.domain;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.olingo.commons.api.domain.AbstractODataValue;
import org.apache.olingo.commons.api.domain.CommonODataProperty;
import org.apache.olingo.commons.api.domain.ODataComplexValue;

public abstract class AbstractODataComplexValue<OP extends CommonODataProperty>
extends AbstractODataValue
implements ODataComplexValue<OP> {
    protected final Map<String, OP> fields = new LinkedHashMap<String, OP>();

    public AbstractODataComplexValue(String typeName) {
        super(typeName);
    }

    protected abstract ODataComplexValue<OP> getThis();

    public ODataComplexValue<OP> add(CommonODataProperty field) {
        this.fields.put(field.getName(), field);
        return this.getThis();
    }

    public OP get(String name) {
        return (OP)((CommonODataProperty)this.fields.get(name));
    }

    public Iterator<OP> iterator() {
        return this.fields.values().iterator();
    }

    public int size() {
        return this.fields.size();
    }

    public Map<String, Object> asJavaMap() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, OP> entry : this.fields.entrySet()) {
            Object value = null;
            if (((CommonODataProperty)entry.getValue()).hasPrimitiveValue()) {
                value = ((CommonODataProperty)entry.getValue()).getPrimitiveValue().toValue();
            } else if (((CommonODataProperty)entry.getValue()).hasComplexValue()) {
                value = ((CommonODataProperty)entry.getValue()).getValue().asComplex().asJavaMap();
            } else if (((CommonODataProperty)entry.getValue()).hasCollectionValue()) {
                value = ((CommonODataProperty)entry.getValue()).getValue().asCollection().asJavaCollection();
            }
            result.put(entry.getKey(), value);
        }
        return result;
    }
}

