/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAnnotationsTarget;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmMember;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.core.edm.EdmTypeImpl;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt64;

public abstract class AbstractEdmEnumType
extends EdmTypeImpl
implements EdmEnumType {
    private final boolean isFlags;
    private final String uriPrefix;
    private final String uriSuffix;
    private List<String> memberNames;
    private Map<String, EdmMember> members;

    public AbstractEdmEnumType(Edm edm, FullQualifiedName fqn, boolean isFlags) {
        super(edm, fqn, EdmTypeKind.ENUM);
        this.isFlags = isFlags;
        this.uriPrefix = fqn.getFullQualifiedNameAsString() + '\'';
        this.uriSuffix = "'";
    }

    protected abstract Collection<? extends EdmMember> getMembers();

    public EdmMember getMember(String name) {
        if (this.members == null) {
            this.members = new LinkedHashMap<String, EdmMember>();
            for (EdmMember edmMember : this.getMembers()) {
                this.members.put(edmMember.getName(), edmMember);
            }
        }
        return this.members.get(name);
    }

    public List<String> getMemberNames() {
        if (this.memberNames == null) {
            this.memberNames = new ArrayList<String>();
            for (EdmMember edmMember : this.getMembers()) {
                this.memberNames.add(edmMember.getName());
            }
        }
        return this.memberNames;
    }

    public abstract EdmPrimitiveType getUnderlyingType();

    public boolean isCompatible(EdmPrimitiveType primitiveType) {
        return this.equals(primitiveType);
    }

    public Class<?> getDefaultType() {
        return this.getUnderlyingType().getDefaultType();
    }

    public boolean validate(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) {
        try {
            this.valueOfString(value, isNullable, maxLength, precision, scale, isUnicode, this.getDefaultType());
            return true;
        }
        catch (EdmPrimitiveTypeException e) {
            return false;
        }
    }

    private Long parseEnumValue(String value) throws EdmPrimitiveTypeException {
        Long result = null;
        for (String memberValue : value.split(",", this.isFlags ? -1 : 1)) {
            Long memberValueLong = null;
            for (EdmMember edmMember : this.getMembers()) {
                if (!edmMember.getName().equals(memberValue) && !edmMember.getValue().equals(memberValue)) continue;
                memberValueLong = Long.decode(edmMember.getValue());
            }
            if (memberValueLong == null) {
                throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.");
            }
            result = result == null ? memberValueLong : result | memberValueLong;
        }
        return result;
    }

    public <T> T valueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        if (value == null) {
            if (isNullable != null && !isNullable.booleanValue()) {
                throw new EdmPrimitiveTypeException("The literal 'null' is not allowed.");
            }
            return null;
        }
        try {
            return EdmInt64.convertNumber(this.parseEnumValue(value), returnType);
        }
        catch (IllegalArgumentException e) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' cannot be converted to value type " + returnType + ".", (Exception)e);
        }
        catch (ClassCastException e) {
            throw new EdmPrimitiveTypeException("The value type " + returnType + " is not supported.", (Exception)e);
        }
    }

    protected String constructEnumValue(long value) throws EdmPrimitiveTypeException {
        long remaining = value;
        StringBuilder result = new StringBuilder();
        for (EdmMember edmMember : this.getMembers()) {
            long memberValue = Long.parseLong(edmMember.getValue());
            if ((memberValue & remaining) != memberValue) continue;
            if (result.length() > 0) {
                result.append(',');
            }
            result.append(edmMember.getName());
            remaining ^= memberValue;
        }
        if (remaining != 0L) {
            throw new EdmPrimitiveTypeException("The value '" + value + "' is not valid.");
        }
        return result.toString();
    }

    public String valueToString(Object value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        if (value == null) {
            if (isNullable != null && !isNullable.booleanValue()) {
                throw new EdmPrimitiveTypeException("The value NULL is not allowed.");
            }
            return null;
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return this.constructEnumValue(((Number)value).longValue());
        }
        throw new EdmPrimitiveTypeException("The value type " + value.getClass() + " is not supported.");
    }

    public String toUriLiteral(String literal) {
        return literal == null ? null : (this.uriPrefix.isEmpty() && this.uriSuffix.isEmpty() ? literal : this.uriPrefix + literal + this.uriSuffix);
    }

    public String fromUriLiteral(String literal) throws EdmPrimitiveTypeException {
        if (literal == null) {
            return null;
        }
        if (this.uriPrefix.isEmpty() && this.uriSuffix.isEmpty()) {
            return literal;
        }
        if (literal.length() >= this.uriPrefix.length() + this.uriSuffix.length() && literal.startsWith(this.uriPrefix) && literal.endsWith(this.uriSuffix)) {
            return literal.substring(this.uriPrefix.length(), literal.length() - this.uriSuffix.length());
        }
        throw new EdmPrimitiveTypeException("The literal '" + literal + "' has illegal content.");
    }

    public boolean isFlags() {
        return this.isFlags;
    }

    public EdmAnnotationsTarget.TargetType getAnnotationsTargetType() {
        return EdmAnnotationsTarget.TargetType.EnumType;
    }

    public String getAnnotationsTargetPath() {
        return null;
    }

    public FullQualifiedName getAnnotationsTargetFQN() {
        return this.getFullQualifiedName();
    }
}

