/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.data.Annotation;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Linked;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.data.Valuable;
import org.apache.olingo.commons.api.domain.ODataOperation;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.commons.core.serialization.JsonSerializer;

public class JsonEntitySerializer
extends JsonSerializer {
    public JsonEntitySerializer(ODataServiceVersion version, boolean serverMode) {
        super(version, serverMode);
    }

    public JsonEntitySerializer(ODataServiceVersion version, boolean serverMode, ODataFormat format) {
        super(version, serverMode, format);
    }

    protected void doSerialize(Entity entity, JsonGenerator jgen) throws IOException, EdmPrimitiveTypeException {
        this.doContainerSerialize((ResWrap<Entity>)new ResWrap(null, null, (Object)entity), jgen);
    }

    protected void doContainerSerialize(ResWrap<Entity> container, JsonGenerator jgen) throws IOException, EdmPrimitiveTypeException {
        Entity entity = (Entity)container.getPayload();
        jgen.writeStartObject();
        if (this.serverMode) {
            if (container.getContextURL() != null) {
                jgen.writeStringField(this.version.compareTo((Enum)ODataServiceVersion.V40) >= 0 ? "@odata.context" : "odata.metadata", container.getContextURL().toASCIIString());
            }
            if (this.version.compareTo((Enum)ODataServiceVersion.V40) >= 0 && StringUtils.isNotBlank((CharSequence)container.getMetadataETag())) {
                jgen.writeStringField("@odata.metadataEtag", container.getMetadataETag());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getETag())) {
                jgen.writeStringField(this.version.getJsonName(ODataServiceVersion.JsonKey.ETAG), entity.getETag());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getType()) && this.format != ODataFormat.JSON_NO_METADATA) {
            jgen.writeStringField(this.version.getJsonName(ODataServiceVersion.JsonKey.TYPE), new EdmTypeInfo.Builder().setTypeExpression(entity.getType()).build().external(this.version));
        }
        if (entity.getId() != null && this.format != ODataFormat.JSON_NO_METADATA) {
            jgen.writeStringField(this.version.getJsonName(ODataServiceVersion.JsonKey.ID), entity.getId().toASCIIString());
        }
        for (Annotation annotation : entity.getAnnotations()) {
            this.valuable(jgen, (Valuable)annotation, "@" + annotation.getTerm());
        }
        for (Property property : entity.getProperties()) {
            this.valuable(jgen, (Valuable)property, property.getName());
        }
        if (this.serverMode && entity.getEditLink() != null && StringUtils.isNotBlank((CharSequence)entity.getEditLink().getHref())) {
            jgen.writeStringField(this.version.getJsonName(ODataServiceVersion.JsonKey.EDIT_LINK), entity.getEditLink().getHref());
            if (entity.isMediaEntity()) {
                jgen.writeStringField(this.version.getJsonName(ODataServiceVersion.JsonKey.MEDIA_READ_LINK), entity.getEditLink().getHref() + "/$value");
            }
        }
        if (this.format != ODataFormat.JSON_NO_METADATA) {
            this.links((Linked)entity, jgen);
        }
        for (Link link : entity.getMediaEditLinks()) {
            if (link.getTitle() == null) {
                jgen.writeStringField(this.version.getJsonName(ODataServiceVersion.JsonKey.MEDIA_EDIT_LINK), link.getHref());
            }
            if (link.getInlineEntity() != null) {
                jgen.writeObjectField(link.getTitle(), (Object)link.getInlineEntity());
            }
            if (link.getInlineEntitySet() == null) continue;
            jgen.writeArrayFieldStart(link.getTitle());
            for (Entity subEntry : link.getInlineEntitySet().getEntities()) {
                jgen.writeObject((Object)subEntry);
            }
            jgen.writeEndArray();
        }
        if (this.serverMode) {
            for (ODataOperation operation : entity.getOperations()) {
                jgen.writeObjectFieldStart("#" + StringUtils.substringAfterLast((String)operation.getMetadataAnchor(), (String)"#"));
                jgen.writeStringField("title", operation.getTitle());
                jgen.writeStringField("target", operation.getTarget().toASCIIString());
                jgen.writeEndObject();
            }
        }
        jgen.writeEndObject();
    }
}

