/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.olingo.commons.api.domain.ODataError;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.core.serialization.JsonDeserializer;
import org.apache.olingo.commons.core.serialization.JsonODataErrorDetailDeserializer;

public class JsonODataErrorDeserializer
extends JsonDeserializer {
    public JsonODataErrorDeserializer(ODataServiceVersion version, boolean serverMode) {
        super(version, serverMode);
    }

    protected ODataError doDeserialize(JsonParser parser) throws IOException {
        ODataError error = new ODataError();
        ObjectNode tree = (ObjectNode)parser.getCodec().readTree(parser);
        if (tree.has(this.jsonError)) {
            JsonNode errorNode = tree.get(this.jsonError);
            if (errorNode.has("code")) {
                error.setCode(errorNode.get("code").textValue());
            }
            if (errorNode.has("message")) {
                JsonNode message = errorNode.get("message");
                if (message.isValueNode()) {
                    error.setMessage(message.textValue());
                } else if (message.isObject()) {
                    error.setMessage(message.get("value").asText());
                }
            }
            if (errorNode.has("target")) {
                error.setTarget(errorNode.get("target").textValue());
            }
            if (errorNode.hasNonNull("details")) {
                ArrayList<Object> details = new ArrayList<Object>();
                JsonODataErrorDetailDeserializer detailDeserializer = new JsonODataErrorDetailDeserializer(this.version, this.serverMode);
                for (JsonNode jsonNode : errorNode.get("details")) {
                    details.add(detailDeserializer.doDeserialize(jsonNode.traverse(parser.getCodec())).getPayload());
                }
                error.setDetails(details);
            }
            if (errorNode.hasNonNull("innererror")) {
                HashMap<String, String> innerErrorMap = new HashMap<String, String>();
                JsonNode innerError = errorNode.get("innererror");
                Iterator itor = innerError.fieldNames();
                while (itor.hasNext()) {
                    String keyTmp = (String)itor.next();
                    String val = innerError.get(keyTmp).toString();
                    innerErrorMap.put(keyTmp, val);
                }
                error.setInnerError(innerErrorMap);
            }
        }
        return error;
    }
}

