/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.Filter;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHandler;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.json.simple.ContentHandler;
import org.teiid.json.simple.ParseException;
import org.teiid.olingo.Client;
import org.teiid.olingo.LocalClient;
import org.teiid.olingo.ODataFilter;
import org.teiid.olingo.ODataServlet;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.loopback.LoopbackExecutionFactory;

public class TestODataIntegration {
    private static int port;
    private static EmbeddedServer teiid;
    private static Server server;

    @BeforeClass
    public static void before() throws Exception {
        teiid = new EmbeddedServer();
        teiid.start(new EmbeddedConfiguration());
        teiid.addTranslator(LoopbackExecutionFactory.class);
        server = new Server();
        SocketConnector connector = new SocketConnector();
        server.setConnectors(new Connector[]{connector});
        ServletHandler handler = new ServletHandler();
        server.setHandler((Handler)handler);
        handler.addFilterWithMapping(new FilterHolder((Filter)new ODataFilter(){

            public Client buildClient(String vdbName, int version, Properties props) {
                LocalClient c = new LocalClient(vdbName, version, props);
                c.setDriver(teiid.getDriver());
                return c;
            }
        }), "/*", 0);
        handler.addServletWithMapping(ODataServlet.class, "/*");
        server.start();
        port = connector.getLocalPort();
        TestODataIntegration.deployVDB();
    }

    @AfterClass
    public static void after() throws Exception {
        server.stop();
        teiid.stop();
    }

    private static void deployVDB() throws IOException, ConnectorManagerRepository.ConnectorManagerException, VirtualDatabaseException, TranslatorException {
        teiid.deployVDB((InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"loopy-vdb.xml")));
    }

    @Test
    public void testMetadata() throws Exception {
        HttpClient http = new HttpClient();
        http.start();
        HttpExchange request = new HttpExchange(){

            protected void onResponseContent(Buffer content) {
                try {
                    Assert.assertEquals((Object)ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"loopy-edmx-metadata.xml")), (Object)new String(content.asArray()));
                }
                catch (IOException e) {
                    Assert.fail();
                }
            }

            protected void onResponseStatus(Buffer version, int status, Buffer reason) {
                Assert.assertEquals((long)200L, (long)status);
            }
        };
        request.setURL("http://localhost:" + port + "/odata4/loopy/vm1/$metadata");
        request.setMethod("GET");
        http.send(request);
        request.waitForDone();
    }

    @Test
    public void tesSystemMetadata() throws Exception {
        HttpClient http = new HttpClient();
        http.start();
        HttpExchange request = new HttpExchange(){

            protected void onResponseStatus(Buffer version, int status, Buffer reason) {
                Assert.assertEquals((long)200L, (long)status);
            }
        };
        request.setURL("http://localhost:" + port + "/odata4/loopy/SYS/$metadata");
        request.setMethod("GET");
        http.send(request);
        request.waitForDone();
    }

    @Test
    public void tesServiceMetadata() throws Exception {
        HttpClient http = new HttpClient();
        http.start();
        HttpExchange request = new HttpExchange(){

            protected void onResponseStatus(Buffer version, int status, Buffer reason) {
                Assert.assertEquals((long)200L, (long)status);
            }
        };
        request.setURL("http://localhost:" + port + "/odata4/loopy/VM1");
        request.setMethod("GET");
        http.send(request);
        request.waitForDone();
    }

    @Test
    public void testEntitySet() throws Exception {
        HttpClient http = new HttpClient();
        http.start();
        HttpExchange request = new HttpExchange(){

            protected void onResponseContent(Buffer content) {
                Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#G1\",\"value\":[{\"e1\":\"ABCDEFGHIJ\",\"e2\":0,\"e3\":0.0}]}", (Object)new String(content.asArray()));
            }

            protected void onResponseStatus(Buffer version, int status, Buffer reason) {
                Assert.assertEquals((long)200L, (long)status);
            }
        };
        request.setURL("http://localhost:" + port + "/odata4/loopy/vm1/G1");
        request.setMethod("GET");
        http.send(request);
        request.waitForDone();
        request.waitForDone();
    }

    @Test
    public void testEntitySetWithKey() throws Exception {
        HttpClient http = new HttpClient();
        http.start();
        HttpExchange request = new HttpExchange(){

            protected void onResponseContent(Buffer content) {
                Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#G1/$entity\",\"value\":[{\"e1\":\"ABCDEFGHIJ\",\"e2\":0,\"e3\":0.0}]}", (Object)new String(content.asArray()));
            }

            protected void onResponseStatus(Buffer version, int status, Buffer reason) {
                Assert.assertEquals((long)200L, (long)status);
            }
        };
        request.setURL("http://localhost:" + port + "/odata4/loopy/vm1/G1(0)");
        request.setMethod("GET");
        http.send(request);
        request.waitForDone();
    }

    @Test
    public void testIndividualProperty() throws Exception {
        HttpClient http = new HttpClient();
        http.start();
        HttpExchange request = new HttpExchange(){

            protected void onResponseContent(Buffer content) {
                Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#Edm.String\",\"value\":\"ABCDEFGHIJ\"}", (Object)new String(content.asArray()));
            }

            protected void onResponseStatus(Buffer version, int status, Buffer reason) {
                Assert.assertEquals((long)200L, (long)status);
            }
        };
        request.setURL("http://localhost:" + port + "/odata4/loopy/vm1/G1(1)/e1");
        request.setMethod("GET");
        http.send(request);
        request.waitForDone();
    }

    @Ignore
    @Test
    public void testProcedure() throws Exception {
        HttpClient http = new HttpClient();
        http.start();
        HttpExchange request = new HttpExchange(){

            protected void onResponseContent(Buffer content) {
                Assert.assertEquals((Object)"{\"@odata.context\":\"$metadata#Edm.String\",\"value\":\"ABCDEFGHIJ\"}", (Object)new String(content.asArray()));
            }

            protected void onResponseStatus(Buffer version, int status, Buffer reason) {
                Assert.assertEquals((long)200L, (long)status);
            }
        };
        request.setURL("http://localhost:" + port + "/odata4/loopy/vm1/proc(x='foo')");
        request.setMethod("GET");
        http.send(request);
        request.waitForDone();
    }

    private static final class JSONValueExtractor
    implements ContentHandler {
        Object value;
        boolean next;
        String key;

        private JSONValueExtractor(String key) {
            this.key = key;
        }

        public boolean startObjectEntry(String key) throws ParseException, IOException {
            if (key.equals(this.key)) {
                this.next = true;
            }
            return true;
        }

        public boolean startObject() throws ParseException, IOException {
            return true;
        }

        public void startJSON() throws ParseException, IOException {
        }

        public boolean startArray() throws ParseException, IOException {
            return true;
        }

        public boolean primitive(Object value) throws ParseException, IOException {
            if (this.next) {
                this.value = value;
                this.next = false;
            }
            return true;
        }

        public boolean endObjectEntry() throws ParseException, IOException {
            return true;
        }

        public boolean endObject() throws ParseException, IOException {
            return true;
        }

        public void endJSON() throws ParseException, IOException {
        }

        public boolean endArray() throws ParseException, IOException {
            return true;
        }
    }
}

