/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo;

import java.io.IOException;
import java.lang.reflect.Array;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.EdmElement;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.core.data.EntityImpl;
import org.apache.olingo.commons.core.data.EntitySetImpl;
import org.apache.olingo.commons.core.data.PropertyImpl;
import org.apache.olingo.server.core.edm.provider.EdmPropertyImpl;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.Transform;
import org.teiid.core.types.TransformationException;
import org.teiid.olingo.ODataPlugin;
import org.teiid.olingo.ODataTypeManager;
import org.teiid.olingo.ProjectedColumn;
import org.teiid.olingo.QueryResponse;

public class EntityList
extends EntitySetImpl
implements QueryResponse {
    private final String invalidCharacterReplacement;
    private final HashMap<String, EdmElement> propertyTypes;
    private final List<ProjectedColumn> projectedColumns;

    public EntityList(String invalidCharacterReplacement, EdmEntitySet edmEntitySet, List<ProjectedColumn> projectedColumns) {
        this.invalidCharacterReplacement = invalidCharacterReplacement;
        this.propertyTypes = new HashMap();
        this.projectedColumns = projectedColumns;
        EdmEntityType entityType = edmEntitySet.getEntityType();
        for (String prop : entityType.getPropertyNames()) {
            this.propertyTypes.put(prop, entityType.getProperty(prop));
        }
    }

    @Override
    public void addRow(ResultSet rs) throws SQLException, TeiidException {
        this.getEntities().add(this.getEntity(rs));
    }

    private Entity getEntity(ResultSet rs) throws SQLException, TeiidException {
        HashMap<Integer, PropertyImpl> properties = new HashMap<Integer, PropertyImpl>();
        for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
            Object value = rs.getObject(i + 1);
            String propName = rs.getMetaData().getColumnLabel(i + 1);
            EdmElement element = this.propertyTypes.get(propName);
            if (!(element instanceof EdmProperty) && !((EdmProperty)element).isPrimitive()) {
                throw new TeiidException((BundleUtil.Event)ODataPlugin.Event.TEIID16024, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16024, new Object[0]));
            }
            EdmPropertyImpl edmProperty = (EdmPropertyImpl)element;
            try {
                PropertyImpl property = EntityList.buildPropery(propName, edmProperty.getTypeInfo().getPrimitiveTypeKind(), value, this.invalidCharacterReplacement);
                properties.put(i, property);
                continue;
            }
            catch (IOException e) {
                throw new TeiidException((Throwable)e);
            }
        }
        EntityImpl entity = new EntityImpl();
        for (int i = 0; i < this.projectedColumns.size(); ++i) {
            ProjectedColumn entry = this.projectedColumns.get(i);
            if (!entry.isVisible()) continue;
            entity.addProperty((Property)properties.get(i));
        }
        return entity;
    }

    static PropertyImpl buildPropery(String propName, EdmPrimitiveTypeKind type, Object value, String invalidCharacterReplacement) throws TransformationException, SQLException, IOException {
        if (value instanceof java.sql.Array) {
            value = ((java.sql.Array)value).getArray();
            int length = Array.getLength(value);
            ArrayList<Object> values = new ArrayList<Object>();
            for (int i = 0; i < length; ++i) {
                Object o = Array.get(value, i);
                Object p = EntityList.getPropertyValue(type, o, invalidCharacterReplacement);
                values.add(p);
            }
            return EntityList.createCollection(propName, type, values);
        }
        return EntityList.createPrimitive(propName, type, EntityList.getPropertyValue(type, value, invalidCharacterReplacement));
    }

    private static PropertyImpl createPrimitive(String name, EdmPrimitiveTypeKind type, Object value) {
        return new PropertyImpl(type.getFullQualifiedName().getFullQualifiedNameAsString(), name, ValueType.PRIMITIVE, value);
    }

    private static PropertyImpl createCollection(String name, EdmPrimitiveTypeKind type, Object ... values) {
        return new PropertyImpl(type.getFullQualifiedName().getFullQualifiedNameAsString(), name, ValueType.COLLECTION_PRIMITIVE, Arrays.asList(values));
    }

    static Object getPropertyValue(EdmPrimitiveTypeKind expectedType, Object value, String invalidCharacterReplacement) throws TransformationException, SQLException, IOException {
        Class targetType;
        if (value == null) {
            return null;
        }
        Class sourceType = DataTypeManager.getRuntimeType(value.getClass());
        if (sourceType != (targetType = DataTypeManager.getDataTypeClass((String)ODataTypeManager.teiidType(expectedType)))) {
            Transform t = DataTypeManager.getTransform((Class)sourceType, (Class)targetType);
            if (t == null && BlobType.class == targetType) {
                if (sourceType == ClobType.class) {
                    return ClobType.getString((Clob)((Clob)value)).getBytes();
                }
                if (sourceType == SQLXML.class) {
                    return ((SQLXML)value).getString().getBytes();
                }
            }
            value = t != null ? t.transform(value, targetType) : value;
            value = EntityList.replaceInvalidCharacters(expectedType, value, invalidCharacterReplacement);
            return value;
        }
        value = EntityList.replaceInvalidCharacters(expectedType, value, invalidCharacterReplacement);
        return value;
    }

    static Object replaceInvalidCharacters(EdmPrimitiveTypeKind expectedType, Object value, String invalidCharacterReplacement) {
        if (expectedType != EdmPrimitiveTypeKind.String || invalidCharacterReplacement == null) {
            return value;
        }
        if (value instanceof Character) {
            value = value.toString();
        }
        String s = (String)value;
        StringBuilder result = null;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c <= ' ' && c != ' ' && c != '\n' && c != '\t' && c != '\r') {
                if (result == null) {
                    result = new StringBuilder();
                    result.append(s.substring(0, i));
                }
                result.append(invalidCharacterReplacement);
                continue;
            }
            if (result == null) continue;
            result.append(c);
        }
        if (result == null) {
            return value;
        }
        return result.toString();
    }

    @Override
    public long size() {
        return this.getEntities().size();
    }

    @Override
    public void setCount(long count) {
        super.setCount(Integer.valueOf((int)count));
    }

    @Override
    public void setNext(long row) {
    }
}

