/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.Target;
import org.apache.olingo.server.api.edm.provider.Action;
import org.apache.olingo.server.api.edm.provider.ActionImport;
import org.apache.olingo.server.api.edm.provider.ComplexType;
import org.apache.olingo.server.api.edm.provider.EntityContainer;
import org.apache.olingo.server.api.edm.provider.EntitySet;
import org.apache.olingo.server.api.edm.provider.EntityType;
import org.apache.olingo.server.api.edm.provider.Function;
import org.apache.olingo.server.api.edm.provider.FunctionImport;
import org.apache.olingo.server.api.edm.provider.NavigationProperty;
import org.apache.olingo.server.api.edm.provider.NavigationPropertyBinding;
import org.apache.olingo.server.api.edm.provider.Parameter;
import org.apache.olingo.server.api.edm.provider.Property;
import org.apache.olingo.server.api.edm.provider.PropertyRef;
import org.apache.olingo.server.api.edm.provider.ReferentialConstraint;
import org.apache.olingo.server.api.edm.provider.ReturnType;
import org.apache.olingo.server.api.edm.provider.Schema;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.logging.LogManager;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Table;
import org.teiid.olingo.ODataPlugin;
import org.teiid.olingo.ODataTypeManager;

public class OData4EntitySchemaBuilder {
    public static Schema buildMetadata(org.teiid.metadata.Schema teiidSchema) {
        try {
            Schema edmSchema = new Schema();
            OData4EntitySchemaBuilder.buildEntityTypes(teiidSchema, edmSchema);
            OData4EntitySchemaBuilder.buildProcedures(teiidSchema, edmSchema);
            return edmSchema;
        }
        catch (Exception e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    static EntitySet findEntitySet(Schema edmSchema, String enitityName) {
        EntityContainer entityContainter = edmSchema.getEntityContainer();
        for (EntitySet entitySet : entityContainter.getEntitySets()) {
            if (!entitySet.getName().equalsIgnoreCase(enitityName)) continue;
            return entitySet;
        }
        return null;
    }

    static Schema findSchema(Map<String, Schema> edmSchemas, String schemaName) {
        return edmSchemas.get(schemaName);
    }

    static EntityType findEntityType(Map<String, Schema> edmSchemas, String schemaName, String enitityName) {
        Schema schema = OData4EntitySchemaBuilder.findSchema(edmSchemas, schemaName);
        if (schema != null) {
            for (EntityType type : schema.getEntityTypes()) {
                if (!type.getName().equalsIgnoreCase(enitityName)) continue;
                return type;
            }
        }
        return null;
    }

    static EntityContainer findEntityContainer(Map<String, Schema> edmSchemas, String schemaName) {
        Schema schema = edmSchemas.get(schemaName);
        return schema.getEntityContainer();
    }

    public static void buildEntityTypes(org.teiid.metadata.Schema schema, Schema edmSchema) {
        ArrayList<EntitySet> entitySets = new ArrayList<EntitySet>();
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        for (Table table : schema.getTables().values()) {
            KeyRecord primaryKey = table.getPrimaryKey();
            List uniques = table.getUniqueKeys();
            if (primaryKey == null && uniques.isEmpty()) {
                LogManager.logDetail((String)"org.teiid.ODATA", (Object)ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16017, new Object[]{table.getFullName()}));
                continue;
            }
            String entityTypeName = table.getName();
            EntityType entityType = new EntityType().setName(entityTypeName);
            ArrayList<Property> properties = new ArrayList<Property>();
            for (Column c : table.getColumns()) {
                properties.add(OData4EntitySchemaBuilder.buildProperty(c));
            }
            entityType.setProperties(properties);
            if (OData4EntitySchemaBuilder.hasStream(properties)) {
                entityType.setHasStream(true);
            }
            ArrayList<PropertyRef> keyProps = new ArrayList<PropertyRef>();
            if (primaryKey != null) {
                for (Column c : primaryKey.getColumns()) {
                    keyProps.add(new PropertyRef().setPropertyName(c.getName()));
                }
            } else {
                for (Column c : ((KeyRecord)uniques.get(0)).getColumns()) {
                    keyProps.add(new PropertyRef().setPropertyName(c.getName()));
                }
            }
            entityType.setKey(keyProps);
            EntitySet entitySet = new EntitySet().setName(table.getName()).setType(new FullQualifiedName(schema.getName(), table.getName())).setIncludeInServiceDocument(true);
            OData4EntitySchemaBuilder.buildNavigationProperties(table, entityType, entitySet);
            entityTypes.add(entityType);
            entitySets.add(entitySet);
        }
        EntityContainer entityContainer = new EntityContainer().setName(schema.getName()).setEntitySets(entitySets);
        edmSchema.setNamespace(schema.getName()).setAlias(schema.getName()).setEntityTypes(entityTypes).setEntityContainer(entityContainer);
    }

    private static boolean hasStream(List<Property> properties) {
        for (Property p : properties) {
            if (!p.getType().equals((Object)EdmPrimitiveTypeKind.Binary.getFullQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private static Property buildProperty(Column c) {
        Property property = new Property().setName(c.getName()).setType(ODataTypeManager.odataType(c.getRuntimeType()).getFullQualifiedName()).setNullable(Boolean.valueOf(c.getNullType() == BaseColumn.NullType.Nullable));
        if (DataTypeManager.isArrayType((String)c.getRuntimeType())) {
            property.setCollection(true);
        }
        if (c.getRuntimeType().equals("string")) {
            property.setMaxLength(Integer.valueOf(c.getLength())).setUnicode(Boolean.valueOf(true));
        } else if (c.getRuntimeType().equals("double") || c.getRuntimeType().equals("float") || c.getRuntimeType().equals("bigdecimal")) {
            property.setPrecision(Integer.valueOf(c.getPrecision()));
            property.setScale(Integer.valueOf(c.getScale()));
        } else if (c.getDefaultValue() != null) {
            property.setDefaultValue(c.getDefaultValue());
        }
        return property;
    }

    private static void buildNavigationProperties(Table table, EntityType entityType, EntitySet entitySet) {
        KeyRecord primaryKey = table.getPrimaryKey();
        List uniques = table.getUniqueKeys();
        if (primaryKey == null && uniques.isEmpty()) {
            return;
        }
        ArrayList<NavigationProperty> navigationProperties = new ArrayList<NavigationProperty>();
        ArrayList<NavigationPropertyBinding> navigationBindingProperties = new ArrayList<NavigationPropertyBinding>();
        for (ForeignKey fk : table.getForeignKeys()) {
            String refSchemaName = ((org.teiid.metadata.Schema)((Table)fk.getReferenceKey().getParent()).getParent()).getName();
            boolean onetoone = OData4EntitySchemaBuilder.sameColumnSet(table.getPrimaryKey(), (KeyRecord)fk);
            NavigationProperty navigaton = new NavigationProperty();
            navigaton.setName(fk.getName()).setType(new FullQualifiedName(refSchemaName, fk.getReferenceTableName()));
            if (!onetoone) {
                navigaton.setCollection(true);
            } else {
                navigaton.setNullable(Boolean.valueOf(false));
            }
            NavigationPropertyBinding navigationBinding = new NavigationPropertyBinding();
            navigationBinding.setPath(fk.getName());
            navigationBinding.setTarget(new Target().setTargetName(fk.getReferenceTableName()));
            ArrayList constrainsts = new ArrayList();
            for (int i = 0; i < fk.getColumns().size(); ++i) {
                Column c = (Column)fk.getColumns().get(i);
                String refColumn = (String)fk.getReferenceColumns().get(i);
                ReferentialConstraint constraint = new ReferentialConstraint();
                constraint.setProperty(c.getName());
                constraint.setReferencedProperty(refColumn);
            }
            navigaton.setReferentialConstraints(constrainsts);
            navigationProperties.add(navigaton);
            navigationBindingProperties.add(navigationBinding);
        }
        entityType.setNavigationProperties(navigationProperties);
        entitySet.setNavigationPropertyBindings(navigationBindingProperties);
    }

    public static void buildProcedures(org.teiid.metadata.Schema schema, Schema edmSchema) {
        ArrayList<ComplexType> complexTypes = new ArrayList<ComplexType>();
        ArrayList<Function> functions = new ArrayList<Function>();
        ArrayList<FunctionImport> functionImports = new ArrayList<FunctionImport>();
        ArrayList<Action> actions = new ArrayList<Action>();
        ArrayList<ActionImport> actionImports = new ArrayList<ActionImport>();
        for (Procedure proc : schema.getProcedures().values()) {
            if (OData4EntitySchemaBuilder.doesProcedureReturn(proc)) {
                OData4EntitySchemaBuilder.buildFunction(schema.getName(), proc, complexTypes, functions, functionImports);
                continue;
            }
            OData4EntitySchemaBuilder.buildAction(schema.getName(), proc, complexTypes, actions, actionImports);
        }
        edmSchema.setComplexTypes(complexTypes);
        edmSchema.setFunctions(functions);
        edmSchema.setActions(actions);
        edmSchema.getEntityContainer().setFunctionImports(functionImports);
        edmSchema.getEntityContainer().setActionImports(actionImports);
    }

    private static boolean doesProcedureReturn(Procedure proc) {
        for (ProcedureParameter pp : proc.getParameters()) {
            if (!pp.getName().equals("return")) continue;
            return true;
        }
        return false;
    }

    public static void buildFunction(String schemaName, Procedure proc, ArrayList<ComplexType> complexTypes, ArrayList<Function> functions, ArrayList<FunctionImport> functionImports) {
        Function edmFunction = new Function();
        edmFunction.setName(proc.getName());
        edmFunction.setBound(false);
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        for (ProcedureParameter pp : proc.getParameters()) {
            if (pp.getName().equals("return")) {
                edmFunction.setReturnType(new ReturnType().setType(ODataTypeManager.odataType(pp.getRuntimeType()).getFullQualifiedName()));
                continue;
            }
            Parameter param = new Parameter();
            param.setName(pp.getName());
            param.setType(ODataTypeManager.odataType(pp.getRuntimeType()).getFullQualifiedName());
            if (DataTypeManager.isArrayType((String)pp.getRuntimeType())) {
                param.setCollection(true);
            }
            param.setNullable(Boolean.valueOf(pp.getNullType() == BaseColumn.NullType.Nullable));
            params.add(param);
        }
        edmFunction.setParameters(params);
        ColumnSet returnColumns = proc.getResultSet();
        if (returnColumns != null) {
            ComplexType complexType = new ComplexType();
            String entityTypeName = proc.getName() + "_" + returnColumns.getName();
            complexType.setName(entityTypeName);
            ArrayList<Property> props = new ArrayList<Property>();
            for (Column c : returnColumns.getColumns()) {
                props.add(OData4EntitySchemaBuilder.buildProperty(c));
            }
            complexType.setProperties(props);
            complexTypes.add(complexType);
            edmFunction.setReturnType(new ReturnType().setType(new FullQualifiedName(schemaName, complexType.getName())).setCollection(true));
        }
        FunctionImport functionImport = new FunctionImport();
        functionImport.setName(proc.getName()).setFunction(new FullQualifiedName(schemaName, proc.getName()));
        functions.add(edmFunction);
        functionImports.add(functionImport);
    }

    public static void buildAction(String schemaName, Procedure proc, ArrayList<ComplexType> complexTypes, ArrayList<Action> actions, ArrayList<ActionImport> actionImports) {
        Action edmAction = new Action();
        edmAction.setName(proc.getName());
        edmAction.setBound(false);
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        for (ProcedureParameter pp : proc.getParameters()) {
            if (pp.getName().equals("return")) {
                edmAction.setReturnType(new ReturnType().setType(ODataTypeManager.odataType(pp.getRuntimeType()).getFullQualifiedName()));
                continue;
            }
            Parameter param = new Parameter();
            param.setName(pp.getName());
            param.setType(ODataTypeManager.odataType(pp.getRuntimeType()).getFullQualifiedName());
            if (DataTypeManager.isArrayType((String)pp.getRuntimeType())) {
                param.setCollection(true);
            }
            param.setNullable(Boolean.valueOf(pp.getNullType() == BaseColumn.NullType.Nullable));
            params.add(param);
        }
        edmAction.setParameters(params);
        ColumnSet returnColumns = proc.getResultSet();
        if (returnColumns != null) {
            ComplexType complexType = new ComplexType();
            String entityTypeName = proc.getName() + "_" + returnColumns.getName();
            complexType.setName(entityTypeName);
            ArrayList<Property> props = new ArrayList<Property>();
            for (Column c : returnColumns.getColumns()) {
                props.add(OData4EntitySchemaBuilder.buildProperty(c));
            }
            complexType.setProperties(props);
            complexTypes.add(complexType);
            edmAction.setReturnType(new ReturnType().setType(new FullQualifiedName(schemaName, complexType.getName())).setCollection(true));
        }
        ActionImport actionImport = new ActionImport();
        actionImport.setName(proc.getName()).setAction(new FullQualifiedName(schemaName, proc.getName()));
        actions.add(edmAction);
        actionImports.add(actionImport);
    }

    static List<String> getColumnNames(List<Column> columns) {
        ArrayList<String> names = new ArrayList<String>();
        for (Column c : columns) {
            names.add(c.getName());
        }
        return names;
    }

    static boolean sameColumnSet(KeyRecord recordOne, KeyRecord recordTwo) {
        if (recordOne == null || recordTwo == null) {
            return false;
        }
        List setOne = recordOne.getColumns();
        List setTwo = recordTwo.getColumns();
        if (setOne.size() != setTwo.size()) {
            return false;
        }
        for (int i = 0; i < setOne.size(); ++i) {
            Column one = (Column)setOne.get(i);
            Column two = (Column)setTwo.get(i);
            if (one.getName().equals(two.getName())) continue;
            return false;
        }
        return true;
    }
}

