/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.olingo.commons.api.domain.AbstractODataValue;
import org.apache.olingo.commons.api.domain.ODataCollectionValue;
import org.apache.olingo.commons.api.domain.ODataValue;

public abstract class AbstractODataCollectionValue<OV extends ODataValue>
extends AbstractODataValue
implements ODataCollectionValue<OV> {
    protected final List<OV> values = new ArrayList<OV>();

    public AbstractODataCollectionValue(String typeName) {
        super(typeName == null || typeName.startsWith("Collection(") ? typeName : "Collection(" + typeName + ")");
    }

    protected abstract ODataCollectionValue<OV> getThis();

    public ODataCollectionValue<OV> add(ODataValue value) {
        this.values.add(value);
        return this.getThis();
    }

    public Iterator<OV> iterator() {
        return this.values.iterator();
    }

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public Collection<Object> asJavaCollection() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (ODataValue value : this.values) {
            if (value.isPrimitive()) {
                result.add(value.asPrimitive().toValue());
                continue;
            }
            if (value.isComplex()) {
                result.add(value.asComplex().asJavaMap());
                continue;
            }
            if (!value.isCollection()) continue;
            result.add(value.asCollection().asJavaCollection());
        }
        return result;
    }
}

