/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.domain;

import java.util.UUID;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.domain.AbstractODataValue;
import org.apache.olingo.commons.api.domain.ODataPrimitiveValue;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;

public abstract class AbstractODataPrimitiveValue
extends AbstractODataValue
implements ODataPrimitiveValue {
    private EdmPrimitiveTypeKind typeKind;
    private EdmPrimitiveType type;
    private Object value;

    protected AbstractODataPrimitiveValue() {
        super(null);
    }

    public String getTypeName() {
        return this.typeKind.getFullQualifiedName().toString();
    }

    public EdmPrimitiveTypeKind getTypeKind() {
        return this.typeKind;
    }

    public EdmPrimitiveType getType() {
        return this.type;
    }

    public Object toValue() {
        return this.value;
    }

    public <T> T toCastValue(Class<T> reference) throws EdmPrimitiveTypeException {
        if (this.value == null) {
            return null;
        }
        if (this.typeKind.isGeospatial()) {
            return reference.cast(this.value);
        }
        return (T)this.type.valueOfString(this.type.valueToString(this.value, null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null), null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null, reference);
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        if (this.typeKind.isGeospatial()) {
            return this.value.toString();
        }
        try {
            return this.type.valueToString(this.value, null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null);
        }
        catch (EdmPrimitiveTypeException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static abstract class AbstractBuilder
    implements ODataPrimitiveValue.Builder {
        private final ODataServiceVersion version;

        public AbstractBuilder(ODataServiceVersion version) {
            this.version = version;
        }

        protected abstract AbstractODataPrimitiveValue getInstance();

        public AbstractBuilder setType(EdmType type) {
            EdmPrimitiveTypeKind primitiveTypeKind = null;
            if (type != null) {
                if (type.getKind() != EdmTypeKind.PRIMITIVE) {
                    throw new IllegalArgumentException(String.format("Provided type %s is not primitive", type));
                }
                primitiveTypeKind = EdmPrimitiveTypeKind.valueOf((String)type.getName());
            }
            return this.setType(primitiveTypeKind);
        }

        public AbstractBuilder setType(EdmPrimitiveTypeKind type) {
            if (type != null && !type.getSupportedVersions().contains(this.version)) {
                throw new IllegalArgumentException(String.format("Type %s not supported by OData version %s", type.toString(), this.version));
            }
            if (type == EdmPrimitiveTypeKind.Stream) {
                throw new IllegalArgumentException(String.format("Cannot build a primitive value for %s", EdmPrimitiveTypeKind.Stream.toString()));
            }
            if (type == EdmPrimitiveTypeKind.Geography || type == EdmPrimitiveTypeKind.Geometry) {
                throw new IllegalArgumentException(type + "is not an instantiable type. " + "An entity can declare a property to be of type Geometry. " + "An instance of an entity MUST NOT have a value of type Geometry. " + "Each value MUST be of some subtype.");
            }
            this.getInstance().typeKind = type == null ? EdmPrimitiveTypeKind.String : type;
            this.getInstance().type = EdmPrimitiveTypeFactory.getInstance(this.getInstance().typeKind);
            return this;
        }

        public AbstractBuilder setValue(Object value) {
            this.getInstance().value = value;
            return this;
        }

        public ODataPrimitiveValue build() {
            if (this.getInstance().type == null) {
                this.setType(EdmPrimitiveTypeKind.String);
            }
            return this.getInstance();
        }

        public ODataPrimitiveValue buildBoolean(Boolean value) {
            return this.setType(EdmPrimitiveTypeKind.Boolean).setValue(value).build();
        }

        public ODataPrimitiveValue buildInt16(Short value) {
            return this.setType(EdmPrimitiveTypeKind.Int16).setValue(value).build();
        }

        public ODataPrimitiveValue buildInt32(Integer value) {
            return this.setType(EdmPrimitiveTypeKind.Int32).setValue(value).build();
        }

        public ODataPrimitiveValue buildInt64(Long value) {
            return this.setType(EdmPrimitiveTypeKind.Int64).setValue(value).build();
        }

        public ODataPrimitiveValue buildSingle(Float value) {
            return this.setType(EdmPrimitiveTypeKind.Single).setValue(value).build();
        }

        public ODataPrimitiveValue buildDouble(Double value) {
            return this.setType(EdmPrimitiveTypeKind.Double).setValue(value).build();
        }

        public ODataPrimitiveValue buildString(String value) {
            return this.setType(EdmPrimitiveTypeKind.String).setValue(value).build();
        }

        public ODataPrimitiveValue buildGuid(UUID value) {
            return this.setType(EdmPrimitiveTypeKind.Guid).setValue(value).build();
        }

        public ODataPrimitiveValue buildBinary(byte[] value) {
            return this.setType(EdmPrimitiveTypeKind.Binary).setValue(value).build();
        }
    }
}

