/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmActionImport;
import org.apache.olingo.commons.api.edm.EdmAnnotationsTarget;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmSingleton;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.core.edm.EdmNamedImpl;

public abstract class AbstractEdmEntityContainer
extends EdmNamedImpl
implements EdmEntityContainer {
    protected final FullQualifiedName entityContainerName;
    protected final Map<String, EdmSingleton> singletons = new HashMap<String, EdmSingleton>();
    private boolean allSingletonsLoaded = false;
    protected final Map<String, EdmEntitySet> entitySets = new HashMap<String, EdmEntitySet>();
    private boolean allEntitySetsLoaded = false;
    protected final Map<String, EdmActionImport> actionImports = new HashMap<String, EdmActionImport>();
    private final FullQualifiedName parentContainerName;
    private boolean allActionImportsLoaded = false;
    protected final Map<String, EdmFunctionImport> functionImports = new HashMap<String, EdmFunctionImport>();
    private boolean allFunctionImportsLoaded = false;

    public AbstractEdmEntityContainer(Edm edm, FullQualifiedName entityContainerName, FullQualifiedName parentContainerName) {
        super(edm, entityContainerName.getName());
        this.entityContainerName = entityContainerName;
        this.parentContainerName = parentContainerName;
    }

    public boolean isDefault() {
        return true;
    }

    public String getNamespace() {
        return this.entityContainerName.getNamespace();
    }

    public FullQualifiedName getFullQualifiedName() {
        return new FullQualifiedName(this.getNamespace(), this.getName());
    }

    protected abstract EdmSingleton createSingleton(String var1);

    public EdmSingleton getSingleton(String singletonName) {
        EdmSingleton singleton = this.singletons.get(singletonName);
        if (singleton == null && (singleton = this.createSingleton(singletonName)) != null) {
            this.singletons.put(singletonName, singleton);
        }
        return singleton;
    }

    protected abstract EdmEntitySet createEntitySet(String var1);

    public EdmEntitySet getEntitySet(String entitySetName) {
        EdmEntitySet entitySet = this.entitySets.get(entitySetName);
        if (entitySet == null && (entitySet = this.createEntitySet(entitySetName)) != null) {
            this.entitySets.put(entitySetName, entitySet);
        }
        return entitySet;
    }

    protected abstract EdmActionImport createActionImport(String var1);

    public EdmActionImport getActionImport(String actionImportName) {
        EdmActionImport actionImport = this.actionImports.get(actionImportName);
        if (actionImport == null && (actionImport = this.createActionImport(actionImportName)) != null) {
            this.actionImports.put(actionImportName, actionImport);
        }
        return actionImport;
    }

    protected abstract EdmFunctionImport createFunctionImport(String var1);

    public EdmFunctionImport getFunctionImport(String functionImportName) {
        EdmFunctionImport functionImport = this.functionImports.get(functionImportName);
        if (functionImport == null && (functionImport = this.createFunctionImport(functionImportName)) != null) {
            this.functionImports.put(functionImportName, functionImport);
        }
        return functionImport;
    }

    public List<EdmEntitySet> getEntitySets() {
        if (!this.allEntitySetsLoaded) {
            this.loadAllEntitySets();
            this.allEntitySetsLoaded = true;
        }
        return new ArrayList<EdmEntitySet>(this.entitySets.values());
    }

    protected abstract void loadAllEntitySets();

    public List<EdmFunctionImport> getFunctionImports() {
        if (!this.allFunctionImportsLoaded) {
            this.loadAllFunctionImports();
            this.allFunctionImportsLoaded = true;
        }
        return new ArrayList<EdmFunctionImport>(this.functionImports.values());
    }

    protected abstract void loadAllFunctionImports();

    public List<EdmSingleton> getSingletons() {
        if (!this.allSingletonsLoaded) {
            this.loadAllSingletons();
            this.allSingletonsLoaded = true;
        }
        return new ArrayList<EdmSingleton>(this.singletons.values());
    }

    protected abstract void loadAllSingletons();

    public List<EdmActionImport> getActionImports() {
        if (!this.allActionImportsLoaded) {
            this.loadAllActionImports();
            this.allActionImportsLoaded = true;
        }
        return new ArrayList<EdmActionImport>(this.actionImports.values());
    }

    protected abstract void loadAllActionImports();

    public FullQualifiedName getParentContainerName() {
        return this.parentContainerName;
    }

    public EdmAnnotationsTarget.TargetType getAnnotationsTargetType() {
        return EdmAnnotationsTarget.TargetType.EntityContainer;
    }

    public String getAnnotationsTargetPath() {
        return null;
    }

    public FullQualifiedName getAnnotationsTargetFQN() {
        return this.getFullQualifiedName();
    }
}

