/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAnnotationsTarget;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmKeyPropertyRef;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.core.edm.AbstractEdmStructuredType;

public abstract class AbstractEdmEntityType
extends AbstractEdmStructuredType
implements EdmEntityType {
    private final boolean hasStream;
    protected EdmEntityType entityBaseType;
    private final List<String> keyPredicateNames = new ArrayList<String>();
    private final Map<String, EdmKeyPropertyRef> keyPropertyRefs = new LinkedHashMap<String, EdmKeyPropertyRef>();
    private List<EdmKeyPropertyRef> keyPropertyRefsList;

    protected AbstractEdmEntityType(Edm edm, FullQualifiedName typeName, FullQualifiedName baseTypeName, boolean hashStream) {
        super(edm, typeName, EdmTypeKind.ENTITY, baseTypeName);
        this.hasStream = hashStream;
    }

    protected void setEdmKeyPropertyRef(List<EdmKeyPropertyRef> edmKey) {
        for (EdmKeyPropertyRef ref : edmKey) {
            if (ref.getAlias() == null) {
                this.keyPredicateNames.add(ref.getKeyPropertyName());
                this.keyPropertyRefs.put(ref.getKeyPropertyName(), ref);
                continue;
            }
            this.keyPredicateNames.add(ref.getAlias());
            this.keyPropertyRefs.put(ref.getAlias(), ref);
        }
    }

    @Override
    protected EdmStructuredType buildBaseType(FullQualifiedName baseTypeName) {
        EdmEntityType baseType = null;
        if (baseTypeName != null && (baseType = this.edm.getEntityType(baseTypeName)) == null) {
            throw new EdmException("Cannot find base type with name: " + baseTypeName + " for entity type: " + this.getName());
        }
        return baseType;
    }

    public EdmEntityType getBaseType() {
        this.checkBaseType();
        return this.entityBaseType;
    }

    public List<String> getKeyPredicateNames() {
        this.checkBaseType();
        if (this.keyPredicateNames.isEmpty() && this.baseType != null) {
            return this.entityBaseType.getKeyPredicateNames();
        }
        return this.keyPredicateNames;
    }

    public List<EdmKeyPropertyRef> getKeyPropertyRefs() {
        this.checkBaseType();
        if (this.keyPropertyRefsList == null) {
            this.keyPropertyRefsList = new ArrayList<EdmKeyPropertyRef>(this.keyPropertyRefs.values());
        }
        if (this.keyPropertyRefsList.isEmpty() && this.entityBaseType != null) {
            return this.entityBaseType.getKeyPropertyRefs();
        }
        return this.keyPropertyRefsList;
    }

    public EdmKeyPropertyRef getKeyPropertyRef(String keyPredicateName) {
        this.checkBaseType();
        EdmKeyPropertyRef edmKeyPropertyRef = this.keyPropertyRefs.get(keyPredicateName);
        if (edmKeyPropertyRef == null && this.entityBaseType != null) {
            return this.entityBaseType.getKeyPropertyRef(keyPredicateName);
        }
        return edmKeyPropertyRef;
    }

    public boolean hasStream() {
        return this.hasStream;
    }

    @Override
    protected void checkBaseType() {
    }

    public EdmAnnotationsTarget.TargetType getAnnotationsTargetType() {
        return EdmAnnotationsTarget.TargetType.EntityType;
    }
}

