/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmOperationImport;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.Target;
import org.apache.olingo.commons.core.edm.EdmNamedImpl;

public abstract class AbstractEdmOperationImport
extends EdmNamedImpl
implements EdmOperationImport {
    protected final EdmEntityContainer container;
    private final Target entitySet;
    private EdmEntitySet returnedEntitySet;

    public AbstractEdmOperationImport(Edm edm, EdmEntityContainer container, String name, Target entitySet) {
        super(edm, name);
        this.container = container;
        this.entitySet = entitySet;
    }

    public FullQualifiedName getFullQualifiedName() {
        return new FullQualifiedName(this.container.getNamespace(), this.getName());
    }

    public EdmEntitySet getReturnedEntitySet() {
        if (this.entitySet != null && this.returnedEntitySet == null) {
            EdmEntityContainer entityContainer = this.edm.getEntityContainer(this.entitySet.getEntityContainer());
            if (entityContainer == null) {
                throw new EdmException("Can\u00b4t find entity container with name: " + this.entitySet.getEntityContainer());
            }
            this.returnedEntitySet = entityContainer.getEntitySet(this.entitySet.getTargetName());
            if (this.returnedEntitySet == null) {
                throw new EdmException("Can\u00b4t find entity set with name: " + this.entitySet.getTargetName());
            }
        }
        return this.returnedEntitySet;
    }

    public EdmEntityContainer getEntityContainer() {
        return this.container;
    }

    public FullQualifiedName getAnnotationsTargetFQN() {
        return this.container.getFullQualifiedName();
    }

    public String getAnnotationsTargetPath() {
        return this.getName();
    }
}

