/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.data.Annotation;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntitySet;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.data.Valuable;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.core.serialization.JsonEntitySerializer;
import org.apache.olingo.commons.core.serialization.JsonSerializer;

public class JsonEntitySetSerializer
extends JsonSerializer {
    public JsonEntitySetSerializer(ODataServiceVersion version, boolean serverMode) {
        super(version, serverMode);
    }

    protected void doSerialize(EntitySet entitySet, JsonGenerator jgen) throws IOException, EdmPrimitiveTypeException {
        this.doContainerSerialize((ResWrap<EntitySet>)new ResWrap((URI)null, null, (Object)entitySet), jgen);
    }

    protected void doContainerSerialize(ResWrap<EntitySet> container, JsonGenerator jgen) throws IOException, EdmPrimitiveTypeException {
        EntitySet entitySet = (EntitySet)container.getPayload();
        jgen.writeStartObject();
        if (this.serverMode) {
            if (container.getContextURL() != null) {
                jgen.writeStringField(this.version.compareTo((Enum)ODataServiceVersion.V40) >= 0 ? "@odata.context" : "odata.metadata", container.getContextURL().toASCIIString());
            }
            if (this.version.compareTo((Enum)ODataServiceVersion.V40) >= 0 && StringUtils.isNotBlank((CharSequence)container.getMetadataETag())) {
                jgen.writeStringField("@odata.metadataEtag", container.getMetadataETag());
            }
        }
        if (entitySet.getId() != null) {
            jgen.writeStringField(this.version.getJsonName(ODataServiceVersion.JsonKey.ID), entitySet.getId().toASCIIString());
        }
        jgen.writeNumberField(this.version.getJsonName(ODataServiceVersion.JsonKey.COUNT), entitySet.getCount() == null ? entitySet.getEntities().size() : entitySet.getCount().intValue());
        if (this.serverMode) {
            if (entitySet.getNext() != null) {
                jgen.writeStringField(this.version.getJsonName(ODataServiceVersion.JsonKey.NEXT_LINK), entitySet.getNext().toASCIIString());
            }
            if (entitySet.getDeltaLink() != null) {
                jgen.writeStringField(this.version.getJsonName(ODataServiceVersion.JsonKey.DELTA_LINK), entitySet.getDeltaLink().toASCIIString());
            }
        }
        for (Annotation annotation : entitySet.getAnnotations()) {
            this.valuable(jgen, (Valuable)annotation, "@" + annotation.getTerm());
        }
        jgen.writeArrayFieldStart("value");
        JsonEntitySerializer entitySerializer = new JsonEntitySerializer(this.version, this.serverMode);
        for (Entity entity : entitySet.getEntities()) {
            entitySerializer.doSerialize(entity, jgen);
        }
        jgen.writeEndArray();
        jgen.writeEndObject();
    }
}

