/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.core.data.AnnotationImpl;
import org.apache.olingo.commons.core.data.PropertyImpl;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.commons.core.serialization.JsonDeserializer;

public class JsonPropertyDeserializer
extends JsonDeserializer {
    public JsonPropertyDeserializer(ODataServiceVersion version, boolean serverMode) {
        super(version, serverMode);
    }

    protected ResWrap<Property> doDeserialize(JsonParser parser) throws IOException {
        URI contextURL;
        String metadataETag;
        ObjectNode tree = (ObjectNode)parser.getCodec().readTree(parser);
        PropertyImpl property = new PropertyImpl();
        if (tree.hasNonNull("@odata.metadataEtag")) {
            metadataETag = tree.get("@odata.metadataEtag").textValue();
            tree.remove("@odata.metadataEtag");
        } else {
            metadataETag = null;
        }
        if (tree.hasNonNull("@odata.context")) {
            contextURL = URI.create(tree.get("@odata.context").textValue());
            property.setName(StringUtils.substringAfterLast((String)contextURL.toASCIIString(), (String)"/"));
            tree.remove("@odata.context");
        } else if (tree.hasNonNull("odata.metadata")) {
            contextURL = URI.create(tree.get("odata.metadata").textValue());
            property.setType(new EdmTypeInfo.Builder().setTypeExpression(StringUtils.substringAfterLast((String)contextURL.toASCIIString(), (String)"#")).build().internal());
            tree.remove("odata.metadata");
        } else {
            contextURL = null;
        }
        if (tree.has(this.jsonType)) {
            property.setType(new EdmTypeInfo.Builder().setTypeExpression(tree.get(this.jsonType).textValue()).build().internal());
            tree.remove(this.jsonType);
        }
        if (tree.has("odata.null") && tree.get("odata.null").asBoolean()) {
            property.setValue(ValueType.PRIMITIVE, null);
            tree.remove("odata.null");
        }
        if (property.getValue() == null) {
            try {
                this.value(property, (JsonNode)(tree.has("value") ? tree.get("value") : tree), parser.getCodec());
            }
            catch (EdmPrimitiveTypeException e) {
                throw new IOException(e);
            }
            tree.remove("value");
        }
        Iterator itor = tree.fields();
        while (itor.hasNext()) {
            Map.Entry field = (Map.Entry)itor.next();
            if (((String)field.getKey()).charAt(0) != '@') continue;
            AnnotationImpl annotation = new AnnotationImpl();
            annotation.setTerm(((String)field.getKey()).substring(1));
            try {
                this.value(annotation, (JsonNode)field.getValue(), parser.getCodec());
            }
            catch (EdmPrimitiveTypeException e) {
                throw new IOException(e);
            }
            property.getAnnotations().add(annotation);
        }
        return new ResWrap(contextURL, metadataETag, (Object)property);
    }
}

