/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer;

import java.io.InputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntitySet;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.ODataSerializerOptions;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.core.serializer.utils.CircleStreamBuffer;
import org.apache.olingo.server.core.serializer.utils.ContextURLHelper;
import org.apache.olingo.server.core.serializer.xml.MetadataDocumentXmlSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODataXmlSerializerImpl
implements ODataSerializer {
    private static final Logger log = LoggerFactory.getLogger(ODataXmlSerializerImpl.class);

    public InputStream serviceDocument(Edm edm, String serviceRoot) throws SerializerException {
        throw new SerializerException("Service Document not implemented for XML format", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
    }

    public InputStream metadataDocument(Edm edm) throws SerializerException {
        XMLStreamWriter xmlStreamWriter = null;
        try {
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(buffer.getOutputStream(), "UTF-8");
            MetadataDocumentXmlSerializer serializer = new MetadataDocumentXmlSerializer(edm);
            serializer.writeMetadataDocument(xmlStreamWriter);
            xmlStreamWriter.flush();
            xmlStreamWriter.close();
            InputStream inputStream = buffer.getInputStream();
            return inputStream;
        }
        catch (XMLStreamException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        finally {
            if (xmlStreamWriter != null) {
                try {
                    xmlStreamWriter.close();
                }
                catch (XMLStreamException e) {
                    throw new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                }
            }
        }
    }

    public InputStream entity(EdmEntitySet edmEntitySet, Entity entity, ODataSerializerOptions options) throws SerializerException {
        throw new SerializerException("Entity serialization not implemented for XML format", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
    }

    public InputStream entitySet(EdmEntitySet edmEntitySet, EntitySet entitySet, ODataSerializerOptions options) throws SerializerException {
        throw new SerializerException("Entityset serialization not implemented for XML format", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
    }

    public InputStream error(ODataServerError error) throws SerializerException {
        throw new SerializerException("error serialization not implemented for XML format", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
    }

    public String buildContextURLSelectList(EdmEntitySet edmEntitySet, ExpandOption expand, SelectOption select) throws SerializerException {
        return ContextURLHelper.buildSelectList(edmEntitySet.getEntityType(), expand, select);
    }

    public InputStream entityProperty(EdmProperty edmProperty, Property property, ODataSerializerOptions options) throws SerializerException {
        throw new SerializerException("error serialization not implemented for XML format", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
    }
}

