/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntitySet;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.LinkedComplexValue;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.domain.ODataError;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.ODataSerializerOptions;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.queryoption.ExpandItem;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.core.serializer.json.ODataErrorSerializer;
import org.apache.olingo.server.core.serializer.json.ServiceDocumentJsonSerializer;
import org.apache.olingo.server.core.serializer.utils.CircleStreamBuffer;
import org.apache.olingo.server.core.serializer.utils.ContextURLBuilder;
import org.apache.olingo.server.core.serializer.utils.ContextURLHelper;
import org.apache.olingo.server.core.serializer.utils.ExpandSelectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODataJsonSerializer
implements ODataSerializer {
    private static final Logger log = LoggerFactory.getLogger(ODataJsonSerializer.class);
    private final ODataFormat format;

    public ODataJsonSerializer(ODataFormat format) {
        this.format = format;
    }

    public InputStream serviceDocument(Edm edm, String serviceRoot) throws SerializerException {
        JsonGenerator gen = null;
        try {
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            gen = new JsonFactory().createGenerator(buffer.getOutputStream()).setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
            new ServiceDocumentJsonSerializer(edm, serviceRoot).writeServiceDocument(gen);
            gen.close();
            InputStream inputStream = buffer.getInputStream();
            return inputStream;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        finally {
            if (gen != null) {
                try {
                    gen.close();
                }
                catch (IOException e) {
                    throw new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                }
            }
        }
    }

    public InputStream metadataDocument(Edm edm) throws SerializerException {
        throw new SerializerException("Metadata in JSON format not supported!", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.JSON_METADATA, new String[0]);
    }

    public InputStream error(ODataServerError error) throws SerializerException {
        CircleStreamBuffer buffer = new CircleStreamBuffer();
        try {
            JsonGenerator json = new JsonFactory().createGenerator(buffer.getOutputStream());
            new ODataErrorSerializer().writeErrorDocument(json, (ODataError)error);
            json.close();
        }
        catch (IOException e) {
            throw new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        return buffer.getInputStream();
    }

    public InputStream entitySet(EdmEntitySet edmEntitySet, EntitySet entitySet, ODataSerializerOptions options) throws SerializerException {
        CircleStreamBuffer buffer = new CircleStreamBuffer();
        try {
            JsonGenerator json = new JsonFactory().createGenerator(buffer.getOutputStream());
            json.writeStartObject();
            ContextURL contextURL = this.checkContextURL(options);
            if (contextURL != null) {
                json.writeStringField("@odata.context", ContextURLBuilder.create(contextURL).toASCIIString());
            }
            if (options != null && options.getCount() != null && options.getCount().getValue() && entitySet.getCount() != null) {
                json.writeNumberField("@odata.count", entitySet.getCount().intValue());
            }
            json.writeFieldName("value");
            this.writeEntitySet(edmEntitySet.getEntityType(), entitySet, options == null ? null : options.getExpand(), options == null ? null : options.getSelect(), json);
            if (entitySet.getNext() != null) {
                json.writeStringField("@odata.nextLink", entitySet.getNext().toASCIIString());
            }
            json.close();
        }
        catch (IOException e) {
            throw new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        return buffer.getInputStream();
    }

    public InputStream entity(EdmEntitySet edmEntitySet, Entity entity, ODataSerializerOptions options) throws SerializerException {
        ContextURL contextURL = this.checkContextURL(options);
        CircleStreamBuffer buffer = new CircleStreamBuffer();
        try {
            JsonGenerator json = new JsonFactory().createGenerator(buffer.getOutputStream());
            this.writeEntity(edmEntitySet.getEntityType(), entity, contextURL, options == null ? null : options.getExpand(), options == null ? null : options.getSelect(), json);
            json.close();
        }
        catch (IOException e) {
            throw new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        return buffer.getInputStream();
    }

    private ContextURL checkContextURL(ODataSerializerOptions options) throws SerializerException {
        ContextURL contextURL;
        ContextURL contextURL2 = contextURL = options == null ? null : options.getContextURL();
        if (this.format != ODataFormat.JSON_NO_METADATA && contextURL == null) {
            throw new SerializerException("ContextURL null!", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.NO_CONTEXT_URL, new String[0]);
        }
        if (this.format == ODataFormat.JSON_NO_METADATA) {
            contextURL = null;
        }
        return contextURL;
    }

    protected void writeEntitySet(EdmEntityType entityType, EntitySet entitySet, ExpandOption expand, SelectOption select, JsonGenerator json) throws IOException, SerializerException {
        json.writeStartArray();
        for (Entity entity : entitySet.getEntities()) {
            this.writeEntity(entityType, entity, null, expand, select, json);
        }
        json.writeEndArray();
    }

    protected void writeEntity(EdmEntityType entityType, Entity entity, ContextURL contextURL, ExpandOption expand, SelectOption select, JsonGenerator json) throws IOException, SerializerException {
        json.writeStartObject();
        if (this.format != ODataFormat.JSON_NO_METADATA) {
            if (contextURL != null) {
                json.writeStringField("@odata.context", ContextURLBuilder.create(contextURL).toASCIIString());
            }
            if (entity.getETag() != null) {
                json.writeStringField("@odata.etag", entity.getETag());
            }
            if (entityType.hasStream()) {
                if (entity.getMediaETag() != null) {
                    json.writeStringField("@odata.mediaEtag", entity.getMediaETag());
                }
                if (entity.getMediaContentType() != null) {
                    json.writeStringField("@odata.mediaContentType", entity.getMediaContentType());
                }
            }
        }
        this.writeProperties(entityType, entity, select, json);
        this.writeNavigationProperties(entityType, entity, expand, json);
        json.writeEndObject();
    }

    protected void writeProperties(EdmEntityType entityType, Entity entity, SelectOption select, JsonGenerator json) throws IOException, SerializerException {
        boolean all = ExpandSelectHelper.isAll(select);
        Set<String> selected = all ? null : ExpandSelectHelper.getSelectedPropertyNames(select.getSelectItems());
        for (String propertyName : entityType.getPropertyNames()) {
            if (!all && !selected.contains(propertyName)) continue;
            EdmProperty edmProperty = entityType.getStructuralProperty(propertyName);
            Property property = entity.getProperty(propertyName);
            Set<List<String>> selectedPaths = all || edmProperty.isPrimitive() ? null : ExpandSelectHelper.getSelectedPaths(select.getSelectItems(), propertyName);
            this.writeProperty(edmProperty, property, selectedPaths, json);
        }
    }

    protected void writeNavigationProperties(EdmEntityType entityType, Entity entity, ExpandOption expand, JsonGenerator json) throws SerializerException, IOException {
        if (ExpandSelectHelper.hasExpand(expand)) {
            boolean expandAll = ExpandSelectHelper.isExpandAll(expand);
            Set<String> expanded = expandAll ? null : ExpandSelectHelper.getExpandedPropertyNames(expand.getExpandItems());
            for (String propertyName : entityType.getNavigationPropertyNames()) {
                ExpandItem innerOptions;
                if (!expandAll && !expanded.contains(propertyName)) continue;
                EdmNavigationProperty property = entityType.getNavigationProperty(propertyName);
                Link navigationLink = entity.getNavigationLink(property.getName());
                ExpandItem expandItem = innerOptions = expandAll ? null : ExpandSelectHelper.getExpandItem(expand.getExpandItems(), propertyName);
                if (innerOptions != null && (innerOptions.isRef() || innerOptions.getLevelsOption() != null)) {
                    throw new SerializerException("Expand options $ref and $levels are not supported.", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
                }
                this.writeExpandedNavigationProperty(property, navigationLink, innerOptions == null ? null : innerOptions.getExpandOption(), innerOptions == null ? null : innerOptions.getSelectOption(), json);
            }
        }
    }

    protected void writeExpandedNavigationProperty(EdmNavigationProperty property, Link navigationLink, ExpandOption innerExpand, SelectOption innerSelect, JsonGenerator json) throws IOException, SerializerException {
        json.writeFieldName(property.getName());
        if (property.isCollection()) {
            if (navigationLink == null || navigationLink.getInlineEntitySet() == null) {
                json.writeStartArray();
                json.writeEndArray();
            } else {
                this.writeEntitySet(property.getType(), navigationLink.getInlineEntitySet(), innerExpand, innerSelect, json);
            }
        } else if (navigationLink == null || navigationLink.getInlineEntity() == null) {
            json.writeNull();
        } else {
            this.writeEntity(property.getType(), navigationLink.getInlineEntity(), null, innerExpand, innerSelect, json);
        }
    }

    protected void writeProperty(EdmProperty edmProperty, Property property, Set<List<String>> selectedPaths, JsonGenerator json) throws IOException, SerializerException {
        json.writeFieldName(edmProperty.getName());
        if (property == null || property.isNull()) {
            if (edmProperty.isNullable() == Boolean.FALSE) {
                throw new SerializerException("Non-nullable property not present!", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.MISSING_PROPERTY, new String[]{edmProperty.getName()});
            }
            json.writeNull();
        } else {
            this.writePropertyValue(edmProperty, property, selectedPaths, json);
        }
    }

    private void writePropertyValue(EdmProperty edmProperty, Property property, Set<List<String>> selectedPaths, JsonGenerator json) throws IOException, SerializerException {
        block6: {
            try {
                if (edmProperty.isCollection()) {
                    this.writeCollection(edmProperty, property, selectedPaths, json);
                    break block6;
                }
                if (edmProperty.isPrimitive()) {
                    this.writePrimitive(edmProperty, property, json);
                    break block6;
                }
                if (property.isLinkedComplex()) {
                    this.writeComplexValue(edmProperty, property.asLinkedComplex().getValue(), selectedPaths, json);
                    break block6;
                }
                if (property.isComplex()) {
                    this.writeComplexValue(edmProperty, property.asComplex(), selectedPaths, json);
                    break block6;
                }
                throw new SerializerException("Property type not yet supported!", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, new String[]{edmProperty.getName()});
            }
            catch (EdmPrimitiveTypeException e) {
                throw new SerializerException("Wrong value for property!", (Throwable)e, (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.WRONG_PROPERTY_VALUE, new String[]{edmProperty.getName(), property.getValue().toString()});
            }
        }
    }

    private void writeCollection(EdmProperty edmProperty, Property property, Set<List<String>> selectedPaths, JsonGenerator json) throws IOException, EdmPrimitiveTypeException, SerializerException {
        json.writeStartArray();
        block7: for (Object value : property.asCollection()) {
            switch (property.getValueType()) {
                case COLLECTION_PRIMITIVE: {
                    this.writePrimitiveValue(edmProperty, value, json);
                    continue block7;
                }
                case COLLECTION_GEOSPATIAL: {
                    throw new SerializerException("Property type not yet supported!", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, new String[]{edmProperty.getName()});
                }
                case COLLECTION_ENUM: {
                    json.writeString(value.toString());
                    continue block7;
                }
                case COLLECTION_LINKED_COMPLEX: {
                    this.writeComplexValue(edmProperty, ((LinkedComplexValue)value).getValue(), selectedPaths, json);
                    continue block7;
                }
                case COLLECTION_COMPLEX: {
                    this.writeComplexValue(edmProperty, property.asComplex(), selectedPaths, json);
                    continue block7;
                }
            }
            throw new SerializerException("Property type not yet supported!", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, new String[]{edmProperty.getName()});
        }
        json.writeEndArray();
    }

    private void writePrimitive(EdmProperty edmProperty, Property property, JsonGenerator json) throws EdmPrimitiveTypeException, IOException, SerializerException {
        if (property.isPrimitive()) {
            this.writePrimitiveValue(edmProperty, property.asPrimitive(), json);
        } else {
            if (property.isGeospatial()) {
                throw new SerializerException("Property type not yet supported!", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, new String[]{edmProperty.getName()});
            }
            if (property.isEnum()) {
                this.writePrimitiveValue(edmProperty, property.asEnum(), json);
            } else {
                throw new SerializerException("Inconsistent property type!", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.INCONSISTENT_PROPERTY_TYPE, new String[]{edmProperty.getName()});
            }
        }
    }

    protected void writePrimitiveValue(EdmProperty edmProperty, Object primitiveValue, JsonGenerator json) throws EdmPrimitiveTypeException, IOException {
        EdmPrimitiveType type = (EdmPrimitiveType)edmProperty.getType();
        String value = type.valueToString(primitiveValue, edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode());
        if (type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Boolean)) {
            json.writeBoolean(Boolean.parseBoolean(value));
        } else if (type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Byte) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Decimal) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Double) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Int16) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Int32) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Int64) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.SByte) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Single)) {
            json.writeNumber(value);
        } else {
            json.writeString(value);
        }
    }

    protected void writeComplexValue(EdmProperty edmProperty, List<Property> properties, Set<List<String>> selectedPaths, JsonGenerator json) throws IOException, EdmPrimitiveTypeException, SerializerException {
        json.writeStartObject();
        this.writePropertyValues(edmProperty, properties, selectedPaths, json);
        json.writeEndObject();
    }

    private void writePropertyValues(EdmProperty edmProperty, List<Property> properties, Set<List<String>> selectedPaths, JsonGenerator json) throws IOException, SerializerException {
        EdmComplexType type = (EdmComplexType)edmProperty.getType();
        for (String propertyName : type.getPropertyNames()) {
            Property property = this.findProperty(propertyName, properties);
            if (selectedPaths != null && !ExpandSelectHelper.isSelected(selectedPaths, propertyName)) continue;
            this.writeProperty((EdmProperty)type.getProperty(propertyName), property, selectedPaths == null ? null : ExpandSelectHelper.getReducedSelectedPaths(selectedPaths, propertyName), json);
        }
    }

    private Property findProperty(String propertyName, List<Property> properties) {
        for (Property property : properties) {
            if (!propertyName.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    public String buildContextURLSelectList(EdmEntitySet edmEntitySet, ExpandOption expand, SelectOption select) throws SerializerException {
        return ContextURLHelper.buildSelectList(edmEntitySet.getEntityType(), expand, select);
    }

    public InputStream entityProperty(EdmProperty edmProperty, Property property, ODataSerializerOptions options) throws SerializerException {
        ContextURL contextURL = this.checkContextURL(options);
        CircleStreamBuffer buffer = new CircleStreamBuffer();
        try {
            JsonGenerator json = new JsonFactory().createGenerator(buffer.getOutputStream());
            json.writeStartObject();
            if (this.format != ODataFormat.JSON_NO_METADATA && contextURL != null) {
                json.writeStringField("@odata.context", ContextURLBuilder.create(contextURL).toASCIIString());
            }
            if (property.isPrimitive() && property.isNull()) {
                throw new SerializerException("Property value can not be null", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.NULL_INPUT, new String[0]);
            }
            if (property.isComplex() && !property.isNull()) {
                this.writePropertyValues(edmProperty, property.asComplex(), null, json);
            } else if (property.isLinkedComplex() && !property.isNull()) {
                this.writePropertyValues(edmProperty, property.asLinkedComplex().getValue(), null, json);
            } else {
                json.writeFieldName("value");
                this.writePropertyValue(edmProperty, property, null, json);
            }
            json.writeEndObject();
            json.close();
        }
        catch (IOException e) {
            throw new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        return buffer.getInputStream();
    }
}

