/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.PreparedStatementImpl;
import org.teiid.jdbc.ResultSetImpl;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.logging.LogManager;
import org.teiid.metadata.MetadataStore;
import org.teiid.odbc.ODBCServerRemoteImpl;
import org.teiid.olingo.BaseResponse;
import org.teiid.olingo.Client;
import org.teiid.olingo.CountResponse;
import org.teiid.olingo.ODataPlugin;
import org.teiid.olingo.QueryResponse;
import org.teiid.olingo.SQLParam;
import org.teiid.olingo.UpdateResponse;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Query;
import org.teiid.translator.CacheDirective;
import org.teiid.transport.LocalServerConnection;

public class LocalClient
implements Client {
    private static final String BATCH_SIZE = "batch-size";
    private static final String SKIPTOKEN_TIME = "skiptoken-cache-time";
    static final String INVALID_CHARACTER_REPLACEMENT = "invalid-xml10-character-replacement";
    private volatile VDBMetaData vdb;
    private final String vdbName;
    private final int vdbVersion;
    private final int batchSize;
    private final long cacheTime;
    private final String connectionString;
    private final Properties connectionProperties = new Properties();
    private final Properties initProperties;
    private TeiidDriver driver = TeiidDriver.getInstance();

    public LocalClient(String vdbName, int vdbVersion, Properties props) {
        this.vdbName = vdbName;
        this.vdbVersion = vdbVersion;
        this.batchSize = PropertiesUtils.getIntProperty((Properties)props, (String)BATCH_SIZE, (int)256);
        this.cacheTime = PropertiesUtils.getLongProperty((Properties)props, (String)SKIPTOKEN_TIME, (long)300000L);
        StringBuilder sb = new StringBuilder();
        sb.append("jdbc:teiid:").append(this.vdbName).append(".").append(this.vdbVersion).append(";");
        this.initProperties = props;
        this.connectionProperties.put("PassthroughAuthentication", "true");
        this.connectionProperties.put("transportName", props.getProperty("transportName", "odata"));
        this.connectionProperties.put("waitForLoad", "0");
        this.connectionString = sb.toString();
    }

    @Override
    public VDBMetaData getVDB() {
        ConnectionImpl connection = null;
        if (this.vdb == null) {
            try {
                connection = this.getConnection();
                LocalServerConnection lsc = (LocalServerConnection)connection.getServerConnection();
                VDBMetaData vdb = lsc.getWorkContext().getVDB();
                if (vdb == null) {
                    throw new TeiidRuntimeException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16001, new Object[]{this.vdbName, this.vdbVersion}));
                }
                this.vdb = vdb;
            }
            catch (SQLException e) {
                throw new TeiidRuntimeException((Throwable)e);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {}
                }
            }
        }
        return this.vdb;
    }

    public void setDriver(TeiidDriver driver) {
        this.driver = driver;
    }

    ConnectionImpl getConnection() throws SQLException {
        ConnectionImpl connection = this.driver.connect(this.connectionString, this.connectionProperties);
        ODBCServerRemoteImpl.setConnectionProperties((ConnectionImpl)connection);
        ODBCServerRemoteImpl.setConnectionProperties((ConnectionImpl)connection, (Properties)this.initProperties);
        return connection;
    }

    @Override
    public BaseResponse executeCall(String sql, List<SQLParam> parameters, SingletonPrimitiveType returnType) {
        Object connection = null;
        return null;
    }

    @Override
    public MetadataStore getMetadataStore() {
        return ((TransformationMetadata)this.getVDB().getAttachment(TransformationMetadata.class)).getMetadataStore();
    }

    @Override
    public void executeSQL(Query query, List<SQLParam> parameters, boolean countQuery, Integer skipOption, Integer topOption, QueryResponse respose) {
        Connection connection = null;
        try {
            boolean cache;
            boolean bl = cache = this.batchSize > 0;
            if (cache) {
                CacheHint hint = new CacheHint();
                hint.setTtl(Long.valueOf(this.cacheTime));
                hint.setScope(CacheDirective.Scope.USER);
                query.setCacheHint(hint);
            }
            String sql = query.toString();
            LogManager.logDetail((String)"org.teiid.ODATA", (Object)"Teiid-Query:", (Object)sql);
            connection = this.getConnection();
            PreparedStatement stmt = connection.prepareStatement(sql, cache ? 1004 : 1003, 1007);
            if (parameters != null && !parameters.isEmpty()) {
                for (int i = 0; i < parameters.size(); ++i) {
                    stmt.setObject(i + 1, parameters.get((int)i).value, parameters.get((int)i).sqlType);
                }
            }
            ResultSet rs = stmt.executeQuery();
            int count = 0;
            int skipSize = 0;
            if (countQuery && skipOption != null) {
                skipSize = skipOption;
            }
            if (skipOption != null) {
                skipSize += skipOption.intValue();
            }
            if (skipSize > 0) {
                count += this.skip(cache, rs, skipSize);
            }
            int size = this.batchSize;
            int top = Integer.MAX_VALUE;
            if (countQuery && topOption != null) {
                size = top = topOption.intValue();
                if (this.batchSize > 0) {
                    size = Math.min(this.batchSize, size);
                }
            } else if (size < 1) {
                size = Integer.MAX_VALUE;
            }
            for (int i = 0; i < size && rs.next(); ++i) {
                ++count;
                respose.addRow(rs);
            }
            if (countQuery) {
                if (!cache) {
                    while (rs.next()) {
                        ++count;
                    }
                } else {
                    rs.last();
                    count = rs.getRow();
                }
            }
            respose.setCount(count);
            if (cache && respose.size() == (long)this.batchSize) {
                long end = (long)skipSize + respose.size();
                if (countQuery) {
                    if (end < (long)Math.min(top, count)) {
                        respose.setNext(end);
                    }
                } else if (rs.next()) {
                    respose.setNext(end);
                    rs.last();
                }
            }
        }
        catch (Exception e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    private int skip(boolean cache, ResultSet rs, int skipSize) throws SQLException {
        int skipped = 0;
        if (!cache) {
            for (int i = 0; i < skipSize; ++i) {
                ++skipped;
                if (rs.next()) {
                    continue;
                }
                break;
            }
        } else {
            rs.absolute(skipSize);
        }
        return skipped;
    }

    @Override
    public CountResponse executeCount(Query query, List<SQLParam> parameters) {
        ConnectionImpl connection = null;
        try {
            String sql = query.toString();
            LogManager.logDetail((String)"org.teiid.ODATA", (Object)"Teiid-Query:", (Object)sql);
            connection = this.getConnection();
            PreparedStatementImpl stmt = connection.prepareStatement(sql);
            if (!parameters.isEmpty()) {
                for (int i = 0; i < parameters.size(); ++i) {
                    stmt.setObject(i + 1, parameters.get((int)i).value, parameters.get((int)i).sqlType.intValue());
                }
            }
            ResultSetImpl rs = stmt.executeQuery();
            rs.next();
            final int count = rs.getInt(1);
            rs.close();
            stmt.close();
            CountResponse countResponse = new CountResponse(){

                @Override
                public long getCount() {
                    return count;
                }
            };
            return countResponse;
        }
        catch (Exception e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    @Override
    public UpdateResponse executeUpdate(Command query, List<SQLParam> parameters) {
        ConnectionImpl connection = null;
        try {
            String sql = query.toString();
            LogManager.logDetail((String)"org.teiid.ODATA", (Object)"Teiid-Query:", (Object)sql);
            connection = this.getConnection();
            PreparedStatementImpl stmt = connection.prepareStatement(sql, 1003, 1007, 1, 1);
            if (!parameters.isEmpty()) {
                for (int i = 0; i < parameters.size(); ++i) {
                    stmt.setObject(i + 1, parameters.get((int)i).value, parameters.get((int)i).sqlType.intValue());
                }
            }
            final int count = stmt.executeUpdate();
            final Map<String, Object> keys = this.getGeneratedKeys(stmt.getGeneratedKeys());
            stmt.close();
            UpdateResponse updateResponse = new UpdateResponse(){

                @Override
                public Map<String, Object> getGeneratedKeys() {
                    return keys;
                }

                @Override
                public int getUpdateCount() {
                    return count;
                }
            };
            return updateResponse;
        }
        catch (Exception e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    private Map<String, Object> getGeneratedKeys(ResultSet result) throws SQLException {
        if (result == null) {
            return null;
        }
        HashMap<String, Object> keys = new HashMap<String, Object>();
        ResultSetMetaData metadata = result.getMetaData();
        while (result.next()) {
            for (int i = 0; i < metadata.getColumnCount(); ++i) {
                String label = metadata.getColumnLabel(i + 1);
                keys.put(label, result.getObject(i + 1));
            }
        }
        return keys;
    }

    @Override
    public String getProperty(String name) {
        return this.initProperties.getProperty(name);
    }
}

