/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo;

import java.util.HashMap;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.core.edm.primitivetype.EdmBinary;
import org.apache.olingo.commons.core.edm.primitivetype.EdmBoolean;
import org.apache.olingo.commons.core.edm.primitivetype.EdmByte;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDate;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDateTime;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDateTimeOffset;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDecimal;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDouble;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDuration;
import org.apache.olingo.commons.core.edm.primitivetype.EdmGuid;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt16;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt32;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt64;
import org.apache.olingo.commons.core.edm.primitivetype.EdmSByte;
import org.apache.olingo.commons.core.edm.primitivetype.EdmSingle;
import org.apache.olingo.commons.core.edm.primitivetype.EdmStream;
import org.apache.olingo.commons.core.edm.primitivetype.EdmString;
import org.apache.olingo.commons.core.edm.primitivetype.EdmTimeOfDay;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;
import org.teiid.core.types.DataTypeManager;

public class ODataTypeManager {
    private static HashMap<String, EdmPrimitiveTypeKind> teiidkeyed = new HashMap();
    private static HashMap<EdmPrimitiveTypeKind, String> odatakeyed = new HashMap();

    public static String teiidType(EdmPrimitiveTypeKind odataType) {
        return odatakeyed.get(odataType);
    }

    public static EdmPrimitiveTypeKind odataType(String teiidType) {
        if (DataTypeManager.isArrayType((String)teiidType)) {
            return ODataTypeManager.odataType(DataTypeManager.getComponentType((String)teiidType));
        }
        return teiidkeyed.get(teiidType);
    }

    public static String teiidType(SingletonPrimitiveType type) {
        if (type instanceof EdmBinary) {
            return odatakeyed.get(EdmPrimitiveTypeKind.Binary);
        }
        if (type instanceof EdmBoolean) {
            return odatakeyed.get(EdmPrimitiveTypeKind.Boolean);
        }
        if (type instanceof EdmByte) {
            return odatakeyed.get(EdmPrimitiveTypeKind.Byte);
        }
        if (type instanceof EdmDate) {
            return odatakeyed.get(EdmPrimitiveTypeKind.Date);
        }
        if (type instanceof EdmDateTime) {
            return odatakeyed.get(EdmPrimitiveTypeKind.DateTime);
        }
        if (type instanceof EdmDateTimeOffset) {
            return odatakeyed.get(EdmPrimitiveTypeKind.DateTime);
        }
        if (type instanceof EdmDecimal) {
            return odatakeyed.get(EdmPrimitiveTypeKind.Decimal);
        }
        if (type instanceof EdmDouble) {
            return odatakeyed.get(EdmPrimitiveTypeKind.Double);
        }
        if (type instanceof EdmDuration) {
            return odatakeyed.get(EdmPrimitiveTypeKind.Int32);
        }
        if (type instanceof EdmGuid) {
            return odatakeyed.get(EdmPrimitiveTypeKind.String);
        }
        if (type instanceof EdmInt16) {
            return odatakeyed.get(EdmPrimitiveTypeKind.Int16);
        }
        if (type instanceof EdmInt32) {
            return odatakeyed.get(EdmPrimitiveTypeKind.Int32);
        }
        if (type instanceof EdmInt64) {
            return odatakeyed.get(EdmPrimitiveTypeKind.Int64);
        }
        if (type instanceof EdmSByte) {
            return odatakeyed.get(EdmPrimitiveTypeKind.SByte);
        }
        if (type instanceof EdmSingle) {
            return odatakeyed.get(EdmPrimitiveTypeKind.Single);
        }
        if (type instanceof EdmStream) {
            return odatakeyed.get(EdmPrimitiveTypeKind.Stream);
        }
        if (type instanceof EdmString) {
            return odatakeyed.get(EdmPrimitiveTypeKind.String);
        }
        if (type instanceof EdmTimeOfDay) {
            return odatakeyed.get(EdmPrimitiveTypeKind.Time);
        }
        return null;
    }

    static {
        teiidkeyed.put("string", EdmPrimitiveTypeKind.String);
        teiidkeyed.put("boolean", EdmPrimitiveTypeKind.Boolean);
        teiidkeyed.put("byte", EdmPrimitiveTypeKind.Byte);
        teiidkeyed.put("short", EdmPrimitiveTypeKind.Int16);
        teiidkeyed.put("char", EdmPrimitiveTypeKind.String);
        teiidkeyed.put("integer", EdmPrimitiveTypeKind.Int32);
        teiidkeyed.put("long", EdmPrimitiveTypeKind.Int64);
        teiidkeyed.put("biginteger", EdmPrimitiveTypeKind.Int64);
        teiidkeyed.put("float", EdmPrimitiveTypeKind.Single);
        teiidkeyed.put("double", EdmPrimitiveTypeKind.Double);
        teiidkeyed.put("bigdecimal", EdmPrimitiveTypeKind.Decimal);
        teiidkeyed.put("date", EdmPrimitiveTypeKind.Date);
        teiidkeyed.put("time", EdmPrimitiveTypeKind.Time);
        teiidkeyed.put("timestamp", EdmPrimitiveTypeKind.DateTime);
        teiidkeyed.put("object", EdmPrimitiveTypeKind.Stream);
        teiidkeyed.put("blob", EdmPrimitiveTypeKind.Stream);
        teiidkeyed.put("clob", EdmPrimitiveTypeKind.Stream);
        teiidkeyed.put("xml", EdmPrimitiveTypeKind.Stream);
        teiidkeyed.put("varbinary", EdmPrimitiveTypeKind.Stream);
        odatakeyed.put(EdmPrimitiveTypeKind.String, "string");
        odatakeyed.put(EdmPrimitiveTypeKind.Boolean, "boolean");
        odatakeyed.put(EdmPrimitiveTypeKind.Byte, "short");
        odatakeyed.put(EdmPrimitiveTypeKind.SByte, "byte");
        odatakeyed.put(EdmPrimitiveTypeKind.Int16, "short");
        odatakeyed.put(EdmPrimitiveTypeKind.Int32, "integer");
        odatakeyed.put(EdmPrimitiveTypeKind.Int64, "long");
        odatakeyed.put(EdmPrimitiveTypeKind.Single, "float");
        odatakeyed.put(EdmPrimitiveTypeKind.Double, "double");
        odatakeyed.put(EdmPrimitiveTypeKind.Decimal, "bigdecimal");
        odatakeyed.put(EdmPrimitiveTypeKind.Date, "date");
        odatakeyed.put(EdmPrimitiveTypeKind.Time, "time");
        odatakeyed.put(EdmPrimitiveTypeKind.DateTime, "timestamp");
        odatakeyed.put(EdmPrimitiveTypeKind.Stream, "blob");
        odatakeyed.put(EdmPrimitiveTypeKind.Guid, "string");
        odatakeyed.put(EdmPrimitiveTypeKind.Binary, "byte[]");
    }
}

