/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.service.buffer;

import junit.framework.TestCase;
import org.teiid.common.buffer.impl.BufferManagerImpl;
import org.teiid.common.buffer.impl.FileStorageManager;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.services.BufferServiceImpl;

public class TestLocalBufferService
extends TestCase {
    public TestLocalBufferService(String name) {
        super(name);
    }

    public void testMissingRequiredProperties() throws Exception {
        BufferServiceImpl svc = new BufferServiceImpl();
        svc.setDiskDirectory(UnitTestUtil.getTestScratchPath() + "/teiid");
        TestLocalBufferService.assertTrue((svc.getBufferDirectory().isDirectory() && svc.getBufferDirectory().exists() ? 1 : 0) != 0);
        TestLocalBufferService.assertTrue((boolean)svc.isUseDisk());
    }

    public void testCheckMemPropertyGotSet() throws Exception {
        BufferServiceImpl svc = new BufferServiceImpl();
        svc.setDiskDirectory(UnitTestUtil.getTestScratchPath() + "/teiid/1");
        svc.setUseDisk(true);
        svc.start();
        TestLocalBufferService.assertTrue((String)"Not Directory", (boolean)svc.getBufferDirectory().isDirectory());
        TestLocalBufferService.assertTrue((String)"does not exist", (boolean)svc.getBufferDirectory().exists());
        TestLocalBufferService.assertTrue((String)"does not end with one", (boolean)svc.getBufferDirectory().getParent().endsWith("1"));
        TestLocalBufferService.assertTrue((boolean)svc.isUseDisk());
        BufferManagerImpl mgr = (BufferManagerImpl)svc.getBufferManager();
        TestLocalBufferService.assertTrue((boolean)((FileStorageManager)mgr.getStorageManager()).getDirectory().endsWith(svc.getBufferDirectory().getName()));
    }

    public void testCheckMemPropertyGotSet2() throws Exception {
        BufferServiceImpl svc = new BufferServiceImpl();
        svc.setDiskDirectory(UnitTestUtil.getTestScratchPath() + "/teiid/1");
        svc.setUseDisk(false);
        svc.start();
        TestLocalBufferService.assertFalse((boolean)svc.isUseDisk());
    }
}

