/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.services;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.teiid.security.Credentials;
import org.teiid.security.SecurityHelper;
import org.teiid.services.TeiidLoginContext;

public class TestMembershipServiceImpl
extends TestCase {
    public void testBaseUsername() throws Exception {
        TestMembershipServiceImpl.assertEquals((String)"foo@bar.com", (String)TeiidLoginContext.getBaseUsername((String)"foo\\@bar.com@foo"));
        TestMembershipServiceImpl.assertEquals((String)"foo", (String)TeiidLoginContext.getDomainName((String)"me\\@bar.com@foo"));
        TestMembershipServiceImpl.assertEquals(null, (String)TeiidLoginContext.getDomainName((String)"@"));
        TestMembershipServiceImpl.assertEquals((String)"@", (String)TeiidLoginContext.getBaseUsername((String)"@"));
    }

    private TeiidLoginContext createMembershipService() throws Exception {
        Principal p = (Principal)Mockito.mock(Principal.class);
        Mockito.stub((Object)p.getName()).toReturn((Object)"alreadylogged");
        HashSet<Principal> principals = new HashSet<Principal>();
        principals.add(p);
        Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
        SecurityHelper sh = (SecurityHelper)Mockito.mock(SecurityHelper.class);
        Mockito.stub((Object)sh.getSubjectInContext("passthrough")).toReturn((Object)subject);
        TeiidLoginContext membershipService = new TeiidLoginContext(sh){

            public LoginContext createLoginContext(String domain, CallbackHandler handler) throws LoginException {
                LoginContext context = (LoginContext)Mockito.mock(LoginContext.class);
                return context;
            }

            protected LoginContext createLoginContext(String domain, Subject subject) throws LoginException {
                LoginContext context = (LoginContext)Mockito.mock(LoginContext.class);
                return context;
            }
        };
        return membershipService;
    }

    public void testAuthenticate() throws Exception {
        TeiidLoginContext ms = this.createMembershipService();
        ArrayList<String> domains = new ArrayList<String>();
        domains.add("testFile");
        ms.authenticateUser("user1", new Credentials("pass1".toCharArray()), null, domains, false);
        ((LoginContext)Mockito.verify((Object)ms.getLoginContext())).login();
        TestMembershipServiceImpl.assertEquals((String)"user1@testFile", (String)ms.getUserName());
    }

    public void testPassThrough() throws Exception {
        TeiidLoginContext ms = this.createMembershipService();
        ArrayList<String> domains = new ArrayList<String>();
        domains.add("passthrough");
        ms.authenticateUser("user1", new Credentials("pass1".toCharArray()), null, domains, true);
        TestMembershipServiceImpl.assertEquals((String)"alreadylogged@passthrough", (String)ms.getUserName());
    }
}

