/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.concurrent.ConcurrentSkipListMap;
import org.jboss.deployers.spi.DeploymentException;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.types.DataTypeManager;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.MetadataStoreGroup;
import org.teiid.deployers.PgCatalogMetadataStore;
import org.teiid.deployers.UDFMetaData;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.logging.LogManager;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.MetadataStore;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.translator.TranslatorException;
import org.teiid.vdb.runtime.VDBKey;

public class VDBRepository
implements Serializable {
    private static final long serialVersionUID = 312177538191772674L;
    private NavigableMap<VDBKey, CompositeVDB> vdbRepo = new ConcurrentSkipListMap<VDBKey, CompositeVDB>();
    private MetadataStore systemStore;
    private MetadataStore odbcStore;
    private boolean odbcEnabled = false;

    public void addVDB(VDBMetaData vdb, MetadataStoreGroup stores, LinkedHashMap<String, TransformationMetadata.Resource> visibilityMap, UDFMetaData udf, ConnectorManagerRepository cmr) throws DeploymentException {
        if (this.getVDB(vdb.getName(), vdb.getVersion()) != null) {
            throw new DeploymentException(RuntimePlugin.Util.getString("duplicate_vdb", new Object[]{vdb.getName(), vdb.getVersion()}));
        }
        if (this.systemStore == null) {
            throw new DeploymentException(RuntimePlugin.Util.getString("system_vdb_load_error"));
        }
        if (this.odbcEnabled && this.odbcStore == null) {
            this.odbcStore = this.getODBCMetadataStore();
        }
        if (this.odbcStore == null) {
            this.addSystemModel(vdb);
            this.vdbRepo.put(this.vdbId(vdb), new CompositeVDB(vdb, stores, visibilityMap, udf, cmr, this.systemStore));
        } else {
            this.addSystemModel(vdb);
            this.addODBCModel(vdb);
            this.vdbRepo.put(this.vdbId(vdb), new CompositeVDB(vdb, stores, visibilityMap, udf, cmr, this.systemStore, this.odbcStore));
        }
    }

    private void addODBCModel(VDBMetaData vdb) {
        ModelMetaData odbcSystem = new ModelMetaData();
        odbcSystem.setName("pg_catalog");
        odbcSystem.setVisible(Boolean.valueOf(true));
        odbcSystem.setModelType(Model.Type.VIRTUAL);
        vdb.addModel(odbcSystem);
    }

    private void addSystemModel(VDBMetaData vdb) {
        ModelMetaData system = new ModelMetaData();
        system.setName("SYS");
        system.setVisible(Boolean.valueOf(true));
        system.setModelType(Model.Type.PHYSICAL);
        system.addSourceMapping("SYS", "SYS", "SYS");
        system.setSupportsMultiSourceBindings(false);
        vdb.addModel(system);
    }

    public VDBMetaData getVDB(String name, int version) {
        CompositeVDB v = (CompositeVDB)this.vdbRepo.get(new VDBKey(name, version));
        if (v != null) {
            return v.getVDB();
        }
        return null;
    }

    public List<VDBMetaData> getVDBs() {
        ArrayList<VDBMetaData> vdbs = new ArrayList<VDBMetaData>();
        for (CompositeVDB cVDB : this.vdbRepo.values()) {
            vdbs.add(cVDB.getVDB());
        }
        return vdbs;
    }

    protected VDBKey vdbId(VDBMetaData vdb) {
        return new VDBKey(vdb.getName(), vdb.getVersion());
    }

    public VDBMetaData getVDB(String vdbName) throws VirtualDatabaseException {
        int latestVersion = 0;
        for (VDBKey key : this.vdbRepo.tailMap(new VDBKey(vdbName, 0)).keySet()) {
            if (!key.getName().equalsIgnoreCase(vdbName)) break;
            VDBMetaData vdb = ((CompositeVDB)this.vdbRepo.get(key)).getVDB();
            switch (vdb.getConnectionType()) {
                case ANY: {
                    latestVersion = Math.max(vdb.getVersion(), latestVersion);
                    break;
                }
                case BY_VERSION: {
                    if (latestVersion != 0) break;
                    latestVersion = vdb.getVersion();
                }
            }
        }
        if (latestVersion == 0) {
            throw new VirtualDatabaseException(RuntimePlugin.Util.getString("VDBService.VDB_does_not_exist._2", new Object[]{vdbName, "latest"}));
        }
        return this.getVDB(vdbName, latestVersion);
    }

    public MetadataStore getSystemStore() {
        return this.systemStore;
    }

    public MetadataStore getODBCStore() {
        return this.odbcStore;
    }

    public void setSystemStore(MetadataStore store) {
        this.systemStore = store;
    }

    private MetadataStore getODBCMetadataStore() {
        try {
            PgCatalogMetadataStore pg = new PgCatalogMetadataStore("pg_catalog", this.getBuiltinDatatypes(), new Properties());
            return pg.getMetadataStore();
        }
        catch (TranslatorException e) {
            LogManager.logError((String)"org.teiid.PROCESSOR", (String)RuntimePlugin.Util.getString("failed_to_load_odbc_metadata"));
            return null;
        }
    }

    public void odbcEnabled() {
        this.odbcEnabled = true;
    }

    public synchronized boolean removeVDB(String vdbName, int vdbVersion) {
        VDBKey key = new VDBKey(vdbName, vdbVersion);
        CompositeVDB removed = (CompositeVDB)this.vdbRepo.remove(key);
        if (removed != null) {
            for (CompositeVDB other : this.vdbRepo.values()) {
                other.removeChild(key);
            }
            return true;
        }
        return false;
    }

    public Map<String, Datatype> getBuiltinDatatypes() {
        Collection datatypes = this.systemStore.getDatatypes();
        HashMap<String, Datatype> datatypeMap = new HashMap<String, Datatype>();
        block0: for (Class typeClass : DataTypeManager.getAllDataTypeClasses()) {
            for (Datatype datatypeRecordImpl : datatypes) {
                if (!datatypeRecordImpl.getJavaClassName().equals(typeClass.getName())) continue;
                datatypeMap.put(DataTypeManager.getDataTypeName((Class)typeClass), datatypeRecordImpl);
                continue block0;
            }
        }
        return datatypeMap;
    }

    public void mergeVDBs(String sourceVDBName, int sourceVDBVersion, String targetVDBName, int targetVDBVersion) throws AdminException {
        CompositeVDB source = (CompositeVDB)this.vdbRepo.get(new VDBKey(sourceVDBName, sourceVDBVersion));
        if (source == null) {
            throw new AdminProcessingException(RuntimePlugin.Util.getString("vdb_not_found", new Object[]{sourceVDBName, sourceVDBVersion}));
        }
        CompositeVDB target = (CompositeVDB)this.vdbRepo.get(new VDBKey(targetVDBName, targetVDBVersion));
        if (target == null) {
            throw new AdminProcessingException(RuntimePlugin.Util.getString("vdb_not_found", new Object[]{sourceVDBName, sourceVDBVersion}));
        }
        target.addChild(source);
    }

    public void start() {
        if (this.odbcEnabled) {
            this.odbcStore = this.getODBCMetadataStore();
        }
    }

    public void updateVDB(String name, int version) {
        CompositeVDB v = (CompositeVDB)this.vdbRepo.get(new VDBKey(name, version));
        if (v != null) {
            v.update(v.getVDB());
        }
    }
}

