/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.vfs.plugins.structure.AbstractVFSStructureDeployer;
import org.jboss.deployers.vfs.spi.structure.StructureContext;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.plugins.context.jar.JarUtils;

public class VDBStructure
extends AbstractVFSStructureDeployer {
    public VDBStructure() {
        this.setRelativeOrder(1000);
        JarUtils.addJarSuffix((String)".vdb");
    }

    public boolean determineStructure(StructureContext structureContext) throws DeploymentException {
        VirtualFile file = structureContext.getFile();
        try {
            if (!VDBStructure.isLeaf((VirtualFile)file) && file.getName().endsWith(".vdb")) {
                VirtualFile metainf = file.getChild("META-INF");
                if (metainf == null) {
                    return false;
                }
                if (metainf.getChild("vdb.xml") == null) {
                    return false;
                }
                ArrayList<String> scanDirs = new ArrayList<String>();
                scanDirs.add("/");
                List children = file.getChildren();
                for (VirtualFile child : children) {
                    if (child.isLeaf()) continue;
                    scanDirs.add(child.getName());
                }
                this.createContext(structureContext, scanDirs.toArray(new String[scanDirs.size()]));
                return true;
            }
        }
        catch (IOException e) {
            throw DeploymentException.rethrowAsDeploymentException((String)("Error determining structure: " + file.getName()), (Throwable)e);
        }
        return false;
    }
}

