/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.services;

import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.teiid.logging.LogManager;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.security.Credentials;
import org.teiid.security.SecurityHelper;

public class TeiidLoginContext {
    public static final String AT = "@";
    private LoginContext loginContext;
    private String userName;
    private String securitydomain;
    private Object credentials;
    private SecurityHelper securityHelper;

    public TeiidLoginContext(SecurityHelper helper) {
        this.securityHelper = helper;
    }

    public void authenticateUser(String username, final Credentials credential, String applicationName, List<String> domains, boolean onlyallowPassthrough) throws LoginException {
        LogManager.logDetail((String)"org.teiid.SECURITY", (Object[])new Object[]{"authenticateUser", username, applicationName});
        final String baseUsername = TeiidLoginContext.getBaseUsername(username);
        if (onlyallowPassthrough) {
            for (String domain : this.getDomainsForUser(domains, username)) {
                Subject existing = this.securityHelper.getSubjectInContext(domain);
                if (existing == null) continue;
                this.userName = this.getUserName(existing) + AT + domain;
                this.securitydomain = domain;
                this.loginContext = this.createLoginContext(domain, existing);
                return;
            }
            throw new LoginException(RuntimePlugin.Util.getString("no_passthrough_identity_found"));
        }
        for (String domain : this.getDomainsForUser(domains, username)) {
            try {
                CallbackHandler handler = new CallbackHandler(){

                    @Override
                    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                        for (int i = 0; i < callbacks.length; ++i) {
                            if (callbacks[i] instanceof NameCallback) {
                                NameCallback nc = (NameCallback)callbacks[i];
                                nc.setName(baseUsername);
                                continue;
                            }
                            if (callbacks[i] instanceof PasswordCallback) {
                                PasswordCallback pc = (PasswordCallback)callbacks[i];
                                char[] password = null;
                                if (credential != null) {
                                    password = credential.getCredentialsAsCharArray();
                                }
                                pc.setPassword(password);
                                TeiidLoginContext.this.credentials = password;
                                continue;
                            }
                            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
                        }
                    }
                };
                this.loginContext = this.createLoginContext(domain, handler);
                this.loginContext.login();
                this.userName = baseUsername + AT + domain;
                this.securitydomain = domain;
                LogManager.logDetail((String)"org.teiid.SECURITY", (Object[])new Object[]{"Logon successful for \"", username, "\""});
                return;
            }
            catch (LoginException e) {
                LogManager.logDetail((String)"org.teiid.SECURITY", (Throwable)e, (Object[])new Object[]{e.getMessage()});
            }
        }
        throw new LoginException(RuntimePlugin.Util.getString("SessionServiceImpl.The_username_0_and/or_password_are_incorrect", new Object[]{username}));
    }

    private String getUserName(Subject subject) {
        Set<Principal> principals = subject.getPrincipals();
        for (Principal p : principals) {
            if (p instanceof Group) continue;
            return p.getName();
        }
        return null;
    }

    protected LoginContext createLoginContext(String domain, CallbackHandler handler) throws LoginException {
        return new LoginContext(domain, handler);
    }

    protected LoginContext createLoginContext(String domain, Subject subject) throws LoginException {
        return new LoginContext(domain, subject);
    }

    public LoginContext getLoginContext() {
        return this.loginContext;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getSecurityDomain() {
        return this.securitydomain;
    }

    public Object getSecurityContext() {
        Object sc = null;
        if (this.loginContext != null && (sc = this.securityHelper.getSecurityContext(this.securitydomain)) == null) {
            Subject subject = this.loginContext.getSubject();
            Principal principal = null;
            for (Principal p : subject.getPrincipals()) {
                if (!this.userName.startsWith(p.getName())) continue;
                principal = p;
                break;
            }
            return this.securityHelper.createSecurityContext(this.securitydomain, principal, this.credentials, subject);
        }
        return sc;
    }

    static String getBaseUsername(String username) {
        if (username == null) {
            return username;
        }
        int index = TeiidLoginContext.getQualifierIndex(username);
        String result = username;
        if (index != -1) {
            result = username.substring(0, index);
        }
        return result.replaceAll("\\\\@", AT);
    }

    static String escapeName(String name) {
        if (name == null) {
            return name;
        }
        return name.replaceAll(AT, "\\\\@");
    }

    static String getDomainName(String username) {
        if (username == null) {
            return username;
        }
        int index = TeiidLoginContext.getQualifierIndex(username);
        if (index != -1) {
            return username.substring(index + 1);
        }
        return null;
    }

    static int getQualifierIndex(String username) {
        block1: {
            int index = username.length();
            do {
                --index;
                if ((index = username.lastIndexOf(AT, index)) == -1) break block1;
            } while (index <= 0 || username.charAt(index - 1) == '\\');
            return index;
        }
        return -1;
    }

    private Collection<String> getDomainsForUser(List<String> domains, String username) {
        if (username == null) {
            return domains;
        }
        String domain = TeiidLoginContext.getDomainName(username);
        if (domain == null) {
            return domains;
        }
        String domainHolder = null;
        for (String d : domains) {
            if (!d.equalsIgnoreCase(domain)) continue;
            domainHolder = d;
            break;
        }
        if (domainHolder == null) {
            return Collections.emptyList();
        }
        LinkedList<String> result = new LinkedList<String>();
        result.add(domainHolder);
        return result;
    }
}

