/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import javax.net.ssl.SSLEngine;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.DefaultChannelPipeline;
import org.jboss.netty.handler.ssl.SslHandler;
import org.teiid.common.buffer.StorageManager;
import org.teiid.net.socket.ObjectChannel;
import org.teiid.odbc.ODBCServerRemote;
import org.teiid.transport.ChannelListener;
import org.teiid.transport.ClientServiceRegistryImpl;
import org.teiid.transport.ODBCClientInstance;
import org.teiid.transport.PgBackendProtocol;
import org.teiid.transport.PgFrontendProtocol;
import org.teiid.transport.SSLAwareChannelHandler;
import org.teiid.transport.SSLConfiguration;
import org.teiid.transport.SocketConfiguration;
import org.teiid.transport.SocketListener;

public class ODBCSocketListener
extends SocketListener {
    private ODBCServerRemote.AuthenticationType authType = ODBCServerRemote.AuthenticationType.CLEARTEXT;

    public ODBCSocketListener(SocketConfiguration config, ClientServiceRegistryImpl csr, StorageManager storageManager, int portOffset) {
        super(config, csr, storageManager, portOffset);
    }

    @Override
    protected SSLAwareChannelHandler createChannelPipelineFactory(final SSLConfiguration config, StorageManager storageManager) {
        return new SSLAwareChannelHandler(this, config, Thread.currentThread().getContextClassLoader(), storageManager){

            @Override
            public ChannelPipeline getPipeline() throws Exception {
                DefaultChannelPipeline pipeline = new DefaultChannelPipeline();
                SSLEngine engine = config.getServerSSLEngine();
                if (engine != null) {
                    pipeline.addLast("ssl", (ChannelHandler)new SslHandler(engine));
                }
                pipeline.addLast("odbcFrontendProtocol", (ChannelHandler)new PgFrontendProtocol(0x100000));
                pipeline.addLast("odbcBackendProtocol", (ChannelHandler)new PgBackendProtocol());
                pipeline.addLast("handler", (ChannelHandler)this);
                return pipeline;
            }
        };
    }

    @Override
    public ChannelListener createChannelListener(ObjectChannel channel) {
        return new ODBCClientInstance(channel, this.authType);
    }

    public void setAuthenticationType(String value) {
        this.authType = ODBCServerRemote.AuthenticationType.valueOf(value);
    }
}

