/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.transport.SSLConfiguration;

@ManagementObject(componentType=@ManagementComponent(type="teiid", subtype="dqp"), properties=ManagementProperties.EXPLICIT)
public class SocketConfiguration {
    private static final String ANY = "0.0.0.0";
    private static final String JBOSS_SERVER_BIND_ADDRESS = "jboss.bind.address";
    private int outputBufferSize;
    private int inputBufferSize;
    private int maxSocketThreads;
    private int portNumber;
    private InetAddress hostAddress;
    private SSLConfiguration sslConfiguration;
    private boolean enabled;
    private String hostName;

    public void setBindAddress(String addr) {
        this.hostName = addr;
    }

    public void setPortNumber(int port) {
        this.portNumber = port;
    }

    public void setMaxSocketThreads(int value) {
        this.maxSocketThreads = value;
    }

    public void setInputBufferSize(int value) {
        this.inputBufferSize = value;
    }

    public void setOutputBufferSize(int value) {
        this.outputBufferSize = value;
    }

    public void setSSLConfiguration(SSLConfiguration value) {
        this.sslConfiguration = value;
    }

    private void resolveHostName() {
        try {
            if (this.hostName == null) {
                this.hostName = System.getProperty(JBOSS_SERVER_BIND_ADDRESS);
            }
            if (this.hostName == null || ANY.equals(this.hostName)) {
                this.hostName = InetAddress.getLocalHost().getHostName();
            }
        }
        catch (UnknownHostException e) {
            throw new TeiidRuntimeException("Failed to resolve the bind address");
        }
    }

    @ManagementProperty(description="SSL enabled", readOnly=true)
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @ManagementProperty(description="SO_SNDBUF size, 0 indicates that system default should be used (default 0)", readOnly=true)
    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    @ManagementProperty(description="SO_RCVBUF size, 0 indicates that system default should be used (default 0)", readOnly=true)
    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    @ManagementProperty(description="Max NIO threads", readOnly=true)
    public int getMaxSocketThreads() {
        return this.maxSocketThreads;
    }

    @ManagementProperty(description="Port Number", readOnly=true)
    public int getPortNumber() {
        return this.portNumber;
    }

    public InetAddress getHostAddress() {
        this.resolveHostName();
        if (this.hostAddress != null) {
            return this.hostAddress;
        }
        try {
            InetAddress addr = InetAddress.getByName(this.hostName);
            if (addr.getHostAddress().equalsIgnoreCase(this.hostName)) {
                this.hostAddress = addr;
            }
            return addr;
        }
        catch (UnknownHostException e) {
            throw new TeiidRuntimeException("Failed to resolve the bind address");
        }
    }

    @ManagementProperty(description="Host Name", readOnly=true)
    public String getHostName() {
        this.resolveHostName();
        return this.hostName;
    }

    public SSLConfiguration getSSLConfiguration() {
        return this.sslConfiguration;
    }
}

