/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.io.ByteArrayInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.util.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.client.security.ILogon;
import org.teiid.client.security.InvalidSessionException;
import org.teiid.client.security.LogonException;
import org.teiid.client.security.LogonResult;
import org.teiid.client.security.SessionToken;
import org.teiid.client.util.ResultsFuture;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.StorageManager;
import org.teiid.core.ComponentNotFoundException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.crypto.NullCryptor;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.dqp.service.SessionService;
import org.teiid.net.CommunicationException;
import org.teiid.net.ConnectionException;
import org.teiid.net.TeiidURL;
import org.teiid.net.socket.SocketServerConnection;
import org.teiid.net.socket.SocketServerConnectionFactory;
import org.teiid.net.socket.UrlServerDiscovery;
import org.teiid.transport.ClientServiceRegistryImpl;
import org.teiid.transport.LogonImpl;
import org.teiid.transport.SSLConfiguration;
import org.teiid.transport.SocketListener;
import org.teiid.transport.SocketListenerStats;
import org.teiid.transport.TestSocketRemoting;

public class TestCommSockets {
    SocketListener listener;
    private SocketServerConnectionFactory sscf;
    private InetSocketAddress addr;

    @Before
    public void setUp() {
        this.addr = new InetSocketAddress(0);
    }

    @After
    public void tearDown() throws Exception {
        if (this.listener != null) {
            this.listener.stop();
        }
    }

    @Test(expected=CommunicationException.class)
    public void testFailedConnect() throws Exception {
        SSLConfiguration config = new SSLConfiguration();
        this.listener = new SocketListener(this.addr.getPort(), this.addr.getAddress().getHostAddress(), 1024, 1024, 1, config, null, (StorageManager)BufferManagerFactory.getStandaloneBufferManager());
        Properties p = new Properties();
        String url = new TeiidURL(this.addr.getHostName(), this.listener.getPort() - 1, false).getAppServerURL();
        p.setProperty("serverURL", url);
        SocketServerConnectionFactory.getInstance().getConnection(p);
    }

    @Test
    public void testConnectWithoutPooling() throws Exception {
        Properties p = new Properties();
        p.setProperty("org.teiid.sockets.maxCachedInstances", String.valueOf(0));
        SocketServerConnection conn = this.helpEstablishConnection(false, new SSLConfiguration(), p);
        SocketListenerStats stats = this.listener.getStats();
        Assert.assertEquals((long)2L, (long)stats.objectsRead);
        Assert.assertEquals((long)1L, (long)stats.sockets);
        conn.close();
        stats = this.listener.getStats();
        Assert.assertEquals((long)1L, (long)stats.maxSockets);
        Assert.assertEquals((long)3L, (long)stats.objectsRead);
        if (stats.sockets > 0) {
            Thread.sleep(500L);
        }
        stats = this.listener.getStats();
        Assert.assertEquals((long)0L, (long)stats.sockets);
    }

    @Test
    public void testConnectWithPooling() throws Exception {
        SocketServerConnection conn = this.helpEstablishConnection(false);
        SocketListenerStats stats = this.listener.getStats();
        Assert.assertEquals((long)2L, (long)stats.objectsRead);
        Assert.assertEquals((long)1L, (long)stats.sockets);
        conn.close();
        stats = this.listener.getStats();
        Assert.assertEquals((long)1L, (long)stats.maxSockets);
        Assert.assertEquals((long)3L, (long)stats.objectsRead);
        stats = this.listener.getStats();
        Assert.assertEquals((long)1L, (long)stats.sockets);
        conn = this.helpEstablishConnection(false);
        conn.close();
        stats = this.listener.getStats();
        Assert.assertEquals((long)1L, (long)stats.sockets);
        Assert.assertEquals((long)1L, (long)stats.maxSockets);
    }

    @Test
    public void testLobs() throws Exception {
        SocketServerConnection conn = this.helpEstablishConnection(false);
        TestSocketRemoting.FakeService fs = (TestSocketRemoting.FakeService)conn.getService(TestSocketRemoting.FakeService.class);
        Assert.assertEquals((long)150L, (long)fs.lobMethod(new ByteArrayInputStream(new byte[100]), new StringReader(new String(new char[50]))));
        Assert.assertEquals((long)0L, (long)fs.lobMethod(new ByteArrayInputStream(new byte[0]), new StringReader(new String(new char[0]))));
        Assert.assertEquals((long)131122L, (long)fs.lobMethod(new ByteArrayInputStream(new byte[131072]), new StringReader(new String(new char[50]))));
    }

    @Test
    public void testServerRemoteStreaming() throws Exception {
        SocketServerConnection conn = this.helpEstablishConnection(false);
        TestSocketRemoting.FakeService fs = (TestSocketRemoting.FakeService)conn.getService(TestSocketRemoting.FakeService.class);
        Assert.assertEquals((Object)"hello world", (Object)ObjectConverterUtil.convertToString((Reader)fs.getReader()));
        Assert.assertTrue((boolean)Serializable.class.isAssignableFrom(fs.getReader().getClass()));
    }

    @Test
    public void testConnectWithoutClientEncryption() throws Exception {
        SSLConfiguration config = new SSLConfiguration();
        config.setMode("disabled");
        SocketServerConnection conn = this.helpEstablishConnection(false, config, new Properties());
        Assert.assertTrue((boolean)(conn.selectServerInstance().getCryptor() instanceof NullCryptor));
        conn.close();
    }

    private SocketServerConnection helpEstablishConnection(boolean secure) throws CommunicationException, ConnectionException {
        return this.helpEstablishConnection(secure, new SSLConfiguration(), new Properties());
    }

    private SocketServerConnection helpEstablishConnection(boolean clientSecure, SSLConfiguration config, Properties socketConfig) throws CommunicationException, ConnectionException {
        if (this.listener == null) {
            ClientServiceRegistryImpl server = new ClientServiceRegistryImpl();
            server.registerClientService(ILogon.class, (Object)new LogonImpl((SessionService)Mockito.mock(SessionService.class), "fakeCluster"){

                public LogonResult logon(Properties connProps) throws LogonException, ComponentNotFoundException {
                    return new LogonResult(new SessionToken("dummy"), "x", 1, "z");
                }

                public ResultsFuture<?> ping() throws InvalidSessionException, TeiidComponentException {
                    return ResultsFuture.NULL_FUTURE;
                }

                public void assertIdentity(SessionToken checkSession) throws InvalidSessionException, TeiidComponentException {
                }
            }, null);
            server.registerClientService(TestSocketRemoting.FakeService.class, (Object)new TestSocketRemoting.FakeServiceImpl(), null);
            this.listener = new SocketListener(this.addr.getPort(), this.addr.getAddress().getHostAddress(), 1024, 1024, 1, config, server, (StorageManager)BufferManagerFactory.getStandaloneBufferManager());
            SocketListenerStats stats = this.listener.getStats();
            Assert.assertEquals((long)0L, (long)stats.maxSockets);
            Assert.assertEquals((long)0L, (long)stats.objectsRead);
            Assert.assertEquals((long)0L, (long)stats.objectsWritten);
            Assert.assertEquals((long)0L, (long)stats.sockets);
        }
        Properties p = new Properties();
        String url = new TeiidURL(this.addr.getHostName(), this.listener.getPort(), clientSecure).getAppServerURL();
        p.setProperty("serverURL", url);
        p.setProperty("discoveryStategy", UrlServerDiscovery.class.getName());
        if (this.sscf == null) {
            this.sscf = new SocketServerConnectionFactory();
            this.sscf.initialize(socketConfig);
        }
        return this.sscf.getConnection(p);
    }

    @Test
    public void testSSLConnectWithNonSSLServer() throws Exception {
        try {
            this.helpEstablishConnection(true);
            Assert.fail((String)"exception expected");
        }
        catch (CommunicationException communicationException) {
            // empty catch block
        }
    }

    @Test
    public void testAnonSSLConnect() throws Exception {
        SSLConfiguration config = new SSLConfiguration();
        config.setMode("enabled");
        config.setAuthenticationMode("anonymous");
        Properties p = new Properties();
        this.helpEstablishConnection(true, config, p);
        SocketServerConnection conn = this.helpEstablishConnection(true, config, p);
        conn.close();
    }

    @Test(expected=CommunicationException.class)
    public void testNonSSLConnectWithSSLServer() throws Exception {
        SSLConfiguration config = new SSLConfiguration();
        config.setMode("enabled");
        config.setAuthenticationMode("anonymous");
        Properties p = new Properties();
        p.setProperty("org.teiid.ssl.allowAnon", Boolean.FALSE.toString());
        this.helpEstablishConnection(true, config, p);
    }

    @Test
    public void testSelectNewInstance() throws Exception {
        SSLConfiguration config = new SSLConfiguration();
        Properties p = new Properties();
        SocketServerConnection conn = this.helpEstablishConnection(false, config, p);
        SocketListenerStats stats = this.listener.getStats();
        Assert.assertEquals((long)2L, (long)stats.objectsRead);
        Assert.assertEquals((long)1L, (long)stats.sockets);
        conn.cleanUp();
        Assert.assertTrue((boolean)conn.isOpen(1000L));
        stats = this.listener.getStats();
        Assert.assertEquals((long)5L, (long)stats.objectsRead);
        Assert.assertEquals((long)1L, (long)stats.sockets);
        conn.close();
    }
}

