/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.util.Properties;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.client.security.LogonResult;
import org.teiid.client.security.SessionToken;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.service.SessionService;
import org.teiid.transport.LogonImpl;

public class TestLogonImpl
extends TestCase {
    public void testLogonResult() throws Exception {
        SessionService ssi = (SessionService)Mockito.mock(SessionService.class);
        DQPWorkContext.setWorkContext((DQPWorkContext)new DQPWorkContext());
        String userName = "Fred";
        String applicationName = "test";
        Properties p = new Properties();
        p.setProperty("user", userName);
        p.setProperty("ApplicationName", applicationName);
        SessionMetadata session = new SessionMetadata();
        session.setUserName(userName);
        session.setApplicationName(applicationName);
        session.setSessionId(String.valueOf(1));
        session.setSessionToken(new SessionToken(1L, userName));
        Mockito.stub((Object)ssi.createSession(userName, null, applicationName, p, false, true)).toReturn((Object)session);
        LogonImpl impl = new LogonImpl(ssi, "fakeCluster");
        LogonResult result = impl.logon(p);
        TestLogonImpl.assertEquals((String)userName, (String)result.getUserName());
        TestLogonImpl.assertEquals((String)String.valueOf(1), (String)result.getSessionID());
    }
}

