/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.logging;

import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.teiid.logging.Logger;

public class Log4jListener
implements Logger {
    public boolean isEnabled(String context, int level) {
        if (context == null) {
            return false;
        }
        Level logLevel = Log4jListener.convert2Log4JLevel(level);
        if (logLevel == Level.OFF) {
            return false;
        }
        org.apache.log4j.Logger log = Log4jListener.getLogger(context);
        return log.isEnabledFor((Priority)logLevel);
    }

    public void log(int level, String context, Object msg) {
        org.apache.log4j.Logger log4j = Log4jListener.getLogger(context);
        log4j.log((Priority)Log4jListener.convert2Log4JLevel(level), msg);
    }

    public void log(int level, String context, Throwable t, Object msg) {
        org.apache.log4j.Logger log4j = Log4jListener.getLogger(context);
        log4j.log((Priority)Log4jListener.convert2Log4JLevel(level), msg, t);
    }

    public static Level convert2Log4JLevel(int level) {
        switch (level) {
            case 1: {
                return Level.FATAL;
            }
            case 2: {
                return Level.ERROR;
            }
            case 3: {
                return Level.WARN;
            }
            case 4: {
                return Level.INFO;
            }
            case 5: 
            case 6: {
                return Level.DEBUG;
            }
            case 0: {
                return Level.OFF;
            }
        }
        return Level.DEBUG;
    }

    public static int convert2MessageLevel(Level level) {
        switch (level.toInt()) {
            case 50000: {
                return 1;
            }
            case 40000: {
                return 2;
            }
            case 30000: {
                return 3;
            }
            case 20000: {
                return 4;
            }
            case 10000: {
                return 5;
            }
            case 0x7FFFFFFF: {
                return 0;
            }
        }
        return 5;
    }

    public static org.apache.log4j.Logger getLogger(String context) {
        return org.apache.log4j.Logger.getLogger((String)context);
    }

    public void shutdown() {
    }
}

