/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.odbc;

import java.io.IOException;
import java.io.StringReader;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.PreparedStatementImpl;
import org.teiid.logging.LogManager;
import org.teiid.odbc.ODBCClientRemote;
import org.teiid.odbc.ODBCServerRemote;
import org.teiid.odbc.ScriptReader;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.transport.PGCharsetConverter;

public class ODBCServerRemoteImpl
implements ODBCServerRemote {
    private static final String UNNAMED = "UNNAMED";
    private static Pattern setPattern = Pattern.compile("(SET|set)\\s+(\\w+)\\s+(TO|to)\\s+'(\\w+\\d*)'");
    private static Pattern pkPattern = Pattern.compile("select ta.attname, ia.attnum, ic.relname, n.nspname, tc.relname from pg_catalog.pg_attribute ta, pg_catalog.pg_attribute ia, pg_catalog.pg_class tc, pg_catalog.pg_index i, pg_catalog.pg_namespace n, pg_catalog.pg_class ic where tc.relname = E'(\\w+)' AND n.nspname = E'(\\w+)'.*");
    private static Pattern pkKeyPattern = Pattern.compile("select ta.attname, ia.attnum, ic.relname, n.nspname, NULL .*");
    private Pattern fkPattern = Pattern.compile("select\\s+'(\\w+)'::name as PKTABLE_CAT,\\s+n2.nspname as PKTABLE_SCHEM,\\s+c2.relname as PKTABLE_NAME,\\s+a2.attname as PKCOLUMN_NAME,\\s+'(\\w+)'::name as FKTABLE_CAT,\\s+n1.nspname as FKTABLE_SCHEM,\\s+c1.relname as FKTABLE_NAME,\\s+a1.attname as FKCOLUMN_NAME,\\s+i::int2 as KEY_SEQ,\\s+case ref.confupdtype\\s+when 'c' then (\\d)::int2\\s+when 'n' then (\\d)::int2\\s+when 'd' then (\\d)::int2\\s+when 'r' then (\\d)::int2\\s+else 3::int2\\s+end as UPDATE_RULE,\\s+case ref.confdeltype\\s+when 'c' then (\\d)::int2\\s+when 'n' then (\\d)::int2\\s+when 'd' then (\\d)::int2\\s+when 'r' then (\\d)::int2\\s+else 3::int2\\s+end as DELETE_RULE,\\s+ref.conname as FK_NAME,\\s+cn.conname as PK_NAME,\\s+case\\s+when ref.condeferrable then\\s+case\\s+when ref.condeferred then (\\d)::int2\\s+else (\\d)::int2\\s+end\\s+else (\\d)::int2\\s+end as DEFERRABLITY\\s+from\\s+\\(\\(\\(\\(\\(\\(\\( \\(select cn.oid, conrelid, conkey, confrelid, confkey,\\s+generate_series\\(array_lower\\(conkey, 1\\), array_upper\\(conkey, 1\\)\\) as i,\\s+confupdtype, confdeltype, conname,\\s+condeferrable, condeferred\\s+from pg_catalog.pg_constraint cn,\\s+pg_catalog.pg_class c,\\s+pg_catalog.pg_namespace n\\s+where contype = 'f' \\s+and  conrelid = c.oid\\s+and  relname = E'(\\w+)'\\s+and  n.oid = c.relnamespace\\s+and  n.nspname = E'(\\w+)'\\s+\\) ref\\s+inner join pg_catalog.pg_class c1\\s+on c1.oid = ref.conrelid\\)\\s+inner join pg_catalog.pg_namespace n1\\s+on  n1.oid = c1.relnamespace\\)\\s+inner join pg_catalog.pg_attribute a1\\s+on  a1.attrelid = c1.oid\\s+and  a1.attnum = conkey\\[i\\]\\)\\s+inner join pg_catalog.pg_class c2\\s+on  c2.oid = ref.confrelid\\)\\s+inner join pg_catalog.pg_namespace n2\\s+on  n2.oid = c2.relnamespace\\)\\s+inner join pg_catalog.pg_attribute a2\\s+on  a2.attrelid = c2.oid\\s+and  a2.attnum = confkey\\[i\\]\\)\\s+left outer join pg_catalog.pg_constraint cn\\s+on cn.conrelid = ref.confrelid\\s+and cn.contype = 'p'\\)\\s+order by ref.oid, ref.i");
    private static Pattern procParametersPattern = Pattern.compile("select proname, proretset, prorettype, pronargs, proargtypes, nspname, p.oid, atttypid, attname, proargnames, proargmodes, proallargtypes from ((pg_catalog.pg_namespace n inner join pg_catalog.pg_proc p on p.pronamespace = n.oid) inner join pg_type t on t.oid = p.prorettype) left outer join pg_attribute a on a.attrelid = t.typrelid  and attnum > 0 and not attisdropped where has_function_privilege(p.oid, 'EXECUTE') and nspname like E'(\\w+)' and proname like E'(\\w+)' order by nspname, proname, p.oid, attnum");
    private static Pattern deallocatePattern = Pattern.compile("DEALLOCATE \"(\\w+\\d+_*)\"");
    private static Pattern releasePattern = Pattern.compile("RELEASE (\\w+\\d+_*)");
    private static Pattern savepointPattern = Pattern.compile("SAVEPOINT (\\w+\\d+_*)");
    private static Pattern rollbackPattern = Pattern.compile("ROLLBACK\\s*(to)*\\s*(\\w+\\d+_*)*");
    private ODBCClientRemote client;
    private Properties props;
    private ODBCServerRemote.AuthenticationType authType;
    private ConnectionImpl connection;
    private Map<String, Prepared> preparedMap = Collections.synchronizedMap(new HashMap());
    private Map<String, Portal> portalMap = Collections.synchronizedMap(new HashMap());

    public ODBCServerRemoteImpl(ODBCClientRemote client, ODBCServerRemote.AuthenticationType authType) {
        this.client = client;
        this.authType = authType;
    }

    @Override
    public void initialize(Properties props) {
        this.props = props;
        this.client.initialized(this.props);
        if (this.authType.equals((Object)ODBCServerRemote.AuthenticationType.CLEARTEXT)) {
            this.client.useClearTextAuthentication();
        } else if (this.authType.equals((Object)ODBCServerRemote.AuthenticationType.MD5)) {
            // empty if block
        }
    }

    @Override
    public void logon(String databaseName, String user, String password) {
        try {
            this.connection = (ConnectionImpl)DriverManager.getConnection("jdbc:teiid:" + databaseName + ";ApplicationName=ODBC", user, password);
            int hash = this.connection.getConnectionId().hashCode();
            this.client.authenticationSucess(hash, hash);
            this.sync();
        }
        catch (SQLException e) {
            this.client.errorOccurred(e);
            this.terminate();
        }
    }

    @Override
    public void prepare(String prepareName, String sql, int[] paramType) {
        if (this.connection != null) {
            if (prepareName == null || prepareName.length() == 0) {
                prepareName = UNNAMED;
            }
            if (sql != null) {
                String modfiedSQL = sql.replaceAll("\\$\\d+", "?");
                try {
                    Prepared previous = this.preparedMap.remove(prepareName);
                    if (previous != null) {
                        previous.stmt.close();
                    }
                    PreparedStatementImpl stmt = this.connection.prepareStatement(modfiedSQL);
                    this.preparedMap.put(prepareName, new Prepared(prepareName, sql, (PreparedStatement)stmt, paramType));
                    this.client.prepareCompleted(prepareName);
                }
                catch (SQLException e) {
                    this.client.errorOccurred(e);
                }
            }
        } else {
            this.client.errorOccurred(RuntimePlugin.Util.getString("no_active_connection"));
        }
    }

    @Override
    public void bindParameters(String bindName, String prepareName, int paramCount, Object[] params, int resultCodeCount, int[] resultColumnFormat) {
        Prepared previous;
        this.portalMap.remove(UNNAMED);
        if (prepareName == null || prepareName.length() == 0) {
            prepareName = UNNAMED;
        }
        if ((previous = this.preparedMap.get(prepareName)) == null) {
            this.client.errorOccurred(RuntimePlugin.Util.getString("bad_binding", new Object[]{prepareName}));
            return;
        }
        if (bindName == null || bindName.length() == 0) {
            bindName = UNNAMED;
        }
        try {
            for (int i = 0; i < paramCount; ++i) {
                previous.stmt.setObject(i + 1, params[i]);
            }
        }
        catch (SQLException e) {
            this.client.errorOccurred(e);
        }
        this.portalMap.put(bindName, new Portal(bindName, prepareName, previous.sql, previous.stmt, resultColumnFormat));
        this.client.bindComplete();
    }

    @Override
    public void unsupportedOperation(String msg) {
        this.client.errorOccurred(msg);
        this.sync();
    }

    @Override
    public void execute(String bindName, int maxRows) {
        Portal query;
        if (bindName == null || bindName.length() == 0) {
            bindName = UNNAMED;
        }
        if ((query = this.portalMap.get(bindName)) == null) {
            this.client.errorOccurred(RuntimePlugin.Util.getString("not_bound", new Object[]{bindName}));
            this.sync();
        } else {
            if (query.sql.trim().isEmpty()) {
                this.client.emptyQueryReceived();
                return;
            }
            PreparedStatement stmt = query.stmt;
            try {
                boolean result;
                if (maxRows != 0) {
                    stmt.setMaxRows(maxRows);
                }
                if (result = stmt.execute()) {
                    try {
                        ResultSet rs = stmt.getResultSet();
                        this.client.sendResults(query.sql, rs, true);
                    }
                    catch (SQLException e) {
                        this.client.errorOccurred(e);
                    }
                } else {
                    this.client.sendUpdateCount(query.sql, stmt.getUpdateCount());
                }
            }
            catch (SQLException e) {
                this.client.errorOccurred(e);
            }
        }
    }

    private String fixSQL(String sql) {
        String modified = sql;
        if (sql != null) {
            if (sql.startsWith("select") || sql.startsWith("SELECT")) {
                modified = sql.replace('\n', ' ');
                Matcher m = null;
                m = pkPattern.matcher(modified);
                if (m.matches()) {
                    modified = new StringBuffer("SELECT k.Name AS attname, convert(Position, short) AS attnum, TableName AS relname, SchemaName AS nspname, TableName AS relname").append(" FROM SYS.KeyColumns k").append(" WHERE ").append(" UCASE(SchemaName)").append(" LIKE '").append(m.group(2)).append("'").append(" AND UCASE(TableName)").append(" LIKE '").append(m.group(1)).append("'").append(" AND KeyType LIKE 'Primary'").append(" ORDER BY attnum").toString();
                } else {
                    m = pkKeyPattern.matcher(modified);
                    if (m.matches()) {
                        modified = "SELECT NULL, NULL, NULL, NULL, NULL FROM (SELECT 1) as X WHERE 0=1";
                    } else {
                        m = this.fkPattern.matcher(modified);
                        if (m.matches()) {
                            modified = "SELECT PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, KEY_SEQ, UPDATE_RULE, DELETE_RULE, FK_NAME, PK_NAME, DEFERRABILITY FROM SYS.ReferenceKeyColumns WHERE PKTABLE_NAME LIKE '" + m.group(14) + "' and PKTABLE_SCHEM LIKE '" + m.group(15) + "'";
                        } else {
                            modified = modified.replaceAll("E'", "'");
                            modified = modified.replaceAll("::[A-Za-z0-9]*", " ");
                            modified = modified.replaceAll("'pg_toast'", "'SYS'");
                            if (sql.equalsIgnoreCase("select current_schema()")) {
                                modified = "SELECT ''";
                            }
                        }
                    }
                }
            } else if (sql.equalsIgnoreCase("show max_identifier_length")) {
                modified = "select 63";
            } else {
                Matcher m = setPattern.matcher(sql);
                if (m.matches()) {
                    if (m.group(2).equalsIgnoreCase("client_encoding")) {
                        this.client.setEncoding(PGCharsetConverter.getCharset(m.group(4)));
                        modified = "SELECT 'SET'";
                    }
                } else if (modified.equalsIgnoreCase("BEGIN")) {
                    try {
                        this.connection.setAutoCommit(false);
                        modified = "SELECT 'BEGIN'";
                    }
                    catch (SQLException e) {
                        this.client.errorOccurred(e);
                    }
                } else if (modified.equalsIgnoreCase("COMMIT")) {
                    try {
                        this.connection.setAutoCommit(true);
                        modified = "SELECT 'COMMIT'";
                    }
                    catch (SQLException e) {
                        this.client.errorOccurred(e);
                    }
                } else {
                    m = rollbackPattern.matcher(modified);
                    if (m.matches()) {
                        try {
                            this.connection.rollback(false);
                            modified = "SELECT 'ROLLBACK'";
                        }
                        catch (SQLException e) {
                            this.client.errorOccurred(e);
                        }
                    } else {
                        m = savepointPattern.matcher(modified);
                        if (m.matches()) {
                            modified = "SELECT 'SAVEPOINT'";
                        } else {
                            m = releasePattern.matcher(modified);
                            if (m.matches()) {
                                modified = "SELECT 'RELEASE'";
                            } else {
                                m = deallocatePattern.matcher(modified);
                                if (m.matches()) {
                                    this.closePreparedStatement(m.group(1));
                                    modified = "SELECT 'DEALLOCATE'";
                                }
                            }
                        }
                    }
                }
            }
            if (modified != null && !modified.equalsIgnoreCase(sql)) {
                LogManager.logDetail((String)"org.teiid.ODBC", (Object[])new Object[]{"Modified Query:" + modified});
            }
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeQuery(String query) {
        this.portalMap.remove(UNNAMED);
        this.preparedMap.remove(UNNAMED);
        if (query.trim().length() == 0) {
            this.client.emptyQueryReceived();
            this.sync();
            return;
        }
        try {
            ScriptReader reader = new ScriptReader(new StringReader(query));
            String s = this.fixSQL(reader.readStatement());
            while (s != null) {
                Statement stmt = null;
                try {
                    stmt = this.connection.createStatement();
                    boolean result = stmt.execute(s);
                    if (result) {
                        this.client.sendResults(s, stmt.getResultSet(), true);
                    } else {
                        this.client.sendUpdateCount(s, stmt.getUpdateCount());
                    }
                    s = this.fixSQL(reader.readStatement());
                }
                catch (SQLException e) {
                    this.client.errorOccurred(e);
                    break;
                }
                finally {
                    try {
                        if (stmt == null) continue;
                        stmt.close();
                    }
                    catch (SQLException e) {
                        this.client.errorOccurred(e);
                    }
                }
            }
        }
        catch (IOException e) {
            this.client.errorOccurred(e);
        }
        this.sync();
    }

    @Override
    public void getParameterDescription(String prepareName) {
        Prepared query;
        if (prepareName == null || prepareName.length() == 0) {
            prepareName = UNNAMED;
        }
        if ((query = this.preparedMap.get(prepareName)) == null) {
            this.client.errorOccurred(RuntimePlugin.Util.getString("no_stmt_found", new Object[]{prepareName}));
            this.sync();
        } else {
            try {
                this.client.sendParameterDescription(query.stmt.getParameterMetaData(), query.paramType);
            }
            catch (SQLException e) {
                this.client.errorOccurred(e);
            }
        }
    }

    @Override
    public void getResultSetMetaDataDescription(String bindName) {
        Portal query;
        if (bindName == null || bindName.length() == 0) {
            bindName = UNNAMED;
        }
        if ((query = this.portalMap.get(bindName)) == null) {
            this.client.errorOccurred(RuntimePlugin.Util.getString("not_bound", new Object[]{bindName}));
        } else {
            try {
                this.client.sendResultSetDescription(query.stmt.getMetaData());
            }
            catch (SQLException e) {
                this.client.errorOccurred(e);
            }
        }
    }

    @Override
    public void sync() {
        boolean inTxn = false;
        boolean failedTxn = false;
        try {
            if (!this.connection.getAutoCommit()) {
                inTxn = true;
            }
        }
        catch (SQLException e) {
            failedTxn = true;
        }
        this.client.ready(inTxn, failedTxn);
    }

    @Override
    public void cancel() {
    }

    @Override
    public void closeBoundStatement(String bindName) {
        Portal query;
        if (bindName == null || bindName.length() == 0) {
            bindName = UNNAMED;
        }
        if ((query = this.portalMap.remove(bindName)) == null) {
            this.client.errorOccurred(RuntimePlugin.Util.getString("not_bound", new Object[]{bindName}));
        } else {
            try {
                if (this.connection.getAutoCommit()) {
                    this.closePreparedStatement(bindName);
                }
            }
            catch (SQLException e) {
                this.closePreparedStatement(bindName);
            }
        }
    }

    @Override
    public void closePreparedStatement(String preparedName) {
        Prepared query;
        if (preparedName == null || preparedName.length() == 0) {
            preparedName = UNNAMED;
        }
        if ((query = this.preparedMap.remove(preparedName)) == null) {
            this.client.errorOccurred(RuntimePlugin.Util.getString("no_stmt_found", new Object[]{preparedName}));
        } else {
            this.portalMap.remove(preparedName);
            try {
                query.stmt.close();
                this.client.statementClosed();
            }
            catch (SQLException e) {
                this.client.errorOccurred(RuntimePlugin.Util.getString("error_closing_stmt", new Object[]{preparedName}));
            }
        }
    }

    @Override
    public void terminate() {
        for (Portal portal : this.portalMap.values()) {
            try {
                portal.stmt.close();
            }
            catch (SQLException e) {}
        }
        for (Prepared prepared : this.preparedMap.values()) {
            try {
                prepared.stmt.close();
            }
            catch (SQLException sQLException) {}
        }
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.client.terminated();
    }

    @Override
    public void flush() {
        this.client.flush();
    }

    static class Portal {
        String name;
        String preparedName;
        String sql;
        int[] resultColumnFormat;
        PreparedStatement stmt;

        public Portal(String name, String preparedName, String sql, PreparedStatement stmt, int[] resultColumnformat) {
            this.name = name;
            this.preparedName = preparedName;
            this.sql = sql;
            this.stmt = stmt;
            this.resultColumnFormat = resultColumnformat;
        }
    }

    static class Prepared {
        String name;
        String sql;
        PreparedStatement stmt;
        int[] paramType;

        public Prepared(String name, String sql, PreparedStatement stmt, int[] paramType) {
            this.name = name;
            this.sql = sql;
            this.stmt = stmt;
            this.paramType = paramType;
        }
    }
}

