/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.util.Collection;
import java.util.Properties;
import javax.security.auth.login.LoginException;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.client.security.ILogon;
import org.teiid.client.security.InvalidSessionException;
import org.teiid.client.security.LogonException;
import org.teiid.client.security.LogonResult;
import org.teiid.client.security.SessionToken;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.ComponentNotFoundException;
import org.teiid.core.TeiidComponentException;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.service.SessionService;
import org.teiid.dqp.service.SessionServiceException;
import org.teiid.logging.LogManager;
import org.teiid.net.CommunicationException;
import org.teiid.security.Credentials;

public class LogonImpl
implements ILogon {
    private SessionService service;
    private String clusterName;

    public LogonImpl(SessionService service, String clusterName) {
        this.service = service;
        this.clusterName = clusterName;
    }

    public LogonResult logon(Properties connProps) throws LogonException, ComponentNotFoundException {
        String applicationName = connProps.getProperty("ApplicationName");
        String user = connProps.getProperty("user", "anonymous");
        String password = connProps.getProperty("password");
        Credentials credential = null;
        if (password != null) {
            credential = new Credentials(password.toCharArray());
        }
        boolean adminConnection = Boolean.parseBoolean(connProps.getProperty("admin"));
        try {
            SessionMetadata sessionInfo = this.service.createSession(user, credential, applicationName, connProps, adminConnection, true);
            this.updateDQPContext(sessionInfo);
            if (DQPWorkContext.getWorkContext().getClientAddress() == null) {
                sessionInfo.setEmbedded(true);
            }
            return new LogonResult(sessionInfo.getSessionToken(), sessionInfo.getVDBName(), sessionInfo.getVDBVersion(), this.clusterName);
        }
        catch (LoginException e) {
            throw new LogonException(e.getMessage());
        }
        catch (SessionServiceException e) {
            throw new LogonException((Throwable)e, e.getMessage());
        }
    }

    private String updateDQPContext(SessionMetadata s) {
        String sessionID = s.getSessionId();
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        workContext.setSession(s);
        return sessionID;
    }

    public ResultsFuture<?> logoff() throws InvalidSessionException {
        this.service.closeSession(DQPWorkContext.getWorkContext().getSessionId());
        DQPWorkContext.getWorkContext().getSession().setSessionId(null);
        return ResultsFuture.NULL_FUTURE;
    }

    public ResultsFuture<?> ping() throws InvalidSessionException, TeiidComponentException {
        String id = DQPWorkContext.getWorkContext().getSessionId();
        if (id != null) {
            this.service.pingServer(id);
        }
        LogManager.logTrace((String)"org.teiid.SECURITY", (Object[])new Object[]{"Ping", id});
        return ResultsFuture.NULL_FUTURE;
    }

    public ResultsFuture<?> ping(Collection<String> sessions) throws TeiidComponentException, CommunicationException {
        for (String string : sessions) {
            try {
                this.service.pingServer(string);
            }
            catch (InvalidSessionException e) {}
        }
        return ResultsFuture.NULL_FUTURE;
    }

    public void assertIdentity(SessionToken checkSession) throws InvalidSessionException, TeiidComponentException {
        SessionMetadata sessionInfo = null;
        try {
            sessionInfo = this.service.validateSession(checkSession.getSessionID());
        }
        catch (SessionServiceException e) {
            throw new TeiidComponentException((Throwable)e);
        }
        if (sessionInfo == null) {
            throw new InvalidSessionException();
        }
        SessionToken st = sessionInfo.getSessionToken();
        if (!st.equals((Object)checkSession)) {
            throw new InvalidSessionException();
        }
        this.updateDQPContext(sessionInfo);
    }
}

