/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.StorageManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.util.ExternalizeUtil;
import org.teiid.netty.handler.codec.serialization.CompactObjectInputStream;

public class ObjectDecoder
extends FrameDecoder {
    public static final long MAX_LOB_SIZE = 0x100000000L;
    private final int maxObjectSize;
    private final ClassLoader classLoader;
    private Object result;
    private int streamIndex;
    private OutputStream stream;
    private List<InputStreamFactory.StreamFactoryReference> streams;
    private StorageManager storageManager;
    private FileStore store;

    public ObjectDecoder(int maxObjectSize, ClassLoader classLoader, StorageManager storageManager) {
        if (maxObjectSize <= 0) {
            throw new IllegalArgumentException("maxObjectSize: " + maxObjectSize);
        }
        this.maxObjectSize = maxObjectSize;
        this.classLoader = classLoader;
        this.storageManager = storageManager;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        int dataLen;
        if (this.result == null) {
            if (buffer.readableBytes() < 4) {
                return null;
            }
            dataLen = buffer.getInt(buffer.readerIndex());
            if (dataLen <= 0) {
                throw new StreamCorruptedException("invalid data length: " + dataLen);
            }
            if (dataLen > this.maxObjectSize) {
                throw new StreamCorruptedException("data length too big: " + dataLen + " (max: " + this.maxObjectSize + ')');
            }
            if (buffer.readableBytes() < dataLen + 4) {
                return null;
            }
            buffer.skipBytes(4);
            CompactObjectInputStream cois = new CompactObjectInputStream((InputStream)new ChannelBufferInputStream(buffer, dataLen), this.classLoader);
            this.result = cois.readObject();
            this.streams = ExternalizeUtil.readList((ObjectInput)cois, InputStreamFactory.StreamFactoryReference.class);
            this.streamIndex = 0;
        }
        while (this.streamIndex < this.streams.size()) {
            if (buffer.readableBytes() < 2) {
                return null;
            }
            dataLen = buffer.getShort(buffer.readerIndex()) & 0xFFFF;
            if (buffer.readableBytes() < dataLen + 2) {
                return null;
            }
            buffer.skipBytes(2);
            if (this.stream == null) {
                this.store = this.storageManager.createFileStore("temp-stream");
                InputStreamFactory.StreamFactoryReference sfr = this.streams.get(this.streamIndex);
                this.store.setCleanupReference((Object)sfr);
                sfr.setStreamFactory(new InputStreamFactory(){
                    FileStore fs;
                    {
                        this.fs = ObjectDecoder.this.store;
                    }

                    public InputStream getInputStream() throws IOException {
                        return new BufferedInputStream(this.fs.createInputStream(0L));
                    }
                });
                this.stream = new BufferedOutputStream(this.store.createOutputStream());
            }
            if (dataLen == 0) {
                this.stream.close();
                this.stream = null;
                ++this.streamIndex;
                continue;
            }
            if (this.store.getLength() + (long)dataLen > 0x100000000L) {
                throw new StreamCorruptedException("lob too big: " + this.store.getLength() + dataLen + " (max: " + 0x100000000L + ')');
            }
            buffer.readBytes(this.stream, dataLen);
        }
        Object toReturn = this.result;
        this.result = null;
        this.streams = null;
        this.stream = null;
        this.store = null;
        return toReturn;
    }
}

