/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Properties;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.teiid.logging.LogManager;
import org.teiid.net.socket.ServiceInvocationStruct;
import org.teiid.odbc.ODBCServerRemote;

public class PgFrontendProtocol
extends FrameDecoder {
    private int maxObjectSize;
    private Byte messageType;
    private Integer dataLength;
    private boolean initialized = false;
    private String encoding = "UTF-8";
    private ODBCServerRemote odbcProxy;
    private ServiceInvocationStruct message;
    private String user;
    private String databaseName;

    public PgFrontendProtocol(int maxObjectSize) {
        if (maxObjectSize <= 0) {
            throw new IllegalArgumentException("maxObjectSize: " + maxObjectSize);
        }
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        this.maxObjectSize = maxObjectSize;
        this.odbcProxy = (ODBCServerRemote)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{ODBCServerRemote.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                PgFrontendProtocol.this.message = new ServiceInvocationStruct(args, method.getName(), ODBCServerRemote.class);
                return null;
            }
        });
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        if (this.initialized && this.messageType == null) {
            if (buffer.readableBytes() < 1) {
                return null;
            }
            this.messageType = buffer.readByte();
            if (this.messageType < 0) {
                this.odbcProxy.terminate();
                return this.message;
            }
        }
        if (!this.initialized) {
            this.messageType = 73;
        }
        if (this.dataLength == null) {
            if (buffer.readableBytes() < 4) {
                return null;
            }
            this.dataLength = buffer.readInt();
            if (this.dataLength <= 0) {
                throw new StreamCorruptedException("invalid data length: " + this.dataLength);
            }
            if (this.dataLength > this.maxObjectSize) {
                throw new StreamCorruptedException("data length too big: " + this.dataLength + " (max: " + this.maxObjectSize + ')');
            }
        }
        if (buffer.readableBytes() < this.dataLength - 4) {
            return null;
        }
        byte[] data = this.createByteArray(this.dataLength - 4);
        buffer.readBytes(data);
        Object message = this.createRequestMessage(this.messageType, new NullTerminatedStringDataInputStream(new DataInputStream(new ByteArrayInputStream(data, 0, this.dataLength - 4)), this.encoding));
        this.dataLength = null;
        this.messageType = null;
        return message;
    }

    private Object createRequestMessage(byte messageType, NullTerminatedStringDataInputStream data) throws IOException {
        switch (messageType) {
            case 73: {
                this.initialized = true;
                return this.buildInitialize(data);
            }
            case 112: {
                return this.buildLogin(data);
            }
            case 80: {
                return this.buildParse(data);
            }
            case 66: {
                return this.buildBind(data);
            }
            case 69: {
                return this.buildExecute(data);
            }
            case 81: {
                return this.buildExecuteQuery(data);
            }
            case 68: {
                return this.buildDescribe(data);
            }
            case 88: {
                return this.buildTeminate();
            }
            case 83: {
                return this.buildSync();
            }
            case 67: {
                return this.buildClose(data);
            }
            case 72: {
                return this.buildFlush();
            }
        }
        return this.buildError();
    }

    private Object buildError() {
        PgFrontendProtocol.trace("error");
        this.odbcProxy.unsupportedOperation("option not suported");
        return this.message;
    }

    private Object buildFlush() {
        PgFrontendProtocol.trace("flush");
        this.odbcProxy.flush();
        return this.message;
    }

    private Object buildTeminate() {
        PgFrontendProtocol.trace("terminate");
        this.odbcProxy.terminate();
        return this.message;
    }

    private Object buildInitialize(NullTerminatedStringDataInputStream data) throws IOException {
        String param;
        PgFrontendProtocol.trace("Init");
        Properties props = new Properties();
        int version = data.readInt();
        props.setProperty("version", Integer.toString(version));
        PgFrontendProtocol.trace("StartupMessage");
        PgFrontendProtocol.trace(" version " + version + " (" + (version >> 16) + "." + (version & 0xFF) + ")");
        while ((param = data.readString()).length() != 0) {
            String value = data.readString();
            props.setProperty(param, value);
            PgFrontendProtocol.trace(" param " + param + "=" + value);
        }
        this.user = props.getProperty("user");
        this.databaseName = props.getProperty("database");
        this.encoding = props.getProperty("client_encoding", "UTF-8");
        this.odbcProxy.initialize(props);
        return this.message;
    }

    private Object buildLogin(NullTerminatedStringDataInputStream data) throws IOException {
        PgFrontendProtocol.trace("PasswordMessage");
        String password = data.readString();
        this.odbcProxy.logon(this.databaseName, this.user, password);
        return this.message;
    }

    private Object buildParse(NullTerminatedStringDataInputStream data) throws IOException {
        PgFrontendProtocol.trace("Parse");
        String name = data.readString();
        String sql = data.readString();
        int count = data.readShort();
        int[] paramType = new int[count];
        for (int i = 0; i < count; ++i) {
            int type;
            paramType[i] = type = data.readInt();
        }
        this.odbcProxy.prepare(name, sql, paramType);
        return this.message;
    }

    private Object buildBind(NullTerminatedStringDataInputStream data) throws IOException {
        PgFrontendProtocol.trace("Bind");
        String bindName = data.readString();
        String prepName = data.readString();
        int formatCodeCount = data.readShort();
        int[] formatCodes = new int[formatCodeCount];
        for (int i = 0; i < formatCodeCount; ++i) {
            formatCodes[i] = data.readShort();
        }
        int paramCount = data.readShort();
        Object[] params = new String[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            int paramLen = data.readInt();
            byte[] paramdata = this.createByteArray(paramLen);
            data.readFully(paramdata);
            params[i] = formatCodeCount == 0 || formatCodeCount == 1 && formatCodes[0] == 0 || formatCodes[i] == 0 ? new String(paramdata, this.encoding) : (Object)paramdata;
        }
        int resultCodeCount = data.readShort();
        int[] resultColumnFormat = new int[resultCodeCount];
        for (int i = 0; i < resultCodeCount; ++i) {
            resultColumnFormat[i] = data.readShort();
        }
        this.odbcProxy.bindParameters(bindName, prepName, paramCount, params, resultCodeCount, resultColumnFormat);
        return this.message;
    }

    private Object buildExecute(NullTerminatedStringDataInputStream data) throws IOException {
        String portalName = data.readString();
        PgFrontendProtocol.trace("Execute " + portalName);
        short maxRows = data.readShort();
        this.odbcProxy.execute(portalName, maxRows);
        return this.message;
    }

    private Object buildDescribe(NullTerminatedStringDataInputStream data) throws IOException {
        char type = (char)data.readByte();
        String name = data.readString();
        PgFrontendProtocol.trace("Describe");
        if (type == 'S') {
            this.odbcProxy.getParameterDescription(name);
            return this.message;
        }
        if (type == 'P') {
            this.odbcProxy.getResultSetMetaDataDescription(name);
            return this.message;
        }
        PgFrontendProtocol.trace("expected S or P, got " + type);
        this.odbcProxy.unsupportedOperation("expected S or P");
        return this.message;
    }

    private Object buildSync() {
        PgFrontendProtocol.trace("sync");
        this.odbcProxy.sync();
        return this.message;
    }

    private Object buildExecuteQuery(NullTerminatedStringDataInputStream data) throws IOException {
        String query = data.readString();
        PgFrontendProtocol.trace("Query:" + query);
        this.odbcProxy.executeQuery(query);
        return this.message;
    }

    private byte[] createByteArray(int length) throws StreamCorruptedException {
        try {
            return new byte[length];
        }
        catch (OutOfMemoryError e) {
            throw new StreamCorruptedException("data too big: " + e.getMessage());
        }
    }

    private Object buildClose(NullTerminatedStringDataInputStream data) throws IOException {
        char type = (char)data.read();
        String name = data.readString();
        if (type == 'S') {
            this.odbcProxy.closePreparedStatement(name);
        } else if (type == 'P') {
            this.odbcProxy.closeBoundStatement(name);
        } else {
            this.odbcProxy.unsupportedOperation("unknown close type specified");
        }
        return this.message;
    }

    private static void trace(String msg) {
        LogManager.logTrace((String)"org.teiid.ODBC", (Object[])new Object[]{msg});
    }

    static class NullTerminatedStringDataInputStream
    extends DataInputStream {
        private String encoding;

        public NullTerminatedStringDataInputStream(DataInputStream in, String encoding) {
            super(in);
            this.encoding = encoding;
        }

        public String readString() throws IOException {
            int x;
            ByteArrayOutputStream buff = new ByteArrayOutputStream();
            while ((x = this.read()) > 0) {
                buff.write(x);
            }
            return new String(buff.toByteArray(), this.encoding);
        }
    }
}

