/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.util.Map;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.templates.TranslatorTemplateInfoFactory;
import org.teiid.translator.TranslatorProperty;

public class TestManagedPropertyUtil {
    @Test
    public void testAnnotationProcessing() throws Exception {
        FakeExecutionFactory ef = new FakeExecutionFactory();
        Map properties = TranslatorTemplateInfoFactory.getProperties(ef.getClass());
        ManagedProperty mp = (ManagedProperty)properties.get("readonly");
        Assert.assertTrue((boolean)mp.isReadOnly());
        Assert.assertEquals((Object)1, (Object)MetaValueFactory.getInstance().unwrap(mp.getDefaultValue()));
        mp = (ManagedProperty)properties.get("x");
        Assert.assertFalse((boolean)mp.isReadOnly());
        Assert.assertNull((Object)mp.getDefaultValue());
        mp = (ManagedProperty)properties.get("Enum");
        Assert.assertFalse((boolean)mp.isReadOnly());
        Assert.assertEquals((Object)FakeExecutionFactory.PropEnum.A.name(), (Object)MetaValueFactory.getInstance().unwrap(mp.getDefaultValue()));
    }

    public static class FakeExecutionFactory {
        private PropEnum val = PropEnum.A;

        @TranslatorProperty(display="Read Only")
        public int readonly() {
            return 1;
        }

        @TranslatorProperty(display="Setter Property")
        public void x(String y) {
        }

        @TranslatorProperty(display="Enum Property")
        public PropEnum getEnum() {
            return this.val;
        }

        public void setEnum(PropEnum value) {
            this.val = value;
        }

        public static enum PropEnum {
            A,
            B,
            C;

        }
    }
}

